<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Foundation.QueuedWorkItem StructType
 * @subpackage Structs
 */
class Foundation_QueuedWorkItem extends VolatileEntity
{
    /**
     * The DataClrTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataClrTypeName;
    /**
     * The DataSerializedXml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataSerializedXml;
    /**
     * The DequeuedAtUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DequeuedAtUtc;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EnqueuedAtUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnqueuedAtUtc;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemId;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The ProcessDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessDefinitionId;
    /**
     * The ProcessDuration
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $ProcessDuration;
    /**
     * The ProcessedAtUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessedAtUtc;
    /**
     * The ProcessInstanceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessInstanceName;
    /**
     * The ProcessNodeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessNodeName;
    /**
     * The RetryCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetryCount;
    /**
     * The ScheduledToUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScheduledToUtc;
    /**
     * The SenderAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SenderAuditId;
    /**
     * The SenderOrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SenderOrganizationUnitId;
    /**
     * The SenderSecurityTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SenderSecurityTokenId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The StateDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateDescription;
    /**
     * Constructor method for Foundation.QueuedWorkItem
     * @uses Foundation_QueuedWorkItem::setDataClrTypeName()
     * @uses Foundation_QueuedWorkItem::setDataSerializedXml()
     * @uses Foundation_QueuedWorkItem::setDequeuedAtUtc()
     * @uses Foundation_QueuedWorkItem::setDescription()
     * @uses Foundation_QueuedWorkItem::setEnqueuedAtUtc()
     * @uses Foundation_QueuedWorkItem::setItemId()
     * @uses Foundation_QueuedWorkItem::setPriority()
     * @uses Foundation_QueuedWorkItem::setProcessDefinitionId()
     * @uses Foundation_QueuedWorkItem::setProcessDuration()
     * @uses Foundation_QueuedWorkItem::setProcessedAtUtc()
     * @uses Foundation_QueuedWorkItem::setProcessInstanceName()
     * @uses Foundation_QueuedWorkItem::setProcessNodeName()
     * @uses Foundation_QueuedWorkItem::setRetryCount()
     * @uses Foundation_QueuedWorkItem::setScheduledToUtc()
     * @uses Foundation_QueuedWorkItem::setSenderAuditId()
     * @uses Foundation_QueuedWorkItem::setSenderOrganizationUnitId()
     * @uses Foundation_QueuedWorkItem::setSenderSecurityTokenId()
     * @uses Foundation_QueuedWorkItem::setState()
     * @uses Foundation_QueuedWorkItem::setStateDescription()
     * @param string $dataClrTypeName
     * @param string $dataSerializedXml
     * @param string $dequeuedAtUtc
     * @param string $description
     * @param string $enqueuedAtUtc
     * @param string $itemId
     * @param int $priority
     * @param string $processDefinitionId
     * @param string $processDuration
     * @param string $processedAtUtc
     * @param string $processInstanceName
     * @param string $processNodeName
     * @param int $retryCount
     * @param string $scheduledToUtc
     * @param int $senderAuditId
     * @param string $senderOrganizationUnitId
     * @param string $senderSecurityTokenId
     * @param string $state
     * @param string $stateDescription
     */
    public function __construct($dataClrTypeName = null, $dataSerializedXml = null, $dequeuedAtUtc = null, $description = null, $enqueuedAtUtc = null, $itemId = null, $priority = null, $processDefinitionId = null, $processDuration = null, $processedAtUtc = null, $processInstanceName = null, $processNodeName = null, $retryCount = null, $scheduledToUtc = null, $senderAuditId = null, $senderOrganizationUnitId = null, $senderSecurityTokenId = null, $state = null, $stateDescription = null)
    {
        $this
            ->setDataClrTypeName($dataClrTypeName)
            ->setDataSerializedXml($dataSerializedXml)
            ->setDequeuedAtUtc($dequeuedAtUtc)
            ->setDescription($description)
            ->setEnqueuedAtUtc($enqueuedAtUtc)
            ->setItemId($itemId)
            ->setPriority($priority)
            ->setProcessDefinitionId($processDefinitionId)
            ->setProcessDuration($processDuration)
            ->setProcessedAtUtc($processedAtUtc)
            ->setProcessInstanceName($processInstanceName)
            ->setProcessNodeName($processNodeName)
            ->setRetryCount($retryCount)
            ->setScheduledToUtc($scheduledToUtc)
            ->setSenderAuditId($senderAuditId)
            ->setSenderOrganizationUnitId($senderOrganizationUnitId)
            ->setSenderSecurityTokenId($senderSecurityTokenId)
            ->setState($state)
            ->setStateDescription($stateDescription);
    }
    /**
     * Get DataClrTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataClrTypeName()
    {
        return isset($this->DataClrTypeName) ? $this->DataClrTypeName : null;
    }
    /**
     * Set DataClrTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataClrTypeName
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setDataClrTypeName($dataClrTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($dataClrTypeName) && !is_string($dataClrTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataClrTypeName, true), gettype($dataClrTypeName)), __LINE__);
        }
        if (is_null($dataClrTypeName) || (is_array($dataClrTypeName) && empty($dataClrTypeName))) {
            unset($this->DataClrTypeName);
        } else {
            $this->DataClrTypeName = $dataClrTypeName;
        }
        return $this;
    }
    /**
     * Get DataSerializedXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataSerializedXml()
    {
        return isset($this->DataSerializedXml) ? $this->DataSerializedXml : null;
    }
    /**
     * Set DataSerializedXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataSerializedXml
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setDataSerializedXml($dataSerializedXml = null)
    {
        // validation for constraint: string
        if (!is_null($dataSerializedXml) && !is_string($dataSerializedXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataSerializedXml, true), gettype($dataSerializedXml)), __LINE__);
        }
        if (is_null($dataSerializedXml) || (is_array($dataSerializedXml) && empty($dataSerializedXml))) {
            unset($this->DataSerializedXml);
        } else {
            $this->DataSerializedXml = $dataSerializedXml;
        }
        return $this;
    }
    /**
     * Get DequeuedAtUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDequeuedAtUtc()
    {
        return isset($this->DequeuedAtUtc) ? $this->DequeuedAtUtc : null;
    }
    /**
     * Set DequeuedAtUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dequeuedAtUtc
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setDequeuedAtUtc($dequeuedAtUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dequeuedAtUtc) && !is_string($dequeuedAtUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dequeuedAtUtc, true), gettype($dequeuedAtUtc)), __LINE__);
        }
        if (is_null($dequeuedAtUtc) || (is_array($dequeuedAtUtc) && empty($dequeuedAtUtc))) {
            unset($this->DequeuedAtUtc);
        } else {
            $this->DequeuedAtUtc = $dequeuedAtUtc;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EnqueuedAtUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnqueuedAtUtc()
    {
        return isset($this->EnqueuedAtUtc) ? $this->EnqueuedAtUtc : null;
    }
    /**
     * Set EnqueuedAtUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enqueuedAtUtc
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setEnqueuedAtUtc($enqueuedAtUtc = null)
    {
        // validation for constraint: string
        if (!is_null($enqueuedAtUtc) && !is_string($enqueuedAtUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enqueuedAtUtc, true), gettype($enqueuedAtUtc)), __LINE__);
        }
        if (is_null($enqueuedAtUtc) || (is_array($enqueuedAtUtc) && empty($enqueuedAtUtc))) {
            unset($this->EnqueuedAtUtc);
        } else {
            $this->EnqueuedAtUtc = $enqueuedAtUtc;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemId
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemId, true)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get ProcessDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessDefinitionId()
    {
        return isset($this->ProcessDefinitionId) ? $this->ProcessDefinitionId : null;
    }
    /**
     * Set ProcessDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processDefinitionId
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setProcessDefinitionId($processDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($processDefinitionId) && !is_string($processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processDefinitionId, true), gettype($processDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processDefinitionId, true)), __LINE__);
        }
        if (is_null($processDefinitionId) || (is_array($processDefinitionId) && empty($processDefinitionId))) {
            unset($this->ProcessDefinitionId);
        } else {
            $this->ProcessDefinitionId = $processDefinitionId;
        }
        return $this;
    }
    /**
     * Get ProcessDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessDuration()
    {
        return isset($this->ProcessDuration) ? $this->ProcessDuration : null;
    }
    /**
     * Set ProcessDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processDuration
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setProcessDuration($processDuration = null)
    {
        // validation for constraint: string
        if (!is_null($processDuration) && !is_string($processDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processDuration, true), gettype($processDuration)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($processDuration) && false === mb_strpos($processDuration, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $processDuration)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($processDuration, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($processDuration) && false !== mb_strpos($processDuration, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $processDuration)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($processDuration, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($processDuration) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $processDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($processDuration, true)), __LINE__);
        }
        if (is_null($processDuration) || (is_array($processDuration) && empty($processDuration))) {
            unset($this->ProcessDuration);
        } else {
            $this->ProcessDuration = $processDuration;
        }
        return $this;
    }
    /**
     * Get ProcessedAtUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessedAtUtc()
    {
        return isset($this->ProcessedAtUtc) ? $this->ProcessedAtUtc : null;
    }
    /**
     * Set ProcessedAtUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processedAtUtc
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setProcessedAtUtc($processedAtUtc = null)
    {
        // validation for constraint: string
        if (!is_null($processedAtUtc) && !is_string($processedAtUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processedAtUtc, true), gettype($processedAtUtc)), __LINE__);
        }
        if (is_null($processedAtUtc) || (is_array($processedAtUtc) && empty($processedAtUtc))) {
            unset($this->ProcessedAtUtc);
        } else {
            $this->ProcessedAtUtc = $processedAtUtc;
        }
        return $this;
    }
    /**
     * Get ProcessInstanceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessInstanceName()
    {
        return isset($this->ProcessInstanceName) ? $this->ProcessInstanceName : null;
    }
    /**
     * Set ProcessInstanceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processInstanceName
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setProcessInstanceName($processInstanceName = null)
    {
        // validation for constraint: string
        if (!is_null($processInstanceName) && !is_string($processInstanceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processInstanceName, true), gettype($processInstanceName)), __LINE__);
        }
        if (is_null($processInstanceName) || (is_array($processInstanceName) && empty($processInstanceName))) {
            unset($this->ProcessInstanceName);
        } else {
            $this->ProcessInstanceName = $processInstanceName;
        }
        return $this;
    }
    /**
     * Get ProcessNodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessNodeName()
    {
        return isset($this->ProcessNodeName) ? $this->ProcessNodeName : null;
    }
    /**
     * Set ProcessNodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processNodeName
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setProcessNodeName($processNodeName = null)
    {
        // validation for constraint: string
        if (!is_null($processNodeName) && !is_string($processNodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processNodeName, true), gettype($processNodeName)), __LINE__);
        }
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->ProcessNodeName);
        } else {
            $this->ProcessNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get RetryCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetryCount()
    {
        return isset($this->RetryCount) ? $this->RetryCount : null;
    }
    /**
     * Set RetryCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retryCount
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setRetryCount($retryCount = null)
    {
        // validation for constraint: int
        if (!is_null($retryCount) && !(is_int($retryCount) || ctype_digit($retryCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retryCount, true), gettype($retryCount)), __LINE__);
        }
        if (is_null($retryCount) || (is_array($retryCount) && empty($retryCount))) {
            unset($this->RetryCount);
        } else {
            $this->RetryCount = $retryCount;
        }
        return $this;
    }
    /**
     * Get ScheduledToUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScheduledToUtc()
    {
        return isset($this->ScheduledToUtc) ? $this->ScheduledToUtc : null;
    }
    /**
     * Set ScheduledToUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scheduledToUtc
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setScheduledToUtc($scheduledToUtc = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledToUtc) && !is_string($scheduledToUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledToUtc, true), gettype($scheduledToUtc)), __LINE__);
        }
        if (is_null($scheduledToUtc) || (is_array($scheduledToUtc) && empty($scheduledToUtc))) {
            unset($this->ScheduledToUtc);
        } else {
            $this->ScheduledToUtc = $scheduledToUtc;
        }
        return $this;
    }
    /**
     * Get SenderAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSenderAuditId()
    {
        return isset($this->SenderAuditId) ? $this->SenderAuditId : null;
    }
    /**
     * Set SenderAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $senderAuditId
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setSenderAuditId($senderAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($senderAuditId) && !(is_int($senderAuditId) || ctype_digit($senderAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($senderAuditId, true), gettype($senderAuditId)), __LINE__);
        }
        if (is_null($senderAuditId) || (is_array($senderAuditId) && empty($senderAuditId))) {
            unset($this->SenderAuditId);
        } else {
            $this->SenderAuditId = $senderAuditId;
        }
        return $this;
    }
    /**
     * Get SenderOrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderOrganizationUnitId()
    {
        return isset($this->SenderOrganizationUnitId) ? $this->SenderOrganizationUnitId : null;
    }
    /**
     * Set SenderOrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderOrganizationUnitId
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setSenderOrganizationUnitId($senderOrganizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($senderOrganizationUnitId) && !is_string($senderOrganizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderOrganizationUnitId, true), gettype($senderOrganizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($senderOrganizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $senderOrganizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($senderOrganizationUnitId, true)), __LINE__);
        }
        if (is_null($senderOrganizationUnitId) || (is_array($senderOrganizationUnitId) && empty($senderOrganizationUnitId))) {
            unset($this->SenderOrganizationUnitId);
        } else {
            $this->SenderOrganizationUnitId = $senderOrganizationUnitId;
        }
        return $this;
    }
    /**
     * Get SenderSecurityTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderSecurityTokenId()
    {
        return isset($this->SenderSecurityTokenId) ? $this->SenderSecurityTokenId : null;
    }
    /**
     * Set SenderSecurityTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderSecurityTokenId
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setSenderSecurityTokenId($senderSecurityTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($senderSecurityTokenId) && !is_string($senderSecurityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderSecurityTokenId, true), gettype($senderSecurityTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($senderSecurityTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $senderSecurityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($senderSecurityTokenId, true)), __LINE__);
        }
        if (is_null($senderSecurityTokenId) || (is_array($senderSecurityTokenId) && empty($senderSecurityTokenId))) {
            unset($this->SenderSecurityTokenId);
        } else {
            $this->SenderSecurityTokenId = $senderSecurityTokenId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\QueuedWorkItemState::valueIsValid()
     * @uses \patest\EnumType\QueuedWorkItemState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\QueuedWorkItemState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\QueuedWorkItemState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\QueuedWorkItemState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get StateDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateDescription()
    {
        return isset($this->StateDescription) ? $this->StateDescription : null;
    }
    /**
     * Set StateDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateDescription
     * @return \patest\StructType\Foundation_QueuedWorkItem
     */
    public function setStateDescription($stateDescription = null)
    {
        // validation for constraint: string
        if (!is_null($stateDescription) && !is_string($stateDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateDescription, true), gettype($stateDescription)), __LINE__);
        }
        if (is_null($stateDescription) || (is_array($stateDescription) && empty($stateDescription))) {
            unset($this->StateDescription);
        } else {
            $this->StateDescription = $stateDescription;
        }
        return $this;
    }
}
