<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForwardTickets-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ForwardTickets-Request
 * @subpackage Structs
 */
class ForwardTickets_Request extends ExtensibleDataContract
{
    /**
     * The NewOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewOwnerId;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TicketIds;
    /**
     * Constructor method for ForwardTickets-Request
     * @uses ForwardTickets_Request::setNewOwnerId()
     * @uses ForwardTickets_Request::setTicketIds()
     * @param string $newOwnerId
     * @param \patest\ArrayType\ArrayOfguid $ticketIds
     */
    public function __construct($newOwnerId = null, \patest\ArrayType\ArrayOfguid $ticketIds = null)
    {
        $this
            ->setNewOwnerId($newOwnerId)
            ->setTicketIds($ticketIds);
    }
    /**
     * Get NewOwnerId value
     * @return string|null
     */
    public function getNewOwnerId()
    {
        return $this->NewOwnerId;
    }
    /**
     * Set NewOwnerId value
     * @param string $newOwnerId
     * @return \patest\StructType\ForwardTickets_Request
     */
    public function setNewOwnerId($newOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($newOwnerId) && !is_string($newOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOwnerId, true), gettype($newOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newOwnerId, true)), __LINE__);
        }
        $this->NewOwnerId = $newOwnerId;
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $ticketIds
     * @return \patest\StructType\ForwardTickets_Request
     */
    public function setTicketIds(\patest\ArrayType\ArrayOfguid $ticketIds = null)
    {
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
}
