<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventPerformerDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventPerformerDescription
 * @subpackage Structs
 */
class EventPerformerDescription extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * The PerformerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PerformerType;
    /**
     * The SgoPerformerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SgoPerformerId;
    /**
     * Constructor method for EventPerformerDescription
     * @uses EventPerformerDescription::setName()
     * @uses EventPerformerDescription::setOrdinal()
     * @uses EventPerformerDescription::setPerformerType()
     * @uses EventPerformerDescription::setSgoPerformerId()
     * @param string $name
     * @param int $ordinal
     * @param string $performerType
     * @param int $sgoPerformerId
     */
    public function __construct($name = null, $ordinal = null, $performerType = null, $sgoPerformerId = null)
    {
        $this
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setPerformerType($performerType)
            ->setSgoPerformerId($sgoPerformerId);
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\EventPerformerDescription
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \patest\StructType\EventPerformerDescription
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Get PerformerType value
     * @return string|null
     */
    public function getPerformerType()
    {
        return $this->PerformerType;
    }
    /**
     * Set PerformerType value
     * @uses \patest\EnumType\PerformerType::valueIsValid()
     * @uses \patest\EnumType\PerformerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $performerType
     * @return \patest\StructType\EventPerformerDescription
     */
    public function setPerformerType($performerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PerformerType::valueIsValid($performerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PerformerType', is_array($performerType) ? implode(', ', $performerType) : var_export($performerType, true), implode(', ', \patest\EnumType\PerformerType::getValidValues())), __LINE__);
        }
        $this->PerformerType = $performerType;
        return $this;
    }
    /**
     * Get SgoPerformerId value
     * @return int|null
     */
    public function getSgoPerformerId()
    {
        return $this->SgoPerformerId;
    }
    /**
     * Set SgoPerformerId value
     * @param int $sgoPerformerId
     * @return \patest\StructType\EventPerformerDescription
     */
    public function setSgoPerformerId($sgoPerformerId = null)
    {
        // validation for constraint: int
        if (!is_null($sgoPerformerId) && !(is_int($sgoPerformerId) || ctype_digit($sgoPerformerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sgoPerformerId, true), gettype($sgoPerformerId)), __LINE__);
        }
        $this->SgoPerformerId = $sgoPerformerId;
        return $this;
    }
}
