<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventLevelImageConfiguration StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventLevelImageConfiguration
 * @subpackage Structs
 */
class EventLevelImageConfiguration extends ExtensibleDataContract
{
    /**
     * The AllLabelsOpaque
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllLabelsOpaque;
    /**
     * The BackgroundColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BackgroundColor;
    /**
     * The CompactImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompactImageUrl;
    /**
     * The EventHeaderTitleOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventHeaderTitleOverride;
    /**
     * The EventListTitleOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventListTitleOverride;
    /**
     * The FlattenedImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlattenedImageUrl;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The TextColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TextColor;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for EventLevelImageConfiguration
     * @uses EventLevelImageConfiguration::setAllLabelsOpaque()
     * @uses EventLevelImageConfiguration::setBackgroundColor()
     * @uses EventLevelImageConfiguration::setCompactImageUrl()
     * @uses EventLevelImageConfiguration::setEventHeaderTitleOverride()
     * @uses EventLevelImageConfiguration::setEventListTitleOverride()
     * @uses EventLevelImageConfiguration::setFlattenedImageUrl()
     * @uses EventLevelImageConfiguration::setName()
     * @uses EventLevelImageConfiguration::setTextColor()
     * @uses EventLevelImageConfiguration::setType()
     * @param bool $allLabelsOpaque
     * @param string $backgroundColor
     * @param string $compactImageUrl
     * @param string $eventHeaderTitleOverride
     * @param string $eventListTitleOverride
     * @param string $flattenedImageUrl
     * @param string $name
     * @param string $textColor
     * @param string $type
     */
    public function __construct($allLabelsOpaque = null, $backgroundColor = null, $compactImageUrl = null, $eventHeaderTitleOverride = null, $eventListTitleOverride = null, $flattenedImageUrl = null, $name = null, $textColor = null, $type = null)
    {
        $this
            ->setAllLabelsOpaque($allLabelsOpaque)
            ->setBackgroundColor($backgroundColor)
            ->setCompactImageUrl($compactImageUrl)
            ->setEventHeaderTitleOverride($eventHeaderTitleOverride)
            ->setEventListTitleOverride($eventListTitleOverride)
            ->setFlattenedImageUrl($flattenedImageUrl)
            ->setName($name)
            ->setTextColor($textColor)
            ->setType($type);
    }
    /**
     * Get AllLabelsOpaque value
     * @return bool|null
     */
    public function getAllLabelsOpaque()
    {
        return $this->AllLabelsOpaque;
    }
    /**
     * Set AllLabelsOpaque value
     * @param bool $allLabelsOpaque
     * @return \patest\StructType\EventLevelImageConfiguration
     */
    public function setAllLabelsOpaque($allLabelsOpaque = null)
    {
        // validation for constraint: boolean
        if (!is_null($allLabelsOpaque) && !is_bool($allLabelsOpaque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allLabelsOpaque, true), gettype($allLabelsOpaque)), __LINE__);
        }
        $this->AllLabelsOpaque = $allLabelsOpaque;
        return $this;
    }
    /**
     * Get BackgroundColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackgroundColor()
    {
        return isset($this->BackgroundColor) ? $this->BackgroundColor : null;
    }
    /**
     * Set BackgroundColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backgroundColor
     * @return \patest\StructType\EventLevelImageConfiguration
     */
    public function setBackgroundColor($backgroundColor = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundColor) && !is_string($backgroundColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backgroundColor, true), gettype($backgroundColor)), __LINE__);
        }
        if (is_null($backgroundColor) || (is_array($backgroundColor) && empty($backgroundColor))) {
            unset($this->BackgroundColor);
        } else {
            $this->BackgroundColor = $backgroundColor;
        }
        return $this;
    }
    /**
     * Get CompactImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompactImageUrl()
    {
        return isset($this->CompactImageUrl) ? $this->CompactImageUrl : null;
    }
    /**
     * Set CompactImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $compactImageUrl
     * @return \patest\StructType\EventLevelImageConfiguration
     */
    public function setCompactImageUrl($compactImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($compactImageUrl) && !is_string($compactImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compactImageUrl, true), gettype($compactImageUrl)), __LINE__);
        }
        if (is_null($compactImageUrl) || (is_array($compactImageUrl) && empty($compactImageUrl))) {
            unset($this->CompactImageUrl);
        } else {
            $this->CompactImageUrl = $compactImageUrl;
        }
        return $this;
    }
    /**
     * Get EventHeaderTitleOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventHeaderTitleOverride()
    {
        return isset($this->EventHeaderTitleOverride) ? $this->EventHeaderTitleOverride : null;
    }
    /**
     * Set EventHeaderTitleOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventHeaderTitleOverride
     * @return \patest\StructType\EventLevelImageConfiguration
     */
    public function setEventHeaderTitleOverride($eventHeaderTitleOverride = null)
    {
        // validation for constraint: string
        if (!is_null($eventHeaderTitleOverride) && !is_string($eventHeaderTitleOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventHeaderTitleOverride, true), gettype($eventHeaderTitleOverride)), __LINE__);
        }
        if (is_null($eventHeaderTitleOverride) || (is_array($eventHeaderTitleOverride) && empty($eventHeaderTitleOverride))) {
            unset($this->EventHeaderTitleOverride);
        } else {
            $this->EventHeaderTitleOverride = $eventHeaderTitleOverride;
        }
        return $this;
    }
    /**
     * Get EventListTitleOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventListTitleOverride()
    {
        return isset($this->EventListTitleOverride) ? $this->EventListTitleOverride : null;
    }
    /**
     * Set EventListTitleOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventListTitleOverride
     * @return \patest\StructType\EventLevelImageConfiguration
     */
    public function setEventListTitleOverride($eventListTitleOverride = null)
    {
        // validation for constraint: string
        if (!is_null($eventListTitleOverride) && !is_string($eventListTitleOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventListTitleOverride, true), gettype($eventListTitleOverride)), __LINE__);
        }
        if (is_null($eventListTitleOverride) || (is_array($eventListTitleOverride) && empty($eventListTitleOverride))) {
            unset($this->EventListTitleOverride);
        } else {
            $this->EventListTitleOverride = $eventListTitleOverride;
        }
        return $this;
    }
    /**
     * Get FlattenedImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlattenedImageUrl()
    {
        return isset($this->FlattenedImageUrl) ? $this->FlattenedImageUrl : null;
    }
    /**
     * Set FlattenedImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flattenedImageUrl
     * @return \patest\StructType\EventLevelImageConfiguration
     */
    public function setFlattenedImageUrl($flattenedImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($flattenedImageUrl) && !is_string($flattenedImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flattenedImageUrl, true), gettype($flattenedImageUrl)), __LINE__);
        }
        if (is_null($flattenedImageUrl) || (is_array($flattenedImageUrl) && empty($flattenedImageUrl))) {
            unset($this->FlattenedImageUrl);
        } else {
            $this->FlattenedImageUrl = $flattenedImageUrl;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\EventLevelImageConfiguration
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get TextColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTextColor()
    {
        return isset($this->TextColor) ? $this->TextColor : null;
    }
    /**
     * Set TextColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $textColor
     * @return \patest\StructType\EventLevelImageConfiguration
     */
    public function setTextColor($textColor = null)
    {
        // validation for constraint: string
        if (!is_null($textColor) && !is_string($textColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textColor, true), gettype($textColor)), __LINE__);
        }
        if (is_null($textColor) || (is_array($textColor) && empty($textColor))) {
            unset($this->TextColor);
        } else {
            $this->TextColor = $textColor;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \patest\StructType\EventLevelImageConfiguration
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
