<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventHeaderOverrideWithUrls StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventHeaderOverrideWithUrls
 * @subpackage Structs
 */
class EventHeaderOverrideWithUrls extends AbstractStructBase
{
    /**
     * The AllLabelsOpaque
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllLabelsOpaque;
    /**
     * The CompactImageFileType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompactImageFileType;
    /**
     * The CompactImageFileUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompactImageFileUrl;
    /**
     * The CompactImageGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CompactImageGuid;
    /**
     * The EventHeaderTitleOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventHeaderTitleOverride;
    /**
     * The EventListTitleOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventListTitleOverride;
    /**
     * The FlattenedImageFileType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlattenedImageFileType;
    /**
     * The FlattenedImageFileUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlattenedImageFileUrl;
    /**
     * The FlattenedImageGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FlattenedImageGuid;
    /**
     * Constructor method for EventHeaderOverrideWithUrls
     * @uses EventHeaderOverrideWithUrls::setAllLabelsOpaque()
     * @uses EventHeaderOverrideWithUrls::setCompactImageFileType()
     * @uses EventHeaderOverrideWithUrls::setCompactImageFileUrl()
     * @uses EventHeaderOverrideWithUrls::setCompactImageGuid()
     * @uses EventHeaderOverrideWithUrls::setEventHeaderTitleOverride()
     * @uses EventHeaderOverrideWithUrls::setEventListTitleOverride()
     * @uses EventHeaderOverrideWithUrls::setFlattenedImageFileType()
     * @uses EventHeaderOverrideWithUrls::setFlattenedImageFileUrl()
     * @uses EventHeaderOverrideWithUrls::setFlattenedImageGuid()
     * @param bool $allLabelsOpaque
     * @param string $compactImageFileType
     * @param string $compactImageFileUrl
     * @param string $compactImageGuid
     * @param string $eventHeaderTitleOverride
     * @param string $eventListTitleOverride
     * @param string $flattenedImageFileType
     * @param string $flattenedImageFileUrl
     * @param string $flattenedImageGuid
     */
    public function __construct($allLabelsOpaque = null, $compactImageFileType = null, $compactImageFileUrl = null, $compactImageGuid = null, $eventHeaderTitleOverride = null, $eventListTitleOverride = null, $flattenedImageFileType = null, $flattenedImageFileUrl = null, $flattenedImageGuid = null)
    {
        $this
            ->setAllLabelsOpaque($allLabelsOpaque)
            ->setCompactImageFileType($compactImageFileType)
            ->setCompactImageFileUrl($compactImageFileUrl)
            ->setCompactImageGuid($compactImageGuid)
            ->setEventHeaderTitleOverride($eventHeaderTitleOverride)
            ->setEventListTitleOverride($eventListTitleOverride)
            ->setFlattenedImageFileType($flattenedImageFileType)
            ->setFlattenedImageFileUrl($flattenedImageFileUrl)
            ->setFlattenedImageGuid($flattenedImageGuid);
    }
    /**
     * Get AllLabelsOpaque value
     * @return bool|null
     */
    public function getAllLabelsOpaque()
    {
        return $this->AllLabelsOpaque;
    }
    /**
     * Set AllLabelsOpaque value
     * @param bool $allLabelsOpaque
     * @return \patest\StructType\EventHeaderOverrideWithUrls
     */
    public function setAllLabelsOpaque($allLabelsOpaque = null)
    {
        // validation for constraint: boolean
        if (!is_null($allLabelsOpaque) && !is_bool($allLabelsOpaque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allLabelsOpaque, true), gettype($allLabelsOpaque)), __LINE__);
        }
        $this->AllLabelsOpaque = $allLabelsOpaque;
        return $this;
    }
    /**
     * Get CompactImageFileType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompactImageFileType()
    {
        return isset($this->CompactImageFileType) ? $this->CompactImageFileType : null;
    }
    /**
     * Set CompactImageFileType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $compactImageFileType
     * @return \patest\StructType\EventHeaderOverrideWithUrls
     */
    public function setCompactImageFileType($compactImageFileType = null)
    {
        // validation for constraint: string
        if (!is_null($compactImageFileType) && !is_string($compactImageFileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compactImageFileType, true), gettype($compactImageFileType)), __LINE__);
        }
        if (is_null($compactImageFileType) || (is_array($compactImageFileType) && empty($compactImageFileType))) {
            unset($this->CompactImageFileType);
        } else {
            $this->CompactImageFileType = $compactImageFileType;
        }
        return $this;
    }
    /**
     * Get CompactImageFileUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompactImageFileUrl()
    {
        return isset($this->CompactImageFileUrl) ? $this->CompactImageFileUrl : null;
    }
    /**
     * Set CompactImageFileUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $compactImageFileUrl
     * @return \patest\StructType\EventHeaderOverrideWithUrls
     */
    public function setCompactImageFileUrl($compactImageFileUrl = null)
    {
        // validation for constraint: string
        if (!is_null($compactImageFileUrl) && !is_string($compactImageFileUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compactImageFileUrl, true), gettype($compactImageFileUrl)), __LINE__);
        }
        if (is_null($compactImageFileUrl) || (is_array($compactImageFileUrl) && empty($compactImageFileUrl))) {
            unset($this->CompactImageFileUrl);
        } else {
            $this->CompactImageFileUrl = $compactImageFileUrl;
        }
        return $this;
    }
    /**
     * Get CompactImageGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompactImageGuid()
    {
        return isset($this->CompactImageGuid) ? $this->CompactImageGuid : null;
    }
    /**
     * Set CompactImageGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $compactImageGuid
     * @return \patest\StructType\EventHeaderOverrideWithUrls
     */
    public function setCompactImageGuid($compactImageGuid = null)
    {
        // validation for constraint: string
        if (!is_null($compactImageGuid) && !is_string($compactImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compactImageGuid, true), gettype($compactImageGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($compactImageGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $compactImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($compactImageGuid, true)), __LINE__);
        }
        if (is_null($compactImageGuid) || (is_array($compactImageGuid) && empty($compactImageGuid))) {
            unset($this->CompactImageGuid);
        } else {
            $this->CompactImageGuid = $compactImageGuid;
        }
        return $this;
    }
    /**
     * Get EventHeaderTitleOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventHeaderTitleOverride()
    {
        return isset($this->EventHeaderTitleOverride) ? $this->EventHeaderTitleOverride : null;
    }
    /**
     * Set EventHeaderTitleOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventHeaderTitleOverride
     * @return \patest\StructType\EventHeaderOverrideWithUrls
     */
    public function setEventHeaderTitleOverride($eventHeaderTitleOverride = null)
    {
        // validation for constraint: string
        if (!is_null($eventHeaderTitleOverride) && !is_string($eventHeaderTitleOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventHeaderTitleOverride, true), gettype($eventHeaderTitleOverride)), __LINE__);
        }
        if (is_null($eventHeaderTitleOverride) || (is_array($eventHeaderTitleOverride) && empty($eventHeaderTitleOverride))) {
            unset($this->EventHeaderTitleOverride);
        } else {
            $this->EventHeaderTitleOverride = $eventHeaderTitleOverride;
        }
        return $this;
    }
    /**
     * Get EventListTitleOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventListTitleOverride()
    {
        return isset($this->EventListTitleOverride) ? $this->EventListTitleOverride : null;
    }
    /**
     * Set EventListTitleOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventListTitleOverride
     * @return \patest\StructType\EventHeaderOverrideWithUrls
     */
    public function setEventListTitleOverride($eventListTitleOverride = null)
    {
        // validation for constraint: string
        if (!is_null($eventListTitleOverride) && !is_string($eventListTitleOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventListTitleOverride, true), gettype($eventListTitleOverride)), __LINE__);
        }
        if (is_null($eventListTitleOverride) || (is_array($eventListTitleOverride) && empty($eventListTitleOverride))) {
            unset($this->EventListTitleOverride);
        } else {
            $this->EventListTitleOverride = $eventListTitleOverride;
        }
        return $this;
    }
    /**
     * Get FlattenedImageFileType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlattenedImageFileType()
    {
        return isset($this->FlattenedImageFileType) ? $this->FlattenedImageFileType : null;
    }
    /**
     * Set FlattenedImageFileType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flattenedImageFileType
     * @return \patest\StructType\EventHeaderOverrideWithUrls
     */
    public function setFlattenedImageFileType($flattenedImageFileType = null)
    {
        // validation for constraint: string
        if (!is_null($flattenedImageFileType) && !is_string($flattenedImageFileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flattenedImageFileType, true), gettype($flattenedImageFileType)), __LINE__);
        }
        if (is_null($flattenedImageFileType) || (is_array($flattenedImageFileType) && empty($flattenedImageFileType))) {
            unset($this->FlattenedImageFileType);
        } else {
            $this->FlattenedImageFileType = $flattenedImageFileType;
        }
        return $this;
    }
    /**
     * Get FlattenedImageFileUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlattenedImageFileUrl()
    {
        return isset($this->FlattenedImageFileUrl) ? $this->FlattenedImageFileUrl : null;
    }
    /**
     * Set FlattenedImageFileUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flattenedImageFileUrl
     * @return \patest\StructType\EventHeaderOverrideWithUrls
     */
    public function setFlattenedImageFileUrl($flattenedImageFileUrl = null)
    {
        // validation for constraint: string
        if (!is_null($flattenedImageFileUrl) && !is_string($flattenedImageFileUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flattenedImageFileUrl, true), gettype($flattenedImageFileUrl)), __LINE__);
        }
        if (is_null($flattenedImageFileUrl) || (is_array($flattenedImageFileUrl) && empty($flattenedImageFileUrl))) {
            unset($this->FlattenedImageFileUrl);
        } else {
            $this->FlattenedImageFileUrl = $flattenedImageFileUrl;
        }
        return $this;
    }
    /**
     * Get FlattenedImageGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlattenedImageGuid()
    {
        return isset($this->FlattenedImageGuid) ? $this->FlattenedImageGuid : null;
    }
    /**
     * Set FlattenedImageGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flattenedImageGuid
     * @return \patest\StructType\EventHeaderOverrideWithUrls
     */
    public function setFlattenedImageGuid($flattenedImageGuid = null)
    {
        // validation for constraint: string
        if (!is_null($flattenedImageGuid) && !is_string($flattenedImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flattenedImageGuid, true), gettype($flattenedImageGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($flattenedImageGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $flattenedImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($flattenedImageGuid, true)), __LINE__);
        }
        if (is_null($flattenedImageGuid) || (is_array($flattenedImageGuid) && empty($flattenedImageGuid))) {
            unset($this->FlattenedImageGuid);
        } else {
            $this->FlattenedImageGuid = $flattenedImageGuid;
        }
        return $this;
    }
}
