<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.DonationProductItem StructType
 * @subpackage Structs
 */
class Donation_DonationProductItem extends Donation_Base
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The AmountType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AmountType;
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The ChannelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChannelId;
    /**
     * The CharityId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CharityId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The DonationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationDate;
    /**
     * The DonationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DonationId;
    /**
     * The DonationItemTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfDonation_DonationItemTransaction
     */
    public $DonationItemTransactions;
    /**
     * The FundId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FundId;
    /**
     * The GenerateTaxStatement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GenerateTaxStatement;
    /**
     * The GenerateThankYouLetter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GenerateThankYouLetter;
    /**
     * The GiftDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftDescription;
    /**
     * The GiftType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftType;
    /**
     * The GrantedSoftCredit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GrantedSoftCredit;
    /**
     * The IsAnonymous
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAnonymous;
    /**
     * The IsPrinting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinting;
    /**
     * The IsPrintSpecialClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrintSpecialClientName;
    /**
     * The IsReserved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReserved;
    /**
     * The LastTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastTransactionId;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The MatchingOfDonationProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MatchingOfDonationProductId;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notification;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PersonToTribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonToTribute;
    /**
     * The PledgeInstallment
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PledgeInstallment;
    /**
     * The RelatedDonation
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedDonation;
    /**
     * The SalesRepresentativeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepresentativeId;
    /**
     * The SoftCreditComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SoftCreditComment;
    /**
     * The SoftCreditCreationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SoftCreditCreationType;
    /**
     * The SoftCreditRelationshipRole
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SoftCreditRelationshipRole;
    /**
     * The SolicitorId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SolicitorId;
    /**
     * The TaxStatementNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxStatementNumbers;
    /**
     * The TaxStatementPrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TaxStatementPrintCount;
    /**
     * The TaxStatementPrintedOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxStatementPrintedOn;
    /**
     * The ThankYouLetterPrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ThankYouLetterPrintCount;
    /**
     * The ThankYouLetterSpecialMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThankYouLetterSpecialMessage;
    /**
     * The TributeLetterPrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TributeLetterPrintCount;
    /**
     * The TributeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeType;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Donation.DonationProductItem
     * @uses Donation_DonationProductItem::setActive()
     * @uses Donation_DonationProductItem::setAmountType()
     * @uses Donation_DonationProductItem::setAppealId()
     * @uses Donation_DonationProductItem::setCampaignId()
     * @uses Donation_DonationProductItem::setChannelId()
     * @uses Donation_DonationProductItem::setCharityId()
     * @uses Donation_DonationProductItem::setClientId()
     * @uses Donation_DonationProductItem::setCreationDate()
     * @uses Donation_DonationProductItem::setDonationDate()
     * @uses Donation_DonationProductItem::setDonationId()
     * @uses Donation_DonationProductItem::setDonationItemTransactions()
     * @uses Donation_DonationProductItem::setFundId()
     * @uses Donation_DonationProductItem::setGenerateTaxStatement()
     * @uses Donation_DonationProductItem::setGenerateThankYouLetter()
     * @uses Donation_DonationProductItem::setGiftDescription()
     * @uses Donation_DonationProductItem::setGiftType()
     * @uses Donation_DonationProductItem::setGrantedSoftCredit()
     * @uses Donation_DonationProductItem::setIsAnonymous()
     * @uses Donation_DonationProductItem::setIsPrinting()
     * @uses Donation_DonationProductItem::setIsPrintSpecialClientName()
     * @uses Donation_DonationProductItem::setIsReserved()
     * @uses Donation_DonationProductItem::setLastTransactionId()
     * @uses Donation_DonationProductItem::setLastUpdateDateTime()
     * @uses Donation_DonationProductItem::setMatchingOfDonationProductId()
     * @uses Donation_DonationProductItem::setMessage()
     * @uses Donation_DonationProductItem::setNotification()
     * @uses Donation_DonationProductItem::setOrganizationUnitId()
     * @uses Donation_DonationProductItem::setPersonToTribute()
     * @uses Donation_DonationProductItem::setPledgeInstallment()
     * @uses Donation_DonationProductItem::setRelatedDonation()
     * @uses Donation_DonationProductItem::setSalesRepresentativeId()
     * @uses Donation_DonationProductItem::setSoftCreditComment()
     * @uses Donation_DonationProductItem::setSoftCreditCreationType()
     * @uses Donation_DonationProductItem::setSoftCreditRelationshipRole()
     * @uses Donation_DonationProductItem::setSolicitorId()
     * @uses Donation_DonationProductItem::setTaxStatementNumbers()
     * @uses Donation_DonationProductItem::setTaxStatementPrintCount()
     * @uses Donation_DonationProductItem::setTaxStatementPrintedOn()
     * @uses Donation_DonationProductItem::setThankYouLetterPrintCount()
     * @uses Donation_DonationProductItem::setThankYouLetterSpecialMessage()
     * @uses Donation_DonationProductItem::setTributeLetterPrintCount()
     * @uses Donation_DonationProductItem::setTributeType()
     * @uses Donation_DonationProductItem::setUserId()
     * @uses Donation_DonationProductItem::setValue()
     * @uses Donation_DonationProductItem::setVisibleBySubordinates()
     * @param bool $active
     * @param string $amountType
     * @param string $appealId
     * @param string $campaignId
     * @param string $channelId
     * @param string $charityId
     * @param string $clientId
     * @param string $creationDate
     * @param string $donationDate
     * @param string $donationId
     * @param \patest\StructType\RecordSetOfDonation_DonationItemTransaction $donationItemTransactions
     * @param string $fundId
     * @param bool $generateTaxStatement
     * @param bool $generateThankYouLetter
     * @param string $giftDescription
     * @param string $giftType
     * @param bool $grantedSoftCredit
     * @param bool $isAnonymous
     * @param bool $isPrinting
     * @param bool $isPrintSpecialClientName
     * @param bool $isReserved
     * @param string $lastTransactionId
     * @param string $lastUpdateDateTime
     * @param string $matchingOfDonationProductId
     * @param string $message
     * @param string $notification
     * @param string $organizationUnitId
     * @param string $personToTribute
     * @param string $pledgeInstallment
     * @param string $relatedDonation
     * @param string $salesRepresentativeId
     * @param string $softCreditComment
     * @param string $softCreditCreationType
     * @param string $softCreditRelationshipRole
     * @param string $solicitorId
     * @param string $taxStatementNumbers
     * @param int $taxStatementPrintCount
     * @param string $taxStatementPrintedOn
     * @param int $thankYouLetterPrintCount
     * @param string $thankYouLetterSpecialMessage
     * @param int $tributeLetterPrintCount
     * @param string $tributeType
     * @param string $userId
     * @param float $value
     * @param bool $visibleBySubordinates
     */
    public function __construct($active = null, $amountType = null, $appealId = null, $campaignId = null, $channelId = null, $charityId = null, $clientId = null, $creationDate = null, $donationDate = null, $donationId = null, \patest\StructType\RecordSetOfDonation_DonationItemTransaction $donationItemTransactions = null, $fundId = null, $generateTaxStatement = null, $generateThankYouLetter = null, $giftDescription = null, $giftType = null, $grantedSoftCredit = null, $isAnonymous = null, $isPrinting = null, $isPrintSpecialClientName = null, $isReserved = null, $lastTransactionId = null, $lastUpdateDateTime = null, $matchingOfDonationProductId = null, $message = null, $notification = null, $organizationUnitId = null, $personToTribute = null, $pledgeInstallment = null, $relatedDonation = null, $salesRepresentativeId = null, $softCreditComment = null, $softCreditCreationType = null, $softCreditRelationshipRole = null, $solicitorId = null, $taxStatementNumbers = null, $taxStatementPrintCount = null, $taxStatementPrintedOn = null, $thankYouLetterPrintCount = null, $thankYouLetterSpecialMessage = null, $tributeLetterPrintCount = null, $tributeType = null, $userId = null, $value = null, $visibleBySubordinates = null)
    {
        $this
            ->setActive($active)
            ->setAmountType($amountType)
            ->setAppealId($appealId)
            ->setCampaignId($campaignId)
            ->setChannelId($channelId)
            ->setCharityId($charityId)
            ->setClientId($clientId)
            ->setCreationDate($creationDate)
            ->setDonationDate($donationDate)
            ->setDonationId($donationId)
            ->setDonationItemTransactions($donationItemTransactions)
            ->setFundId($fundId)
            ->setGenerateTaxStatement($generateTaxStatement)
            ->setGenerateThankYouLetter($generateThankYouLetter)
            ->setGiftDescription($giftDescription)
            ->setGiftType($giftType)
            ->setGrantedSoftCredit($grantedSoftCredit)
            ->setIsAnonymous($isAnonymous)
            ->setIsPrinting($isPrinting)
            ->setIsPrintSpecialClientName($isPrintSpecialClientName)
            ->setIsReserved($isReserved)
            ->setLastTransactionId($lastTransactionId)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setMatchingOfDonationProductId($matchingOfDonationProductId)
            ->setMessage($message)
            ->setNotification($notification)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPersonToTribute($personToTribute)
            ->setPledgeInstallment($pledgeInstallment)
            ->setRelatedDonation($relatedDonation)
            ->setSalesRepresentativeId($salesRepresentativeId)
            ->setSoftCreditComment($softCreditComment)
            ->setSoftCreditCreationType($softCreditCreationType)
            ->setSoftCreditRelationshipRole($softCreditRelationshipRole)
            ->setSolicitorId($solicitorId)
            ->setTaxStatementNumbers($taxStatementNumbers)
            ->setTaxStatementPrintCount($taxStatementPrintCount)
            ->setTaxStatementPrintedOn($taxStatementPrintedOn)
            ->setThankYouLetterPrintCount($thankYouLetterPrintCount)
            ->setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage)
            ->setTributeLetterPrintCount($tributeLetterPrintCount)
            ->setTributeType($tributeType)
            ->setUserId($userId)
            ->setValue($value)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $active
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get AmountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmountType()
    {
        return isset($this->AmountType) ? $this->AmountType : null;
    }
    /**
     * Set AmountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AmountType::valueIsValid()
     * @uses \patest\EnumType\AmountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amountType
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setAmountType($amountType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AmountType::valueIsValid($amountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AmountType', is_array($amountType) ? implode(', ', $amountType) : var_export($amountType, true), implode(', ', \patest\EnumType\AmountType::getValidValues())), __LINE__);
        }
        if (is_null($amountType) || (is_array($amountType) && empty($amountType))) {
            unset($this->AmountType);
        } else {
            $this->AmountType = $amountType;
        }
        return $this;
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get ChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannelId()
    {
        return isset($this->ChannelId) ? $this->ChannelId : null;
    }
    /**
     * Set ChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channelId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setChannelId($channelId = null)
    {
        // validation for constraint: string
        if (!is_null($channelId) && !is_string($channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelId, true), gettype($channelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($channelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($channelId, true)), __LINE__);
        }
        if (is_null($channelId) || (is_array($channelId) && empty($channelId))) {
            unset($this->ChannelId);
        } else {
            $this->ChannelId = $channelId;
        }
        return $this;
    }
    /**
     * Get CharityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCharityId()
    {
        return isset($this->CharityId) ? $this->CharityId : null;
    }
    /**
     * Set CharityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $charityId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setCharityId($charityId = null)
    {
        // validation for constraint: string
        if (!is_null($charityId) && !is_string($charityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charityId, true), gettype($charityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($charityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $charityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($charityId, true)), __LINE__);
        }
        if (is_null($charityId) || (is_array($charityId) && empty($charityId))) {
            unset($this->CharityId);
        } else {
            $this->CharityId = $charityId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get DonationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationDate()
    {
        return isset($this->DonationDate) ? $this->DonationDate : null;
    }
    /**
     * Set DonationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationDate
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setDonationDate($donationDate = null)
    {
        // validation for constraint: string
        if (!is_null($donationDate) && !is_string($donationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationDate, true), gettype($donationDate)), __LINE__);
        }
        if (is_null($donationDate) || (is_array($donationDate) && empty($donationDate))) {
            unset($this->DonationDate);
        } else {
            $this->DonationDate = $donationDate;
        }
        return $this;
    }
    /**
     * Get DonationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationId()
    {
        return isset($this->DonationId) ? $this->DonationId : null;
    }
    /**
     * Set DonationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setDonationId($donationId = null)
    {
        // validation for constraint: string
        if (!is_null($donationId) && !is_string($donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationId, true), gettype($donationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($donationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($donationId, true)), __LINE__);
        }
        if (is_null($donationId) || (is_array($donationId) && empty($donationId))) {
            unset($this->DonationId);
        } else {
            $this->DonationId = $donationId;
        }
        return $this;
    }
    /**
     * Get DonationItemTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfDonation_DonationItemTransaction|null
     */
    public function getDonationItemTransactions()
    {
        return isset($this->DonationItemTransactions) ? $this->DonationItemTransactions : null;
    }
    /**
     * Set DonationItemTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfDonation_DonationItemTransaction $donationItemTransactions
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setDonationItemTransactions(\patest\StructType\RecordSetOfDonation_DonationItemTransaction $donationItemTransactions = null)
    {
        if (is_null($donationItemTransactions) || (is_array($donationItemTransactions) && empty($donationItemTransactions))) {
            unset($this->DonationItemTransactions);
        } else {
            $this->DonationItemTransactions = $donationItemTransactions;
        }
        return $this;
    }
    /**
     * Get FundId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFundId()
    {
        return isset($this->FundId) ? $this->FundId : null;
    }
    /**
     * Set FundId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fundId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setFundId($fundId = null)
    {
        // validation for constraint: string
        if (!is_null($fundId) && !is_string($fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundId, true), gettype($fundId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fundId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fundId, true)), __LINE__);
        }
        if (is_null($fundId) || (is_array($fundId) && empty($fundId))) {
            unset($this->FundId);
        } else {
            $this->FundId = $fundId;
        }
        return $this;
    }
    /**
     * Get GenerateTaxStatement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGenerateTaxStatement()
    {
        return isset($this->GenerateTaxStatement) ? $this->GenerateTaxStatement : null;
    }
    /**
     * Set GenerateTaxStatement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $generateTaxStatement
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setGenerateTaxStatement($generateTaxStatement = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateTaxStatement) && !is_bool($generateTaxStatement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateTaxStatement, true), gettype($generateTaxStatement)), __LINE__);
        }
        if (is_null($generateTaxStatement) || (is_array($generateTaxStatement) && empty($generateTaxStatement))) {
            unset($this->GenerateTaxStatement);
        } else {
            $this->GenerateTaxStatement = $generateTaxStatement;
        }
        return $this;
    }
    /**
     * Get GenerateThankYouLetter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGenerateThankYouLetter()
    {
        return isset($this->GenerateThankYouLetter) ? $this->GenerateThankYouLetter : null;
    }
    /**
     * Set GenerateThankYouLetter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $generateThankYouLetter
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setGenerateThankYouLetter($generateThankYouLetter = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateThankYouLetter) && !is_bool($generateThankYouLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateThankYouLetter, true), gettype($generateThankYouLetter)), __LINE__);
        }
        if (is_null($generateThankYouLetter) || (is_array($generateThankYouLetter) && empty($generateThankYouLetter))) {
            unset($this->GenerateThankYouLetter);
        } else {
            $this->GenerateThankYouLetter = $generateThankYouLetter;
        }
        return $this;
    }
    /**
     * Get GiftDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftDescription()
    {
        return isset($this->GiftDescription) ? $this->GiftDescription : null;
    }
    /**
     * Set GiftDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftDescription
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setGiftDescription($giftDescription = null)
    {
        // validation for constraint: string
        if (!is_null($giftDescription) && !is_string($giftDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftDescription, true), gettype($giftDescription)), __LINE__);
        }
        if (is_null($giftDescription) || (is_array($giftDescription) && empty($giftDescription))) {
            unset($this->GiftDescription);
        } else {
            $this->GiftDescription = $giftDescription;
        }
        return $this;
    }
    /**
     * Get GiftType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftType()
    {
        return isset($this->GiftType) ? $this->GiftType : null;
    }
    /**
     * Set GiftType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GiftType::valueIsValid()
     * @uses \patest\EnumType\GiftType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $giftType
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setGiftType($giftType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftType::valueIsValid($giftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftType', is_array($giftType) ? implode(', ', $giftType) : var_export($giftType, true), implode(', ', \patest\EnumType\GiftType::getValidValues())), __LINE__);
        }
        if (is_null($giftType) || (is_array($giftType) && empty($giftType))) {
            unset($this->GiftType);
        } else {
            $this->GiftType = $giftType;
        }
        return $this;
    }
    /**
     * Get GrantedSoftCredit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGrantedSoftCredit()
    {
        return isset($this->GrantedSoftCredit) ? $this->GrantedSoftCredit : null;
    }
    /**
     * Set GrantedSoftCredit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $grantedSoftCredit
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setGrantedSoftCredit($grantedSoftCredit = null)
    {
        // validation for constraint: boolean
        if (!is_null($grantedSoftCredit) && !is_bool($grantedSoftCredit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($grantedSoftCredit, true), gettype($grantedSoftCredit)), __LINE__);
        }
        if (is_null($grantedSoftCredit) || (is_array($grantedSoftCredit) && empty($grantedSoftCredit))) {
            unset($this->GrantedSoftCredit);
        } else {
            $this->GrantedSoftCredit = $grantedSoftCredit;
        }
        return $this;
    }
    /**
     * Get IsAnonymous value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAnonymous()
    {
        return isset($this->IsAnonymous) ? $this->IsAnonymous : null;
    }
    /**
     * Set IsAnonymous value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAnonymous
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setIsAnonymous($isAnonymous = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAnonymous) && !is_bool($isAnonymous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAnonymous, true), gettype($isAnonymous)), __LINE__);
        }
        if (is_null($isAnonymous) || (is_array($isAnonymous) && empty($isAnonymous))) {
            unset($this->IsAnonymous);
        } else {
            $this->IsAnonymous = $isAnonymous;
        }
        return $this;
    }
    /**
     * Get IsPrinting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinting()
    {
        return isset($this->IsPrinting) ? $this->IsPrinting : null;
    }
    /**
     * Set IsPrinting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinting
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setIsPrinting($isPrinting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinting) && !is_bool($isPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinting, true), gettype($isPrinting)), __LINE__);
        }
        if (is_null($isPrinting) || (is_array($isPrinting) && empty($isPrinting))) {
            unset($this->IsPrinting);
        } else {
            $this->IsPrinting = $isPrinting;
        }
        return $this;
    }
    /**
     * Get IsPrintSpecialClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrintSpecialClientName()
    {
        return isset($this->IsPrintSpecialClientName) ? $this->IsPrintSpecialClientName : null;
    }
    /**
     * Set IsPrintSpecialClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrintSpecialClientName
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setIsPrintSpecialClientName($isPrintSpecialClientName = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrintSpecialClientName) && !is_bool($isPrintSpecialClientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrintSpecialClientName, true), gettype($isPrintSpecialClientName)), __LINE__);
        }
        if (is_null($isPrintSpecialClientName) || (is_array($isPrintSpecialClientName) && empty($isPrintSpecialClientName))) {
            unset($this->IsPrintSpecialClientName);
        } else {
            $this->IsPrintSpecialClientName = $isPrintSpecialClientName;
        }
        return $this;
    }
    /**
     * Get IsReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReserved()
    {
        return isset($this->IsReserved) ? $this->IsReserved : null;
    }
    /**
     * Set IsReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReserved
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setIsReserved($isReserved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReserved) && !is_bool($isReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReserved, true), gettype($isReserved)), __LINE__);
        }
        if (is_null($isReserved) || (is_array($isReserved) && empty($isReserved))) {
            unset($this->IsReserved);
        } else {
            $this->IsReserved = $isReserved;
        }
        return $this;
    }
    /**
     * Get LastTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastTransactionId()
    {
        return isset($this->LastTransactionId) ? $this->LastTransactionId : null;
    }
    /**
     * Set LastTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastTransactionId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setLastTransactionId($lastTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($lastTransactionId) && !is_string($lastTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTransactionId, true), gettype($lastTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastTransactionId, true)), __LINE__);
        }
        if (is_null($lastTransactionId) || (is_array($lastTransactionId) && empty($lastTransactionId))) {
            unset($this->LastTransactionId);
        } else {
            $this->LastTransactionId = $lastTransactionId;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get MatchingOfDonationProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatchingOfDonationProductId()
    {
        return isset($this->MatchingOfDonationProductId) ? $this->MatchingOfDonationProductId : null;
    }
    /**
     * Set MatchingOfDonationProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $matchingOfDonationProductId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setMatchingOfDonationProductId($matchingOfDonationProductId = null)
    {
        // validation for constraint: string
        if (!is_null($matchingOfDonationProductId) && !is_string($matchingOfDonationProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchingOfDonationProductId, true), gettype($matchingOfDonationProductId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($matchingOfDonationProductId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $matchingOfDonationProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($matchingOfDonationProductId, true)), __LINE__);
        }
        if (is_null($matchingOfDonationProductId) || (is_array($matchingOfDonationProductId) && empty($matchingOfDonationProductId))) {
            unset($this->MatchingOfDonationProductId);
        } else {
            $this->MatchingOfDonationProductId = $matchingOfDonationProductId;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Notification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotification()
    {
        return isset($this->Notification) ? $this->Notification : null;
    }
    /**
     * Set Notification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notification
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setNotification($notification = null)
    {
        // validation for constraint: string
        if (!is_null($notification) && !is_string($notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notification, true), gettype($notification)), __LINE__);
        }
        if (is_null($notification) || (is_array($notification) && empty($notification))) {
            unset($this->Notification);
        } else {
            $this->Notification = $notification;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PersonToTribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonToTribute()
    {
        return isset($this->PersonToTribute) ? $this->PersonToTribute : null;
    }
    /**
     * Set PersonToTribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personToTribute
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setPersonToTribute($personToTribute = null)
    {
        // validation for constraint: string
        if (!is_null($personToTribute) && !is_string($personToTribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personToTribute, true), gettype($personToTribute)), __LINE__);
        }
        if (is_null($personToTribute) || (is_array($personToTribute) && empty($personToTribute))) {
            unset($this->PersonToTribute);
        } else {
            $this->PersonToTribute = $personToTribute;
        }
        return $this;
    }
    /**
     * Get PledgeInstallment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPledgeInstallment()
    {
        return isset($this->PledgeInstallment) ? $this->PledgeInstallment : null;
    }
    /**
     * Set PledgeInstallment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pledgeInstallment
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setPledgeInstallment($pledgeInstallment = null)
    {
        // validation for constraint: string
        if (!is_null($pledgeInstallment) && !is_string($pledgeInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pledgeInstallment, true), gettype($pledgeInstallment)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($pledgeInstallment) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $pledgeInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($pledgeInstallment, true)), __LINE__);
        }
        if (is_null($pledgeInstallment) || (is_array($pledgeInstallment) && empty($pledgeInstallment))) {
            unset($this->PledgeInstallment);
        } else {
            $this->PledgeInstallment = $pledgeInstallment;
        }
        return $this;
    }
    /**
     * Get RelatedDonation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedDonation()
    {
        return isset($this->RelatedDonation) ? $this->RelatedDonation : null;
    }
    /**
     * Set RelatedDonation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedDonation
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setRelatedDonation($relatedDonation = null)
    {
        // validation for constraint: string
        if (!is_null($relatedDonation) && !is_string($relatedDonation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedDonation, true), gettype($relatedDonation)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedDonation) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedDonation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedDonation, true)), __LINE__);
        }
        if (is_null($relatedDonation) || (is_array($relatedDonation) && empty($relatedDonation))) {
            unset($this->RelatedDonation);
        } else {
            $this->RelatedDonation = $relatedDonation;
        }
        return $this;
    }
    /**
     * Get SalesRepresentativeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepresentativeId()
    {
        return isset($this->SalesRepresentativeId) ? $this->SalesRepresentativeId : null;
    }
    /**
     * Set SalesRepresentativeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepresentativeId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setSalesRepresentativeId($salesRepresentativeId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepresentativeId) && !is_string($salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepresentativeId, true), gettype($salesRepresentativeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepresentativeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepresentativeId, true)), __LINE__);
        }
        if (is_null($salesRepresentativeId) || (is_array($salesRepresentativeId) && empty($salesRepresentativeId))) {
            unset($this->SalesRepresentativeId);
        } else {
            $this->SalesRepresentativeId = $salesRepresentativeId;
        }
        return $this;
    }
    /**
     * Get SoftCreditComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoftCreditComment()
    {
        return isset($this->SoftCreditComment) ? $this->SoftCreditComment : null;
    }
    /**
     * Set SoftCreditComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $softCreditComment
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setSoftCreditComment($softCreditComment = null)
    {
        // validation for constraint: string
        if (!is_null($softCreditComment) && !is_string($softCreditComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softCreditComment, true), gettype($softCreditComment)), __LINE__);
        }
        if (is_null($softCreditComment) || (is_array($softCreditComment) && empty($softCreditComment))) {
            unset($this->SoftCreditComment);
        } else {
            $this->SoftCreditComment = $softCreditComment;
        }
        return $this;
    }
    /**
     * Get SoftCreditCreationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoftCreditCreationType()
    {
        return isset($this->SoftCreditCreationType) ? $this->SoftCreditCreationType : null;
    }
    /**
     * Set SoftCreditCreationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SoftCreditCreationType::valueIsValid()
     * @uses \patest\EnumType\SoftCreditCreationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $softCreditCreationType
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setSoftCreditCreationType($softCreditCreationType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SoftCreditCreationType::valueIsValid($softCreditCreationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SoftCreditCreationType', is_array($softCreditCreationType) ? implode(', ', $softCreditCreationType) : var_export($softCreditCreationType, true), implode(', ', \patest\EnumType\SoftCreditCreationType::getValidValues())), __LINE__);
        }
        if (is_null($softCreditCreationType) || (is_array($softCreditCreationType) && empty($softCreditCreationType))) {
            unset($this->SoftCreditCreationType);
        } else {
            $this->SoftCreditCreationType = $softCreditCreationType;
        }
        return $this;
    }
    /**
     * Get SoftCreditRelationshipRole value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoftCreditRelationshipRole()
    {
        return isset($this->SoftCreditRelationshipRole) ? $this->SoftCreditRelationshipRole : null;
    }
    /**
     * Set SoftCreditRelationshipRole value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $softCreditRelationshipRole
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setSoftCreditRelationshipRole($softCreditRelationshipRole = null)
    {
        // validation for constraint: string
        if (!is_null($softCreditRelationshipRole) && !is_string($softCreditRelationshipRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softCreditRelationshipRole, true), gettype($softCreditRelationshipRole)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($softCreditRelationshipRole) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $softCreditRelationshipRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($softCreditRelationshipRole, true)), __LINE__);
        }
        if (is_null($softCreditRelationshipRole) || (is_array($softCreditRelationshipRole) && empty($softCreditRelationshipRole))) {
            unset($this->SoftCreditRelationshipRole);
        } else {
            $this->SoftCreditRelationshipRole = $softCreditRelationshipRole;
        }
        return $this;
    }
    /**
     * Get SolicitorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSolicitorId()
    {
        return isset($this->SolicitorId) ? $this->SolicitorId : null;
    }
    /**
     * Set SolicitorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $solicitorId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setSolicitorId($solicitorId = null)
    {
        // validation for constraint: string
        if (!is_null($solicitorId) && !is_string($solicitorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($solicitorId, true), gettype($solicitorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($solicitorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $solicitorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($solicitorId, true)), __LINE__);
        }
        if (is_null($solicitorId) || (is_array($solicitorId) && empty($solicitorId))) {
            unset($this->SolicitorId);
        } else {
            $this->SolicitorId = $solicitorId;
        }
        return $this;
    }
    /**
     * Get TaxStatementNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxStatementNumbers()
    {
        return isset($this->TaxStatementNumbers) ? $this->TaxStatementNumbers : null;
    }
    /**
     * Set TaxStatementNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxStatementNumbers
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setTaxStatementNumbers($taxStatementNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($taxStatementNumbers) && !is_string($taxStatementNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxStatementNumbers, true), gettype($taxStatementNumbers)), __LINE__);
        }
        if (is_null($taxStatementNumbers) || (is_array($taxStatementNumbers) && empty($taxStatementNumbers))) {
            unset($this->TaxStatementNumbers);
        } else {
            $this->TaxStatementNumbers = $taxStatementNumbers;
        }
        return $this;
    }
    /**
     * Get TaxStatementPrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTaxStatementPrintCount()
    {
        return isset($this->TaxStatementPrintCount) ? $this->TaxStatementPrintCount : null;
    }
    /**
     * Set TaxStatementPrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $taxStatementPrintCount
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setTaxStatementPrintCount($taxStatementPrintCount = null)
    {
        // validation for constraint: int
        if (!is_null($taxStatementPrintCount) && !(is_int($taxStatementPrintCount) || ctype_digit($taxStatementPrintCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxStatementPrintCount, true), gettype($taxStatementPrintCount)), __LINE__);
        }
        if (is_null($taxStatementPrintCount) || (is_array($taxStatementPrintCount) && empty($taxStatementPrintCount))) {
            unset($this->TaxStatementPrintCount);
        } else {
            $this->TaxStatementPrintCount = $taxStatementPrintCount;
        }
        return $this;
    }
    /**
     * Get TaxStatementPrintedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxStatementPrintedOn()
    {
        return isset($this->TaxStatementPrintedOn) ? $this->TaxStatementPrintedOn : null;
    }
    /**
     * Set TaxStatementPrintedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxStatementPrintedOn
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setTaxStatementPrintedOn($taxStatementPrintedOn = null)
    {
        // validation for constraint: string
        if (!is_null($taxStatementPrintedOn) && !is_string($taxStatementPrintedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxStatementPrintedOn, true), gettype($taxStatementPrintedOn)), __LINE__);
        }
        if (is_null($taxStatementPrintedOn) || (is_array($taxStatementPrintedOn) && empty($taxStatementPrintedOn))) {
            unset($this->TaxStatementPrintedOn);
        } else {
            $this->TaxStatementPrintedOn = $taxStatementPrintedOn;
        }
        return $this;
    }
    /**
     * Get ThankYouLetterPrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getThankYouLetterPrintCount()
    {
        return isset($this->ThankYouLetterPrintCount) ? $this->ThankYouLetterPrintCount : null;
    }
    /**
     * Set ThankYouLetterPrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $thankYouLetterPrintCount
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setThankYouLetterPrintCount($thankYouLetterPrintCount = null)
    {
        // validation for constraint: int
        if (!is_null($thankYouLetterPrintCount) && !(is_int($thankYouLetterPrintCount) || ctype_digit($thankYouLetterPrintCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($thankYouLetterPrintCount, true), gettype($thankYouLetterPrintCount)), __LINE__);
        }
        if (is_null($thankYouLetterPrintCount) || (is_array($thankYouLetterPrintCount) && empty($thankYouLetterPrintCount))) {
            unset($this->ThankYouLetterPrintCount);
        } else {
            $this->ThankYouLetterPrintCount = $thankYouLetterPrintCount;
        }
        return $this;
    }
    /**
     * Get ThankYouLetterSpecialMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThankYouLetterSpecialMessage()
    {
        return isset($this->ThankYouLetterSpecialMessage) ? $this->ThankYouLetterSpecialMessage : null;
    }
    /**
     * Set ThankYouLetterSpecialMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thankYouLetterSpecialMessage
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage = null)
    {
        // validation for constraint: string
        if (!is_null($thankYouLetterSpecialMessage) && !is_string($thankYouLetterSpecialMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thankYouLetterSpecialMessage, true), gettype($thankYouLetterSpecialMessage)), __LINE__);
        }
        if (is_null($thankYouLetterSpecialMessage) || (is_array($thankYouLetterSpecialMessage) && empty($thankYouLetterSpecialMessage))) {
            unset($this->ThankYouLetterSpecialMessage);
        } else {
            $this->ThankYouLetterSpecialMessage = $thankYouLetterSpecialMessage;
        }
        return $this;
    }
    /**
     * Get TributeLetterPrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTributeLetterPrintCount()
    {
        return isset($this->TributeLetterPrintCount) ? $this->TributeLetterPrintCount : null;
    }
    /**
     * Set TributeLetterPrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tributeLetterPrintCount
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setTributeLetterPrintCount($tributeLetterPrintCount = null)
    {
        // validation for constraint: int
        if (!is_null($tributeLetterPrintCount) && !(is_int($tributeLetterPrintCount) || ctype_digit($tributeLetterPrintCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tributeLetterPrintCount, true), gettype($tributeLetterPrintCount)), __LINE__);
        }
        if (is_null($tributeLetterPrintCount) || (is_array($tributeLetterPrintCount) && empty($tributeLetterPrintCount))) {
            unset($this->TributeLetterPrintCount);
        } else {
            $this->TributeLetterPrintCount = $tributeLetterPrintCount;
        }
        return $this;
    }
    /**
     * Get TributeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeType()
    {
        return isset($this->TributeType) ? $this->TributeType : null;
    }
    /**
     * Set TributeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TributeType::valueIsValid()
     * @uses \patest\EnumType\TributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tributeType
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setTributeType($tributeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TributeType::valueIsValid($tributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TributeType', is_array($tributeType) ? implode(', ', $tributeType) : var_export($tributeType, true), implode(', ', \patest\EnumType\TributeType::getValidValues())), __LINE__);
        }
        if (is_null($tributeType) || (is_array($tributeType) && empty($tributeType))) {
            unset($this->TributeType);
        } else {
            $this->TributeType = $tributeType;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $value
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Donation_DonationProductItem
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
