<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeductRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeductRequest
 * @subpackage Structs
 */
class DeductRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DeductionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfDeductionDetail
     */
    public $DeductionDetails;
    /**
     * The DepositId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositId;
    /**
     * Constructor method for DeductRequest
     * @uses DeductRequest::setClientId()
     * @uses DeductRequest::setDeductionDetails()
     * @uses DeductRequest::setDepositId()
     * @param string $clientId
     * @param \patest\ArrayType\ArrayOfDeductionDetail $deductionDetails
     * @param string $depositId
     */
    public function __construct($clientId = null, \patest\ArrayType\ArrayOfDeductionDetail $deductionDetails = null, $depositId = null)
    {
        $this
            ->setClientId($clientId)
            ->setDeductionDetails($deductionDetails)
            ->setDepositId($depositId);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\DeductRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get DeductionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfDeductionDetail|null
     */
    public function getDeductionDetails()
    {
        return isset($this->DeductionDetails) ? $this->DeductionDetails : null;
    }
    /**
     * Set DeductionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfDeductionDetail $deductionDetails
     * @return \patest\StructType\DeductRequest
     */
    public function setDeductionDetails(\patest\ArrayType\ArrayOfDeductionDetail $deductionDetails = null)
    {
        if (is_null($deductionDetails) || (is_array($deductionDetails) && empty($deductionDetails))) {
            unset($this->DeductionDetails);
        } else {
            $this->DeductionDetails = $deductionDetails;
        }
        return $this;
    }
    /**
     * Get DepositId value
     * @return string|null
     */
    public function getDepositId()
    {
        return $this->DepositId;
    }
    /**
     * Set DepositId value
     * @param string $depositId
     * @return \patest\StructType\DeductRequest
     */
    public function setDepositId($depositId = null)
    {
        // validation for constraint: string
        if (!is_null($depositId) && !is_string($depositId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositId, true), gettype($depositId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositId, true)), __LINE__);
        }
        $this->DepositId = $depositId;
        return $this;
    }
}
