<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeactivateCodeStatus-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeactivateCodeStatus-Response
 * @subpackage Structs
 */
class DeactivateCodeStatus_Response extends AbstractStructBase
{
    /**
     * The CompletionPct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CompletionPct;
    /**
     * The IsComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsComplete;
    /**
     * Constructor method for DeactivateCodeStatus-Response
     * @uses DeactivateCodeStatus_Response::setCompletionPct()
     * @uses DeactivateCodeStatus_Response::setIsComplete()
     * @param float $completionPct
     * @param bool $isComplete
     */
    public function __construct($completionPct = null, $isComplete = null)
    {
        $this
            ->setCompletionPct($completionPct)
            ->setIsComplete($isComplete);
    }
    /**
     * Get CompletionPct value
     * @return float|null
     */
    public function getCompletionPct()
    {
        return $this->CompletionPct;
    }
    /**
     * Set CompletionPct value
     * @param float $completionPct
     * @return \patest\StructType\DeactivateCodeStatus_Response
     */
    public function setCompletionPct($completionPct = null)
    {
        // validation for constraint: float
        if (!is_null($completionPct) && !(is_float($completionPct) || is_numeric($completionPct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($completionPct, true), gettype($completionPct)), __LINE__);
        }
        $this->CompletionPct = $completionPct;
        return $this;
    }
    /**
     * Get IsComplete value
     * @return bool|null
     */
    public function getIsComplete()
    {
        return $this->IsComplete;
    }
    /**
     * Set IsComplete value
     * @param bool $isComplete
     * @return \patest\StructType\DeactivateCodeStatus_Response
     */
    public function setIsComplete($isComplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplete) && !is_bool($isComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplete, true), gettype($isComplete)), __LINE__);
        }
        $this->IsComplete = $isComplete;
        return $this;
    }
}
