<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.TravelGroup StructType
 * @subpackage Structs
 */
class Crm_TravelGroup extends DistributableEntity
{
    /**
     * The ClientIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientIds
     */
    public $ClientIds;
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupCode;
    /**
     * The GroupLeader
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupLeader;
    /**
     * The GroupSize
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupSize;
    /**
     * Constructor method for Crm.TravelGroup
     * @uses Crm_TravelGroup::setClientIds()
     * @uses Crm_TravelGroup::setGroupCode()
     * @uses Crm_TravelGroup::setGroupLeader()
     * @uses Crm_TravelGroup::setGroupSize()
     * @param \patest\StructType\ClientIds $clientIds
     * @param int $groupCode
     * @param string $groupLeader
     * @param int $groupSize
     */
    public function __construct(\patest\StructType\ClientIds $clientIds = null, $groupCode = null, $groupLeader = null, $groupSize = null)
    {
        $this
            ->setClientIds($clientIds)
            ->setGroupCode($groupCode)
            ->setGroupLeader($groupLeader)
            ->setGroupSize($groupSize);
    }
    /**
     * Get ClientIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientIds|null
     */
    public function getClientIds()
    {
        return isset($this->ClientIds) ? $this->ClientIds : null;
    }
    /**
     * Set ClientIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientIds $clientIds
     * @return \patest\StructType\Crm_TravelGroup
     */
    public function setClientIds(\patest\StructType\ClientIds $clientIds = null)
    {
        if (is_null($clientIds) || (is_array($clientIds) && empty($clientIds))) {
            unset($this->ClientIds);
        } else {
            $this->ClientIds = $clientIds;
        }
        return $this;
    }
    /**
     * Get GroupCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupCode()
    {
        return isset($this->GroupCode) ? $this->GroupCode : null;
    }
    /**
     * Set GroupCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupCode
     * @return \patest\StructType\Crm_TravelGroup
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: int
        if (!is_null($groupCode) && !(is_int($groupCode) || ctype_digit($groupCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        if (is_null($groupCode) || (is_array($groupCode) && empty($groupCode))) {
            unset($this->GroupCode);
        } else {
            $this->GroupCode = $groupCode;
        }
        return $this;
    }
    /**
     * Get GroupLeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupLeader()
    {
        return isset($this->GroupLeader) ? $this->GroupLeader : null;
    }
    /**
     * Set GroupLeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupLeader
     * @return \patest\StructType\Crm_TravelGroup
     */
    public function setGroupLeader($groupLeader = null)
    {
        // validation for constraint: string
        if (!is_null($groupLeader) && !is_string($groupLeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupLeader, true), gettype($groupLeader)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupLeader) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupLeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupLeader, true)), __LINE__);
        }
        if (is_null($groupLeader) || (is_array($groupLeader) && empty($groupLeader))) {
            unset($this->GroupLeader);
        } else {
            $this->GroupLeader = $groupLeader;
        }
        return $this;
    }
    /**
     * Get GroupSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupSize()
    {
        return isset($this->GroupSize) ? $this->GroupSize : null;
    }
    /**
     * Set GroupSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupSize
     * @return \patest\StructType\Crm_TravelGroup
     */
    public function setGroupSize($groupSize = null)
    {
        // validation for constraint: int
        if (!is_null($groupSize) && !(is_int($groupSize) || ctype_digit($groupSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupSize, true), gettype($groupSize)), __LINE__);
        }
        if (is_null($groupSize) || (is_array($groupSize) && empty($groupSize))) {
            unset($this->GroupSize);
        } else {
            $this->GroupSize = $groupSize;
        }
        return $this;
    }
}
