<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.TicketSchemeClientEnrollment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Crm.TicketSchemeClientEnrollment
 * @subpackage Structs
 */
class Crm_TicketSchemeClientEnrollment extends Crm_ClientEnrollment
{
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AreaName;
    /**
     * The IsObsolete
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsObsolete;
    /**
     * The NormalizedRowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NormalizedRowName;
    /**
     * The NormalizedSeatName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NormalizedSeatName;
    /**
     * The RelatedSeries
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedSeries;
    /**
     * The RelatedSubscriptionInstance
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_SubscriptionInstance
     */
    public $RelatedSubscriptionInstance;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorName;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SeriesName;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Crm.TicketSchemeClientEnrollment
     * @uses Crm_TicketSchemeClientEnrollment::setAreaName()
     * @uses Crm_TicketSchemeClientEnrollment::setIsObsolete()
     * @uses Crm_TicketSchemeClientEnrollment::setNormalizedRowName()
     * @uses Crm_TicketSchemeClientEnrollment::setNormalizedSeatName()
     * @uses Crm_TicketSchemeClientEnrollment::setRelatedSeries()
     * @uses Crm_TicketSchemeClientEnrollment::setRelatedSubscriptionInstance()
     * @uses Crm_TicketSchemeClientEnrollment::setSectorName()
     * @uses Crm_TicketSchemeClientEnrollment::setSeriesName()
     * @uses Crm_TicketSchemeClientEnrollment::setStatus()
     * @param \patest\StructType\GlobalString $areaName
     * @param bool $isObsolete
     * @param string $normalizedRowName
     * @param string $normalizedSeatName
     * @param string $relatedSeries
     * @param \patest\StructType\Ticketing_SubscriptionInstance $relatedSubscriptionInstance
     * @param \patest\StructType\GlobalString $sectorName
     * @param \patest\StructType\GlobalString $seriesName
     * @param string $status
     */
    public function __construct(\patest\StructType\GlobalString $areaName = null, $isObsolete = null, $normalizedRowName = null, $normalizedSeatName = null, $relatedSeries = null, \patest\StructType\Ticketing_SubscriptionInstance $relatedSubscriptionInstance = null, \patest\StructType\GlobalString $sectorName = null, \patest\StructType\GlobalString $seriesName = null, $status = null)
    {
        $this
            ->setAreaName($areaName)
            ->setIsObsolete($isObsolete)
            ->setNormalizedRowName($normalizedRowName)
            ->setNormalizedSeatName($normalizedSeatName)
            ->setRelatedSeries($relatedSeries)
            ->setRelatedSubscriptionInstance($relatedSubscriptionInstance)
            ->setSectorName($sectorName)
            ->setSeriesName($seriesName)
            ->setStatus($status);
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $areaName
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollment
     */
    public function setAreaName(\patest\StructType\GlobalString $areaName = null)
    {
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get IsObsolete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsObsolete()
    {
        return isset($this->IsObsolete) ? $this->IsObsolete : null;
    }
    /**
     * Set IsObsolete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isObsolete
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollment
     */
    public function setIsObsolete($isObsolete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObsolete) && !is_bool($isObsolete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObsolete, true), gettype($isObsolete)), __LINE__);
        }
        if (is_null($isObsolete) || (is_array($isObsolete) && empty($isObsolete))) {
            unset($this->IsObsolete);
        } else {
            $this->IsObsolete = $isObsolete;
        }
        return $this;
    }
    /**
     * Get NormalizedRowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNormalizedRowName()
    {
        return isset($this->NormalizedRowName) ? $this->NormalizedRowName : null;
    }
    /**
     * Set NormalizedRowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $normalizedRowName
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollment
     */
    public function setNormalizedRowName($normalizedRowName = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedRowName) && !is_string($normalizedRowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedRowName, true), gettype($normalizedRowName)), __LINE__);
        }
        if (is_null($normalizedRowName) || (is_array($normalizedRowName) && empty($normalizedRowName))) {
            unset($this->NormalizedRowName);
        } else {
            $this->NormalizedRowName = $normalizedRowName;
        }
        return $this;
    }
    /**
     * Get NormalizedSeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNormalizedSeatName()
    {
        return isset($this->NormalizedSeatName) ? $this->NormalizedSeatName : null;
    }
    /**
     * Set NormalizedSeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $normalizedSeatName
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollment
     */
    public function setNormalizedSeatName($normalizedSeatName = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedSeatName) && !is_string($normalizedSeatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedSeatName, true), gettype($normalizedSeatName)), __LINE__);
        }
        if (is_null($normalizedSeatName) || (is_array($normalizedSeatName) && empty($normalizedSeatName))) {
            unset($this->NormalizedSeatName);
        } else {
            $this->NormalizedSeatName = $normalizedSeatName;
        }
        return $this;
    }
    /**
     * Get RelatedSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedSeries()
    {
        return isset($this->RelatedSeries) ? $this->RelatedSeries : null;
    }
    /**
     * Set RelatedSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedSeries
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollment
     */
    public function setRelatedSeries($relatedSeries = null)
    {
        // validation for constraint: string
        if (!is_null($relatedSeries) && !is_string($relatedSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedSeries, true), gettype($relatedSeries)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedSeries) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedSeries, true)), __LINE__);
        }
        if (is_null($relatedSeries) || (is_array($relatedSeries) && empty($relatedSeries))) {
            unset($this->RelatedSeries);
        } else {
            $this->RelatedSeries = $relatedSeries;
        }
        return $this;
    }
    /**
     * Get RelatedSubscriptionInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_SubscriptionInstance|null
     */
    public function getRelatedSubscriptionInstance()
    {
        return isset($this->RelatedSubscriptionInstance) ? $this->RelatedSubscriptionInstance : null;
    }
    /**
     * Set RelatedSubscriptionInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_SubscriptionInstance $relatedSubscriptionInstance
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollment
     */
    public function setRelatedSubscriptionInstance(\patest\StructType\Ticketing_SubscriptionInstance $relatedSubscriptionInstance = null)
    {
        if (is_null($relatedSubscriptionInstance) || (is_array($relatedSubscriptionInstance) && empty($relatedSubscriptionInstance))) {
            unset($this->RelatedSubscriptionInstance);
        } else {
            $this->RelatedSubscriptionInstance = $relatedSubscriptionInstance;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorName
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollment
     */
    public function setSectorName(\patest\StructType\GlobalString $sectorName = null)
    {
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $seriesName
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollment
     */
    public function setSeriesName(\patest\StructType\GlobalString $seriesName = null)
    {
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientEnrollmentStatus::valueIsValid()
     * @uses \patest\EnumType\ClientEnrollmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollment
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientEnrollmentStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientEnrollmentStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\ClientEnrollmentStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
