<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.TicketScheme StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Crm.TicketScheme
 * @subpackage Structs
 */
class Crm_TicketScheme extends Crm_EnrollmentScheme
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The ClientTypesForDepositWithdrawal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypesForDepositWithdrawal
     */
    public $ClientTypesForDepositWithdrawal;
    /**
     * The DepositCategoriesForPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DepositCategoriesForPayment
     */
    public $DepositCategoriesForPayment;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The PayFromDeposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PayFromDeposit;
    /**
     * The PaymentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentOption;
    /**
     * The PriceTypesForFreeTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypesForFreeTickets
     */
    public $PriceTypesForFreeTickets;
    /**
     * The RenewalOfTicketScheme
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewalOfTicketScheme;
    /**
     * The SeasonEndDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeasonEndDate;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeasonStartDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeasonStartDate;
    /**
     * The SeriesEnrollmentOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_TicketSchemeEnrollmentOption
     */
    public $SeriesEnrollmentOptions;
    /**
     * The SpecialPriceTypePeriods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_TicketSchemePriceTypePeriod
     */
    public $SpecialPriceTypePeriods;
    /**
     * Constructor method for Crm.TicketScheme
     * @uses Crm_TicketScheme::setCategoryId()
     * @uses Crm_TicketScheme::setClientTypesForDepositWithdrawal()
     * @uses Crm_TicketScheme::setDepositCategoriesForPayment()
     * @uses Crm_TicketScheme::setEndDate()
     * @uses Crm_TicketScheme::setEventIds()
     * @uses Crm_TicketScheme::setHallId()
     * @uses Crm_TicketScheme::setPayFromDeposit()
     * @uses Crm_TicketScheme::setPaymentOption()
     * @uses Crm_TicketScheme::setPriceTypesForFreeTickets()
     * @uses Crm_TicketScheme::setRenewalOfTicketScheme()
     * @uses Crm_TicketScheme::setSeasonEndDate()
     * @uses Crm_TicketScheme::setSeasonId()
     * @uses Crm_TicketScheme::setSeasonStartDate()
     * @uses Crm_TicketScheme::setSeriesEnrollmentOptions()
     * @uses Crm_TicketScheme::setSpecialPriceTypePeriods()
     * @param string $categoryId
     * @param \patest\StructType\ClientTypesForDepositWithdrawal $clientTypesForDepositWithdrawal
     * @param \patest\StructType\DepositCategoriesForPayment $depositCategoriesForPayment
     * @param string $endDate
     * @param \patest\StructType\EventIds $eventIds
     * @param string $hallId
     * @param bool $payFromDeposit
     * @param string $paymentOption
     * @param \patest\StructType\PriceTypesForFreeTickets $priceTypesForFreeTickets
     * @param string $renewalOfTicketScheme
     * @param string $seasonEndDate
     * @param string $seasonId
     * @param string $seasonStartDate
     * @param \patest\StructType\RecordSetOfCrm_TicketSchemeEnrollmentOption $seriesEnrollmentOptions
     * @param \patest\StructType\RecordSetOfCrm_TicketSchemePriceTypePeriod $specialPriceTypePeriods
     */
    public function __construct($categoryId = null, \patest\StructType\ClientTypesForDepositWithdrawal $clientTypesForDepositWithdrawal = null, \patest\StructType\DepositCategoriesForPayment $depositCategoriesForPayment = null, $endDate = null, \patest\StructType\EventIds $eventIds = null, $hallId = null, $payFromDeposit = null, $paymentOption = null, \patest\StructType\PriceTypesForFreeTickets $priceTypesForFreeTickets = null, $renewalOfTicketScheme = null, $seasonEndDate = null, $seasonId = null, $seasonStartDate = null, \patest\StructType\RecordSetOfCrm_TicketSchemeEnrollmentOption $seriesEnrollmentOptions = null, \patest\StructType\RecordSetOfCrm_TicketSchemePriceTypePeriod $specialPriceTypePeriods = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setClientTypesForDepositWithdrawal($clientTypesForDepositWithdrawal)
            ->setDepositCategoriesForPayment($depositCategoriesForPayment)
            ->setEndDate($endDate)
            ->setEventIds($eventIds)
            ->setHallId($hallId)
            ->setPayFromDeposit($payFromDeposit)
            ->setPaymentOption($paymentOption)
            ->setPriceTypesForFreeTickets($priceTypesForFreeTickets)
            ->setRenewalOfTicketScheme($renewalOfTicketScheme)
            ->setSeasonEndDate($seasonEndDate)
            ->setSeasonId($seasonId)
            ->setSeasonStartDate($seasonStartDate)
            ->setSeriesEnrollmentOptions($seriesEnrollmentOptions)
            ->setSpecialPriceTypePeriods($specialPriceTypePeriods);
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get ClientTypesForDepositWithdrawal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypesForDepositWithdrawal|null
     */
    public function getClientTypesForDepositWithdrawal()
    {
        return isset($this->ClientTypesForDepositWithdrawal) ? $this->ClientTypesForDepositWithdrawal : null;
    }
    /**
     * Set ClientTypesForDepositWithdrawal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypesForDepositWithdrawal $clientTypesForDepositWithdrawal
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setClientTypesForDepositWithdrawal(\patest\StructType\ClientTypesForDepositWithdrawal $clientTypesForDepositWithdrawal = null)
    {
        if (is_null($clientTypesForDepositWithdrawal) || (is_array($clientTypesForDepositWithdrawal) && empty($clientTypesForDepositWithdrawal))) {
            unset($this->ClientTypesForDepositWithdrawal);
        } else {
            $this->ClientTypesForDepositWithdrawal = $clientTypesForDepositWithdrawal;
        }
        return $this;
    }
    /**
     * Get DepositCategoriesForPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DepositCategoriesForPayment|null
     */
    public function getDepositCategoriesForPayment()
    {
        return isset($this->DepositCategoriesForPayment) ? $this->DepositCategoriesForPayment : null;
    }
    /**
     * Set DepositCategoriesForPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DepositCategoriesForPayment $depositCategoriesForPayment
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setDepositCategoriesForPayment(\patest\StructType\DepositCategoriesForPayment $depositCategoriesForPayment = null)
    {
        if (is_null($depositCategoriesForPayment) || (is_array($depositCategoriesForPayment) && empty($depositCategoriesForPayment))) {
            unset($this->DepositCategoriesForPayment);
        } else {
            $this->DepositCategoriesForPayment = $depositCategoriesForPayment;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get PayFromDeposit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPayFromDeposit()
    {
        return isset($this->PayFromDeposit) ? $this->PayFromDeposit : null;
    }
    /**
     * Set PayFromDeposit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $payFromDeposit
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setPayFromDeposit($payFromDeposit = null)
    {
        // validation for constraint: boolean
        if (!is_null($payFromDeposit) && !is_bool($payFromDeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payFromDeposit, true), gettype($payFromDeposit)), __LINE__);
        }
        if (is_null($payFromDeposit) || (is_array($payFromDeposit) && empty($payFromDeposit))) {
            unset($this->PayFromDeposit);
        } else {
            $this->PayFromDeposit = $payFromDeposit;
        }
        return $this;
    }
    /**
     * Get PaymentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentOption()
    {
        return isset($this->PaymentOption) ? $this->PaymentOption : null;
    }
    /**
     * Set PaymentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketSchemePaymentOption::valueIsValid()
     * @uses \patest\EnumType\TicketSchemePaymentOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentOption
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setPaymentOption($paymentOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketSchemePaymentOption::valueIsValid($paymentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketSchemePaymentOption', is_array($paymentOption) ? implode(', ', $paymentOption) : var_export($paymentOption, true), implode(', ', \patest\EnumType\TicketSchemePaymentOption::getValidValues())), __LINE__);
        }
        if (is_null($paymentOption) || (is_array($paymentOption) && empty($paymentOption))) {
            unset($this->PaymentOption);
        } else {
            $this->PaymentOption = $paymentOption;
        }
        return $this;
    }
    /**
     * Get PriceTypesForFreeTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypesForFreeTickets|null
     */
    public function getPriceTypesForFreeTickets()
    {
        return isset($this->PriceTypesForFreeTickets) ? $this->PriceTypesForFreeTickets : null;
    }
    /**
     * Set PriceTypesForFreeTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypesForFreeTickets $priceTypesForFreeTickets
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setPriceTypesForFreeTickets(\patest\StructType\PriceTypesForFreeTickets $priceTypesForFreeTickets = null)
    {
        if (is_null($priceTypesForFreeTickets) || (is_array($priceTypesForFreeTickets) && empty($priceTypesForFreeTickets))) {
            unset($this->PriceTypesForFreeTickets);
        } else {
            $this->PriceTypesForFreeTickets = $priceTypesForFreeTickets;
        }
        return $this;
    }
    /**
     * Get RenewalOfTicketScheme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewalOfTicketScheme()
    {
        return isset($this->RenewalOfTicketScheme) ? $this->RenewalOfTicketScheme : null;
    }
    /**
     * Set RenewalOfTicketScheme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewalOfTicketScheme
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setRenewalOfTicketScheme($renewalOfTicketScheme = null)
    {
        // validation for constraint: string
        if (!is_null($renewalOfTicketScheme) && !is_string($renewalOfTicketScheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewalOfTicketScheme, true), gettype($renewalOfTicketScheme)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewalOfTicketScheme) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewalOfTicketScheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewalOfTicketScheme, true)), __LINE__);
        }
        if (is_null($renewalOfTicketScheme) || (is_array($renewalOfTicketScheme) && empty($renewalOfTicketScheme))) {
            unset($this->RenewalOfTicketScheme);
        } else {
            $this->RenewalOfTicketScheme = $renewalOfTicketScheme;
        }
        return $this;
    }
    /**
     * Get SeasonEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonEndDate()
    {
        return isset($this->SeasonEndDate) ? $this->SeasonEndDate : null;
    }
    /**
     * Set SeasonEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonEndDate
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setSeasonEndDate($seasonEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($seasonEndDate) && !is_string($seasonEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonEndDate, true), gettype($seasonEndDate)), __LINE__);
        }
        if (is_null($seasonEndDate) || (is_array($seasonEndDate) && empty($seasonEndDate))) {
            unset($this->SeasonEndDate);
        } else {
            $this->SeasonEndDate = $seasonEndDate;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeasonStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonStartDate()
    {
        return isset($this->SeasonStartDate) ? $this->SeasonStartDate : null;
    }
    /**
     * Set SeasonStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonStartDate
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setSeasonStartDate($seasonStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($seasonStartDate) && !is_string($seasonStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonStartDate, true), gettype($seasonStartDate)), __LINE__);
        }
        if (is_null($seasonStartDate) || (is_array($seasonStartDate) && empty($seasonStartDate))) {
            unset($this->SeasonStartDate);
        } else {
            $this->SeasonStartDate = $seasonStartDate;
        }
        return $this;
    }
    /**
     * Get SeriesEnrollmentOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_TicketSchemeEnrollmentOption|null
     */
    public function getSeriesEnrollmentOptions()
    {
        return isset($this->SeriesEnrollmentOptions) ? $this->SeriesEnrollmentOptions : null;
    }
    /**
     * Set SeriesEnrollmentOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_TicketSchemeEnrollmentOption $seriesEnrollmentOptions
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setSeriesEnrollmentOptions(\patest\StructType\RecordSetOfCrm_TicketSchemeEnrollmentOption $seriesEnrollmentOptions = null)
    {
        if (is_null($seriesEnrollmentOptions) || (is_array($seriesEnrollmentOptions) && empty($seriesEnrollmentOptions))) {
            unset($this->SeriesEnrollmentOptions);
        } else {
            $this->SeriesEnrollmentOptions = $seriesEnrollmentOptions;
        }
        return $this;
    }
    /**
     * Get SpecialPriceTypePeriods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_TicketSchemePriceTypePeriod|null
     */
    public function getSpecialPriceTypePeriods()
    {
        return isset($this->SpecialPriceTypePeriods) ? $this->SpecialPriceTypePeriods : null;
    }
    /**
     * Set SpecialPriceTypePeriods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_TicketSchemePriceTypePeriod $specialPriceTypePeriods
     * @return \patest\StructType\Crm_TicketScheme
     */
    public function setSpecialPriceTypePeriods(\patest\StructType\RecordSetOfCrm_TicketSchemePriceTypePeriod $specialPriceTypePeriods = null)
    {
        if (is_null($specialPriceTypePeriods) || (is_array($specialPriceTypePeriods) && empty($specialPriceTypePeriods))) {
            unset($this->SpecialPriceTypePeriods);
        } else {
            $this->SpecialPriceTypePeriods = $specialPriceTypePeriods;
        }
        return $this;
    }
}
