<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.TemporaryRelationshipDetail StructType
 * @subpackage Structs
 */
class Crm_TemporaryRelationshipDetail extends PersistableEntity
{
    /**
     * The CreationAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreationAuditId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The InviteeClientRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InviteeClientRoleId;
    /**
     * The InviteeEmailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InviteeEmailAddress;
    /**
     * The InvitingClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvitingClientId;
    /**
     * The InvitingClientRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvitingClientRoleId;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * Constructor method for Crm.TemporaryRelationshipDetail
     * @uses Crm_TemporaryRelationshipDetail::setCreationAuditId()
     * @uses Crm_TemporaryRelationshipDetail::setCreationDate()
     * @uses Crm_TemporaryRelationshipDetail::setInviteeClientRoleId()
     * @uses Crm_TemporaryRelationshipDetail::setInviteeEmailAddress()
     * @uses Crm_TemporaryRelationshipDetail::setInvitingClientId()
     * @uses Crm_TemporaryRelationshipDetail::setInvitingClientRoleId()
     * @uses Crm_TemporaryRelationshipDetail::setTypeId()
     * @param int $creationAuditId
     * @param string $creationDate
     * @param string $inviteeClientRoleId
     * @param string $inviteeEmailAddress
     * @param string $invitingClientId
     * @param string $invitingClientRoleId
     * @param string $typeId
     */
    public function __construct($creationAuditId = null, $creationDate = null, $inviteeClientRoleId = null, $inviteeEmailAddress = null, $invitingClientId = null, $invitingClientRoleId = null, $typeId = null)
    {
        $this
            ->setCreationAuditId($creationAuditId)
            ->setCreationDate($creationDate)
            ->setInviteeClientRoleId($inviteeClientRoleId)
            ->setInviteeEmailAddress($inviteeEmailAddress)
            ->setInvitingClientId($invitingClientId)
            ->setInvitingClientRoleId($invitingClientRoleId)
            ->setTypeId($typeId);
    }
    /**
     * Get CreationAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreationAuditId()
    {
        return isset($this->CreationAuditId) ? $this->CreationAuditId : null;
    }
    /**
     * Set CreationAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creationAuditId
     * @return \patest\StructType\Crm_TemporaryRelationshipDetail
     */
    public function setCreationAuditId($creationAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($creationAuditId) && !(is_int($creationAuditId) || ctype_digit($creationAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationAuditId, true), gettype($creationAuditId)), __LINE__);
        }
        if (is_null($creationAuditId) || (is_array($creationAuditId) && empty($creationAuditId))) {
            unset($this->CreationAuditId);
        } else {
            $this->CreationAuditId = $creationAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Crm_TemporaryRelationshipDetail
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get InviteeClientRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInviteeClientRoleId()
    {
        return isset($this->InviteeClientRoleId) ? $this->InviteeClientRoleId : null;
    }
    /**
     * Set InviteeClientRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inviteeClientRoleId
     * @return \patest\StructType\Crm_TemporaryRelationshipDetail
     */
    public function setInviteeClientRoleId($inviteeClientRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($inviteeClientRoleId) && !is_string($inviteeClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inviteeClientRoleId, true), gettype($inviteeClientRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inviteeClientRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inviteeClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inviteeClientRoleId, true)), __LINE__);
        }
        if (is_null($inviteeClientRoleId) || (is_array($inviteeClientRoleId) && empty($inviteeClientRoleId))) {
            unset($this->InviteeClientRoleId);
        } else {
            $this->InviteeClientRoleId = $inviteeClientRoleId;
        }
        return $this;
    }
    /**
     * Get InviteeEmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInviteeEmailAddress()
    {
        return isset($this->InviteeEmailAddress) ? $this->InviteeEmailAddress : null;
    }
    /**
     * Set InviteeEmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inviteeEmailAddress
     * @return \patest\StructType\Crm_TemporaryRelationshipDetail
     */
    public function setInviteeEmailAddress($inviteeEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($inviteeEmailAddress) && !is_string($inviteeEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inviteeEmailAddress, true), gettype($inviteeEmailAddress)), __LINE__);
        }
        if (is_null($inviteeEmailAddress) || (is_array($inviteeEmailAddress) && empty($inviteeEmailAddress))) {
            unset($this->InviteeEmailAddress);
        } else {
            $this->InviteeEmailAddress = $inviteeEmailAddress;
        }
        return $this;
    }
    /**
     * Get InvitingClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvitingClientId()
    {
        return isset($this->InvitingClientId) ? $this->InvitingClientId : null;
    }
    /**
     * Set InvitingClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invitingClientId
     * @return \patest\StructType\Crm_TemporaryRelationshipDetail
     */
    public function setInvitingClientId($invitingClientId = null)
    {
        // validation for constraint: string
        if (!is_null($invitingClientId) && !is_string($invitingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invitingClientId, true), gettype($invitingClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invitingClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invitingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invitingClientId, true)), __LINE__);
        }
        if (is_null($invitingClientId) || (is_array($invitingClientId) && empty($invitingClientId))) {
            unset($this->InvitingClientId);
        } else {
            $this->InvitingClientId = $invitingClientId;
        }
        return $this;
    }
    /**
     * Get InvitingClientRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvitingClientRoleId()
    {
        return isset($this->InvitingClientRoleId) ? $this->InvitingClientRoleId : null;
    }
    /**
     * Set InvitingClientRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invitingClientRoleId
     * @return \patest\StructType\Crm_TemporaryRelationshipDetail
     */
    public function setInvitingClientRoleId($invitingClientRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($invitingClientRoleId) && !is_string($invitingClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invitingClientRoleId, true), gettype($invitingClientRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invitingClientRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invitingClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invitingClientRoleId, true)), __LINE__);
        }
        if (is_null($invitingClientRoleId) || (is_array($invitingClientRoleId) && empty($invitingClientRoleId))) {
            unset($this->InvitingClientRoleId);
        } else {
            $this->InvitingClientRoleId = $invitingClientRoleId;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\Crm_TemporaryRelationshipDetail
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
}
