<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.RelationshipRoleExtended StructType
 * @subpackage Structs
 */
class Crm_RelationshipRoleExtended extends Crm_RelationshipRole
{
    /**
     * The IsDefaultRolePlayerValue
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDefaultRolePlayerValue;
    /**
     * The RelationshipTypeKind
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationshipTypeKind;
    /**
     * Constructor method for Crm.RelationshipRoleExtended
     * @uses Crm_RelationshipRoleExtended::setIsDefaultRolePlayerValue()
     * @uses Crm_RelationshipRoleExtended::setRelationshipTypeKind()
     * @param bool $isDefaultRolePlayerValue
     * @param string $relationshipTypeKind
     */
    public function __construct($isDefaultRolePlayerValue = null, $relationshipTypeKind = null)
    {
        $this
            ->setIsDefaultRolePlayerValue($isDefaultRolePlayerValue)
            ->setRelationshipTypeKind($relationshipTypeKind);
    }
    /**
     * Get IsDefaultRolePlayerValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefaultRolePlayerValue()
    {
        return isset($this->IsDefaultRolePlayerValue) ? $this->IsDefaultRolePlayerValue : null;
    }
    /**
     * Set IsDefaultRolePlayerValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefaultRolePlayerValue
     * @return \patest\StructType\Crm_RelationshipRoleExtended
     */
    public function setIsDefaultRolePlayerValue($isDefaultRolePlayerValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefaultRolePlayerValue) && !is_bool($isDefaultRolePlayerValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefaultRolePlayerValue, true), gettype($isDefaultRolePlayerValue)), __LINE__);
        }
        if (is_null($isDefaultRolePlayerValue) || (is_array($isDefaultRolePlayerValue) && empty($isDefaultRolePlayerValue))) {
            unset($this->IsDefaultRolePlayerValue);
        } else {
            $this->IsDefaultRolePlayerValue = $isDefaultRolePlayerValue;
        }
        return $this;
    }
    /**
     * Get RelationshipTypeKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipTypeKind()
    {
        return isset($this->RelationshipTypeKind) ? $this->RelationshipTypeKind : null;
    }
    /**
     * Set RelationshipTypeKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RelationshipTypeKind::valueIsValid()
     * @uses \patest\EnumType\RelationshipTypeKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relationshipTypeKind
     * @return \patest\StructType\Crm_RelationshipRoleExtended
     */
    public function setRelationshipTypeKind($relationshipTypeKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RelationshipTypeKind::valueIsValid($relationshipTypeKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RelationshipTypeKind', is_array($relationshipTypeKind) ? implode(', ', $relationshipTypeKind) : var_export($relationshipTypeKind, true), implode(', ', \patest\EnumType\RelationshipTypeKind::getValidValues())), __LINE__);
        }
        if (is_null($relationshipTypeKind) || (is_array($relationshipTypeKind) && empty($relationshipTypeKind))) {
            unset($this->RelationshipTypeKind);
        } else {
            $this->RelationshipTypeKind = $relationshipTypeKind;
        }
        return $this;
    }
}
