<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.MailRecord StructType
 * @subpackage Structs
 */
class Crm_MailRecord extends AnyEntity
{
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The QueryDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QueryDescription;
    /**
     * The QueryName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QueryName;
    /**
     * Constructor method for Crm.MailRecord
     * @uses Crm_MailRecord::setClientName()
     * @uses Crm_MailRecord::setCreationDate()
     * @uses Crm_MailRecord::setQueryDescription()
     * @uses Crm_MailRecord::setQueryName()
     * @param string $clientName
     * @param string $creationDate
     * @param string $queryDescription
     * @param string $queryName
     */
    public function __construct($clientName = null, $creationDate = null, $queryDescription = null, $queryName = null)
    {
        $this
            ->setClientName($clientName)
            ->setCreationDate($creationDate)
            ->setQueryDescription($queryDescription)
            ->setQueryName($queryName);
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Crm_MailRecord
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Crm_MailRecord
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get QueryDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryDescription()
    {
        return isset($this->QueryDescription) ? $this->QueryDescription : null;
    }
    /**
     * Set QueryDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryDescription
     * @return \patest\StructType\Crm_MailRecord
     */
    public function setQueryDescription($queryDescription = null)
    {
        // validation for constraint: string
        if (!is_null($queryDescription) && !is_string($queryDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryDescription, true), gettype($queryDescription)), __LINE__);
        }
        if (is_null($queryDescription) || (is_array($queryDescription) && empty($queryDescription))) {
            unset($this->QueryDescription);
        } else {
            $this->QueryDescription = $queryDescription;
        }
        return $this;
    }
    /**
     * Get QueryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryName()
    {
        return isset($this->QueryName) ? $this->QueryName : null;
    }
    /**
     * Set QueryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryName
     * @return \patest\StructType\Crm_MailRecord
     */
    public function setQueryName($queryName = null)
    {
        // validation for constraint: string
        if (!is_null($queryName) && !is_string($queryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryName, true), gettype($queryName)), __LINE__);
        }
        if (is_null($queryName) || (is_array($queryName) && empty($queryName))) {
            unset($this->QueryName);
        } else {
            $this->QueryName = $queryName;
        }
        return $this;
    }
}
