<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ExtendedClientReadOnlyData StructType
 * @subpackage Structs
 */
class Crm_ExtendedClientReadOnlyData extends Crm_Client
{
    /**
     * The AccountData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_AccountReadOnlyData
     */
    public $AccountData;
    /**
     * The CustomerData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_CustomerReadOnlyData
     */
    public $CustomerData;
    /**
     * Constructor method for Crm.ExtendedClientReadOnlyData
     * @uses Crm_ExtendedClientReadOnlyData::setAccountData()
     * @uses Crm_ExtendedClientReadOnlyData::setCustomerData()
     * @param \patest\StructType\Crm_AccountReadOnlyData $accountData
     * @param \patest\StructType\Crm_CustomerReadOnlyData $customerData
     */
    public function __construct(\patest\StructType\Crm_AccountReadOnlyData $accountData = null, \patest\StructType\Crm_CustomerReadOnlyData $customerData = null)
    {
        $this
            ->setAccountData($accountData)
            ->setCustomerData($customerData);
    }
    /**
     * Get AccountData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_AccountReadOnlyData|null
     */
    public function getAccountData()
    {
        return isset($this->AccountData) ? $this->AccountData : null;
    }
    /**
     * Set AccountData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_AccountReadOnlyData $accountData
     * @return \patest\StructType\Crm_ExtendedClientReadOnlyData
     */
    public function setAccountData(\patest\StructType\Crm_AccountReadOnlyData $accountData = null)
    {
        if (is_null($accountData) || (is_array($accountData) && empty($accountData))) {
            unset($this->AccountData);
        } else {
            $this->AccountData = $accountData;
        }
        return $this;
    }
    /**
     * Get CustomerData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_CustomerReadOnlyData|null
     */
    public function getCustomerData()
    {
        return isset($this->CustomerData) ? $this->CustomerData : null;
    }
    /**
     * Set CustomerData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_CustomerReadOnlyData $customerData
     * @return \patest\StructType\Crm_ExtendedClientReadOnlyData
     */
    public function setCustomerData(\patest\StructType\Crm_CustomerReadOnlyData $customerData = null)
    {
        if (is_null($customerData) || (is_array($customerData) && empty($customerData))) {
            unset($this->CustomerData);
        } else {
            $this->CustomerData = $customerData;
        }
        return $this;
    }
}
