<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.CustomerReadOnlyData StructType
 * @subpackage Structs
 */
class Crm_CustomerReadOnlyData extends AnyEntity
{
    /**
     * The AssociationIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AssociationIds
     */
    public $AssociationIds;
    /**
     * The Birthday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Birthday;
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardId;
    /**
     * The DateOfDeath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfDeath;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The GeoDemographicCodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GeoDemographicCodeId;
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderTenantId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsDeceased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeceased;
    /**
     * The IsHouseholdRepresentative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHouseholdRepresentative;
    /**
     * The JobTitleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $JobTitleId;
    /**
     * The JobTitleName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $JobTitleName;
    /**
     * The JobTitleType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JobTitleType;
    /**
     * The MaritalStatusId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MaritalStatusId;
    /**
     * The MaritalStatusName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MaritalStatusName;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_PersonName
     */
    public $Name;
    /**
     * The RelativeLeaderId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelativeLeaderId;
    /**
     * The SalutationIndividualText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalutationIndividualText;
    /**
     * The TitleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TitleId;
    /**
     * The TitleName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TitleName;
    /**
     * The TitleType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TitleType;
    /**
     * The WorkPlace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkPlace;
    /**
     * Constructor method for Crm.CustomerReadOnlyData
     * @uses Crm_CustomerReadOnlyData::setAssociationIds()
     * @uses Crm_CustomerReadOnlyData::setBirthday()
     * @uses Crm_CustomerReadOnlyData::setCardId()
     * @uses Crm_CustomerReadOnlyData::setDateOfDeath()
     * @uses Crm_CustomerReadOnlyData::setGender()
     * @uses Crm_CustomerReadOnlyData::setGeoDemographicCodeId()
     * @uses Crm_CustomerReadOnlyData::setHolderTenantId()
     * @uses Crm_CustomerReadOnlyData::setId()
     * @uses Crm_CustomerReadOnlyData::setIsDeceased()
     * @uses Crm_CustomerReadOnlyData::setIsHouseholdRepresentative()
     * @uses Crm_CustomerReadOnlyData::setJobTitleId()
     * @uses Crm_CustomerReadOnlyData::setJobTitleName()
     * @uses Crm_CustomerReadOnlyData::setJobTitleType()
     * @uses Crm_CustomerReadOnlyData::setMaritalStatusId()
     * @uses Crm_CustomerReadOnlyData::setMaritalStatusName()
     * @uses Crm_CustomerReadOnlyData::setName()
     * @uses Crm_CustomerReadOnlyData::setRelativeLeaderId()
     * @uses Crm_CustomerReadOnlyData::setSalutationIndividualText()
     * @uses Crm_CustomerReadOnlyData::setTitleId()
     * @uses Crm_CustomerReadOnlyData::setTitleName()
     * @uses Crm_CustomerReadOnlyData::setTitleType()
     * @uses Crm_CustomerReadOnlyData::setWorkPlace()
     * @param \patest\StructType\AssociationIds $associationIds
     * @param string $birthday
     * @param string $cardId
     * @param string $dateOfDeath
     * @param string $gender
     * @param string $geoDemographicCodeId
     * @param int $holderTenantId
     * @param string $id
     * @param bool $isDeceased
     * @param bool $isHouseholdRepresentative
     * @param string $jobTitleId
     * @param \patest\StructType\GlobalString $jobTitleName
     * @param string $jobTitleType
     * @param string $maritalStatusId
     * @param \patest\StructType\GlobalString $maritalStatusName
     * @param \patest\StructType\Crm_PersonName $name
     * @param string $relativeLeaderId
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @param string $titleId
     * @param \patest\StructType\GlobalString $titleName
     * @param string $titleType
     * @param string $workPlace
     */
    public function __construct(\patest\StructType\AssociationIds $associationIds = null, $birthday = null, $cardId = null, $dateOfDeath = null, $gender = null, $geoDemographicCodeId = null, $holderTenantId = null, $id = null, $isDeceased = null, $isHouseholdRepresentative = null, $jobTitleId = null, \patest\StructType\GlobalString $jobTitleName = null, $jobTitleType = null, $maritalStatusId = null, \patest\StructType\GlobalString $maritalStatusName = null, \patest\StructType\Crm_PersonName $name = null, $relativeLeaderId = null, \patest\StructType\GlobalString $salutationIndividualText = null, $titleId = null, \patest\StructType\GlobalString $titleName = null, $titleType = null, $workPlace = null)
    {
        $this
            ->setAssociationIds($associationIds)
            ->setBirthday($birthday)
            ->setCardId($cardId)
            ->setDateOfDeath($dateOfDeath)
            ->setGender($gender)
            ->setGeoDemographicCodeId($geoDemographicCodeId)
            ->setHolderTenantId($holderTenantId)
            ->setId($id)
            ->setIsDeceased($isDeceased)
            ->setIsHouseholdRepresentative($isHouseholdRepresentative)
            ->setJobTitleId($jobTitleId)
            ->setJobTitleName($jobTitleName)
            ->setJobTitleType($jobTitleType)
            ->setMaritalStatusId($maritalStatusId)
            ->setMaritalStatusName($maritalStatusName)
            ->setName($name)
            ->setRelativeLeaderId($relativeLeaderId)
            ->setSalutationIndividualText($salutationIndividualText)
            ->setTitleId($titleId)
            ->setTitleName($titleName)
            ->setTitleType($titleType)
            ->setWorkPlace($workPlace);
    }
    /**
     * Get AssociationIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AssociationIds|null
     */
    public function getAssociationIds()
    {
        return isset($this->AssociationIds) ? $this->AssociationIds : null;
    }
    /**
     * Set AssociationIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AssociationIds $associationIds
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setAssociationIds(\patest\StructType\AssociationIds $associationIds = null)
    {
        if (is_null($associationIds) || (is_array($associationIds) && empty($associationIds))) {
            unset($this->AssociationIds);
        } else {
            $this->AssociationIds = $associationIds;
        }
        return $this;
    }
    /**
     * Get Birthday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthday()
    {
        return isset($this->Birthday) ? $this->Birthday : null;
    }
    /**
     * Set Birthday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthday
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthday, true), gettype($birthday)), __LINE__);
        }
        if (is_null($birthday) || (is_array($birthday) && empty($birthday))) {
            unset($this->Birthday);
        } else {
            $this->Birthday = $birthday;
        }
        return $this;
    }
    /**
     * Get CardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardId()
    {
        return isset($this->CardId) ? $this->CardId : null;
    }
    /**
     * Set CardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardId
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        if (is_null($cardId) || (is_array($cardId) && empty($cardId))) {
            unset($this->CardId);
        } else {
            $this->CardId = $cardId;
        }
        return $this;
    }
    /**
     * Get DateOfDeath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfDeath()
    {
        return isset($this->DateOfDeath) ? $this->DateOfDeath : null;
    }
    /**
     * Set DateOfDeath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfDeath
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setDateOfDeath($dateOfDeath = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfDeath) && !is_string($dateOfDeath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfDeath, true), gettype($dateOfDeath)), __LINE__);
        }
        if (is_null($dateOfDeath) || (is_array($dateOfDeath) && empty($dateOfDeath))) {
            unset($this->DateOfDeath);
        } else {
            $this->DateOfDeath = $dateOfDeath;
        }
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GenderKind::valueIsValid()
     * @uses \patest\EnumType\GenderKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GenderKind::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GenderKind', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \patest\EnumType\GenderKind::getValidValues())), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get GeoDemographicCodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeoDemographicCodeId()
    {
        return isset($this->GeoDemographicCodeId) ? $this->GeoDemographicCodeId : null;
    }
    /**
     * Set GeoDemographicCodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geoDemographicCodeId
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setGeoDemographicCodeId($geoDemographicCodeId = null)
    {
        // validation for constraint: string
        if (!is_null($geoDemographicCodeId) && !is_string($geoDemographicCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geoDemographicCodeId, true), gettype($geoDemographicCodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($geoDemographicCodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $geoDemographicCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($geoDemographicCodeId, true)), __LINE__);
        }
        if (is_null($geoDemographicCodeId) || (is_array($geoDemographicCodeId) && empty($geoDemographicCodeId))) {
            unset($this->GeoDemographicCodeId);
        } else {
            $this->GeoDemographicCodeId = $geoDemographicCodeId;
        }
        return $this;
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderTenantId
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsDeceased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeceased()
    {
        return isset($this->IsDeceased) ? $this->IsDeceased : null;
    }
    /**
     * Set IsDeceased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeceased
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setIsDeceased($isDeceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeceased) && !is_bool($isDeceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeceased, true), gettype($isDeceased)), __LINE__);
        }
        if (is_null($isDeceased) || (is_array($isDeceased) && empty($isDeceased))) {
            unset($this->IsDeceased);
        } else {
            $this->IsDeceased = $isDeceased;
        }
        return $this;
    }
    /**
     * Get IsHouseholdRepresentative value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHouseholdRepresentative()
    {
        return isset($this->IsHouseholdRepresentative) ? $this->IsHouseholdRepresentative : null;
    }
    /**
     * Set IsHouseholdRepresentative value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHouseholdRepresentative
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setIsHouseholdRepresentative($isHouseholdRepresentative = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHouseholdRepresentative) && !is_bool($isHouseholdRepresentative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHouseholdRepresentative, true), gettype($isHouseholdRepresentative)), __LINE__);
        }
        if (is_null($isHouseholdRepresentative) || (is_array($isHouseholdRepresentative) && empty($isHouseholdRepresentative))) {
            unset($this->IsHouseholdRepresentative);
        } else {
            $this->IsHouseholdRepresentative = $isHouseholdRepresentative;
        }
        return $this;
    }
    /**
     * Get JobTitleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobTitleId()
    {
        return isset($this->JobTitleId) ? $this->JobTitleId : null;
    }
    /**
     * Set JobTitleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jobTitleId
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setJobTitleId($jobTitleId = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitleId) && !is_string($jobTitleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobTitleId, true), gettype($jobTitleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($jobTitleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $jobTitleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($jobTitleId, true)), __LINE__);
        }
        if (is_null($jobTitleId) || (is_array($jobTitleId) && empty($jobTitleId))) {
            unset($this->JobTitleId);
        } else {
            $this->JobTitleId = $jobTitleId;
        }
        return $this;
    }
    /**
     * Get JobTitleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getJobTitleName()
    {
        return isset($this->JobTitleName) ? $this->JobTitleName : null;
    }
    /**
     * Set JobTitleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $jobTitleName
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setJobTitleName(\patest\StructType\GlobalString $jobTitleName = null)
    {
        if (is_null($jobTitleName) || (is_array($jobTitleName) && empty($jobTitleName))) {
            unset($this->JobTitleName);
        } else {
            $this->JobTitleName = $jobTitleName;
        }
        return $this;
    }
    /**
     * Get JobTitleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobTitleType()
    {
        return isset($this->JobTitleType) ? $this->JobTitleType : null;
    }
    /**
     * Set JobTitleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TitleKind::valueIsValid()
     * @uses \patest\EnumType\TitleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $jobTitleType
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setJobTitleType($jobTitleType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TitleKind::valueIsValid($jobTitleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TitleKind', is_array($jobTitleType) ? implode(', ', $jobTitleType) : var_export($jobTitleType, true), implode(', ', \patest\EnumType\TitleKind::getValidValues())), __LINE__);
        }
        if (is_null($jobTitleType) || (is_array($jobTitleType) && empty($jobTitleType))) {
            unset($this->JobTitleType);
        } else {
            $this->JobTitleType = $jobTitleType;
        }
        return $this;
    }
    /**
     * Get MaritalStatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaritalStatusId()
    {
        return isset($this->MaritalStatusId) ? $this->MaritalStatusId : null;
    }
    /**
     * Set MaritalStatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maritalStatusId
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setMaritalStatusId($maritalStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($maritalStatusId) && !is_string($maritalStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maritalStatusId, true), gettype($maritalStatusId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($maritalStatusId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $maritalStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($maritalStatusId, true)), __LINE__);
        }
        if (is_null($maritalStatusId) || (is_array($maritalStatusId) && empty($maritalStatusId))) {
            unset($this->MaritalStatusId);
        } else {
            $this->MaritalStatusId = $maritalStatusId;
        }
        return $this;
    }
    /**
     * Get MaritalStatusName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMaritalStatusName()
    {
        return isset($this->MaritalStatusName) ? $this->MaritalStatusName : null;
    }
    /**
     * Set MaritalStatusName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $maritalStatusName
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setMaritalStatusName(\patest\StructType\GlobalString $maritalStatusName = null)
    {
        if (is_null($maritalStatusName) || (is_array($maritalStatusName) && empty($maritalStatusName))) {
            unset($this->MaritalStatusName);
        } else {
            $this->MaritalStatusName = $maritalStatusName;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_PersonName|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_PersonName $name
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setName(\patest\StructType\Crm_PersonName $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get RelativeLeaderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelativeLeaderId()
    {
        return isset($this->RelativeLeaderId) ? $this->RelativeLeaderId : null;
    }
    /**
     * Set RelativeLeaderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relativeLeaderId
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setRelativeLeaderId($relativeLeaderId = null)
    {
        // validation for constraint: string
        if (!is_null($relativeLeaderId) && !is_string($relativeLeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relativeLeaderId, true), gettype($relativeLeaderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relativeLeaderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relativeLeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relativeLeaderId, true)), __LINE__);
        }
        if (is_null($relativeLeaderId) || (is_array($relativeLeaderId) && empty($relativeLeaderId))) {
            unset($this->RelativeLeaderId);
        } else {
            $this->RelativeLeaderId = $relativeLeaderId;
        }
        return $this;
    }
    /**
     * Get SalutationIndividualText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalutationIndividualText()
    {
        return isset($this->SalutationIndividualText) ? $this->SalutationIndividualText : null;
    }
    /**
     * Set SalutationIndividualText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setSalutationIndividualText(\patest\StructType\GlobalString $salutationIndividualText = null)
    {
        if (is_null($salutationIndividualText) || (is_array($salutationIndividualText) && empty($salutationIndividualText))) {
            unset($this->SalutationIndividualText);
        } else {
            $this->SalutationIndividualText = $salutationIndividualText;
        }
        return $this;
    }
    /**
     * Get TitleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitleId()
    {
        return isset($this->TitleId) ? $this->TitleId : null;
    }
    /**
     * Set TitleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titleId
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setTitleId($titleId = null)
    {
        // validation for constraint: string
        if (!is_null($titleId) && !is_string($titleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titleId, true), gettype($titleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($titleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $titleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($titleId, true)), __LINE__);
        }
        if (is_null($titleId) || (is_array($titleId) && empty($titleId))) {
            unset($this->TitleId);
        } else {
            $this->TitleId = $titleId;
        }
        return $this;
    }
    /**
     * Get TitleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTitleName()
    {
        return isset($this->TitleName) ? $this->TitleName : null;
    }
    /**
     * Set TitleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $titleName
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setTitleName(\patest\StructType\GlobalString $titleName = null)
    {
        if (is_null($titleName) || (is_array($titleName) && empty($titleName))) {
            unset($this->TitleName);
        } else {
            $this->TitleName = $titleName;
        }
        return $this;
    }
    /**
     * Get TitleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitleType()
    {
        return isset($this->TitleType) ? $this->TitleType : null;
    }
    /**
     * Set TitleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TitleKind::valueIsValid()
     * @uses \patest\EnumType\TitleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $titleType
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setTitleType($titleType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TitleKind::valueIsValid($titleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TitleKind', is_array($titleType) ? implode(', ', $titleType) : var_export($titleType, true), implode(', ', \patest\EnumType\TitleKind::getValidValues())), __LINE__);
        }
        if (is_null($titleType) || (is_array($titleType) && empty($titleType))) {
            unset($this->TitleType);
        } else {
            $this->TitleType = $titleType;
        }
        return $this;
    }
    /**
     * Get WorkPlace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkPlace()
    {
        return isset($this->WorkPlace) ? $this->WorkPlace : null;
    }
    /**
     * Set WorkPlace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workPlace
     * @return \patest\StructType\Crm_CustomerReadOnlyData
     */
    public function setWorkPlace($workPlace = null)
    {
        // validation for constraint: string
        if (!is_null($workPlace) && !is_string($workPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPlace, true), gettype($workPlace)), __LINE__);
        }
        if (is_null($workPlace) || (is_array($workPlace) && empty($workPlace))) {
            unset($this->WorkPlace);
        } else {
            $this->WorkPlace = $workPlace;
        }
        return $this;
    }
}
