<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientTypeDetail StructType
 * @subpackage Structs
 */
class Crm_ClientTypeDetail extends DistributableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The IsDynamic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDynamic;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The MapToCrmSyncEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MapToCrmSyncEntity;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * The TypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TypeName;
    /**
     * The TypeNameCalculated
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TypeNameCalculated;
    /**
     * The TypeOrdinal
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TypeOrdinal;
    /**
     * The ValidFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidFromDate;
    /**
     * The ValidToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidToDate;
    /**
     * Constructor method for Crm.ClientTypeDetail
     * @uses Crm_ClientTypeDetail::setClientId()
     * @uses Crm_ClientTypeDetail::setIsDynamic()
     * @uses Crm_ClientTypeDetail::setIsValid()
     * @uses Crm_ClientTypeDetail::setMapToCrmSyncEntity()
     * @uses Crm_ClientTypeDetail::setOrganizationUnitId()
     * @uses Crm_ClientTypeDetail::setPriority()
     * @uses Crm_ClientTypeDetail::setTypeId()
     * @uses Crm_ClientTypeDetail::setTypeName()
     * @uses Crm_ClientTypeDetail::setTypeNameCalculated()
     * @uses Crm_ClientTypeDetail::setTypeOrdinal()
     * @uses Crm_ClientTypeDetail::setValidFromDate()
     * @uses Crm_ClientTypeDetail::setValidToDate()
     * @param string $clientId
     * @param bool $isDynamic
     * @param bool $isValid
     * @param int $mapToCrmSyncEntity
     * @param string $organizationUnitId
     * @param int $priority
     * @param string $typeId
     * @param \patest\StructType\GlobalString $typeName
     * @param \patest\StructType\GlobalString $typeNameCalculated
     * @param int $typeOrdinal
     * @param string $validFromDate
     * @param string $validToDate
     */
    public function __construct($clientId = null, $isDynamic = null, $isValid = null, $mapToCrmSyncEntity = null, $organizationUnitId = null, $priority = null, $typeId = null, \patest\StructType\GlobalString $typeName = null, \patest\StructType\GlobalString $typeNameCalculated = null, $typeOrdinal = null, $validFromDate = null, $validToDate = null)
    {
        $this
            ->setClientId($clientId)
            ->setIsDynamic($isDynamic)
            ->setIsValid($isValid)
            ->setMapToCrmSyncEntity($mapToCrmSyncEntity)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPriority($priority)
            ->setTypeId($typeId)
            ->setTypeName($typeName)
            ->setTypeNameCalculated($typeNameCalculated)
            ->setTypeOrdinal($typeOrdinal)
            ->setValidFromDate($validFromDate)
            ->setValidToDate($validToDate);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get IsDynamic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDynamic()
    {
        return isset($this->IsDynamic) ? $this->IsDynamic : null;
    }
    /**
     * Set IsDynamic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDynamic
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setIsDynamic($isDynamic = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDynamic) && !is_bool($isDynamic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDynamic, true), gettype($isDynamic)), __LINE__);
        }
        if (is_null($isDynamic) || (is_array($isDynamic) && empty($isDynamic))) {
            unset($this->IsDynamic);
        } else {
            $this->IsDynamic = $isDynamic;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get MapToCrmSyncEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMapToCrmSyncEntity()
    {
        return isset($this->MapToCrmSyncEntity) ? $this->MapToCrmSyncEntity : null;
    }
    /**
     * Set MapToCrmSyncEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mapToCrmSyncEntity
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setMapToCrmSyncEntity($mapToCrmSyncEntity = null)
    {
        // validation for constraint: int
        if (!is_null($mapToCrmSyncEntity) && !(is_int($mapToCrmSyncEntity) || ctype_digit($mapToCrmSyncEntity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mapToCrmSyncEntity, true), gettype($mapToCrmSyncEntity)), __LINE__);
        }
        if (is_null($mapToCrmSyncEntity) || (is_array($mapToCrmSyncEntity) && empty($mapToCrmSyncEntity))) {
            unset($this->MapToCrmSyncEntity);
        } else {
            $this->MapToCrmSyncEntity = $mapToCrmSyncEntity;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
    /**
     * Get TypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTypeName()
    {
        return isset($this->TypeName) ? $this->TypeName : null;
    }
    /**
     * Set TypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $typeName
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setTypeName(\patest\StructType\GlobalString $typeName = null)
    {
        if (is_null($typeName) || (is_array($typeName) && empty($typeName))) {
            unset($this->TypeName);
        } else {
            $this->TypeName = $typeName;
        }
        return $this;
    }
    /**
     * Get TypeNameCalculated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTypeNameCalculated()
    {
        return isset($this->TypeNameCalculated) ? $this->TypeNameCalculated : null;
    }
    /**
     * Set TypeNameCalculated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $typeNameCalculated
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setTypeNameCalculated(\patest\StructType\GlobalString $typeNameCalculated = null)
    {
        if (is_null($typeNameCalculated) || (is_array($typeNameCalculated) && empty($typeNameCalculated))) {
            unset($this->TypeNameCalculated);
        } else {
            $this->TypeNameCalculated = $typeNameCalculated;
        }
        return $this;
    }
    /**
     * Get TypeOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTypeOrdinal()
    {
        return isset($this->TypeOrdinal) ? $this->TypeOrdinal : null;
    }
    /**
     * Set TypeOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $typeOrdinal
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setTypeOrdinal($typeOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($typeOrdinal) && !(is_int($typeOrdinal) || ctype_digit($typeOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeOrdinal, true), gettype($typeOrdinal)), __LINE__);
        }
        if (is_null($typeOrdinal) || (is_array($typeOrdinal) && empty($typeOrdinal))) {
            unset($this->TypeOrdinal);
        } else {
            $this->TypeOrdinal = $typeOrdinal;
        }
        return $this;
    }
    /**
     * Get ValidFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidFromDate()
    {
        return isset($this->ValidFromDate) ? $this->ValidFromDate : null;
    }
    /**
     * Set ValidFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validFromDate
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setValidFromDate($validFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($validFromDate) && !is_string($validFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFromDate, true), gettype($validFromDate)), __LINE__);
        }
        if (is_null($validFromDate) || (is_array($validFromDate) && empty($validFromDate))) {
            unset($this->ValidFromDate);
        } else {
            $this->ValidFromDate = $validFromDate;
        }
        return $this;
    }
    /**
     * Get ValidToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidToDate()
    {
        return isset($this->ValidToDate) ? $this->ValidToDate : null;
    }
    /**
     * Set ValidToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validToDate
     * @return \patest\StructType\Crm_ClientTypeDetail
     */
    public function setValidToDate($validToDate = null)
    {
        // validation for constraint: string
        if (!is_null($validToDate) && !is_string($validToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validToDate, true), gettype($validToDate)), __LINE__);
        }
        if (is_null($validToDate) || (is_array($validToDate) && empty($validToDate))) {
            unset($this->ValidToDate);
        } else {
            $this->ValidToDate = $validToDate;
        }
        return $this;
    }
}
