<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientActivityType StructType
 * @subpackage Structs
 */
class Crm_ClientActivityType extends PersistableEntity
{
    /**
     * The CaptionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CaptionId;
    /**
     * The GroupType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupType;
    /**
     * The IconId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IconId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsVisibleOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisibleOnline;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Tokens
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ClientActivityTokenDescription
     */
    public $Tokens;
    /**
     * The TokensData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TokensData;
    /**
     * The TokensList
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TokensList;
    /**
     * Constructor method for Crm.ClientActivityType
     * @uses Crm_ClientActivityType::setCaptionId()
     * @uses Crm_ClientActivityType::setGroupType()
     * @uses Crm_ClientActivityType::setIconId()
     * @uses Crm_ClientActivityType::setIsActive()
     * @uses Crm_ClientActivityType::setIsVisibleOnline()
     * @uses Crm_ClientActivityType::setName()
     * @uses Crm_ClientActivityType::setTokens()
     * @uses Crm_ClientActivityType::setTokensData()
     * @uses Crm_ClientActivityType::setTokensList()
     * @param string $captionId
     * @param string $groupType
     * @param int $iconId
     * @param bool $isActive
     * @param bool $isVisibleOnline
     * @param \patest\StructType\GlobalString $name
     * @param \patest\StructType\RecordSetOfCrm_ClientActivityTokenDescription $tokens
     * @param string $tokensData
     * @param string $tokensList
     */
    public function __construct($captionId = null, $groupType = null, $iconId = null, $isActive = null, $isVisibleOnline = null, \patest\StructType\GlobalString $name = null, \patest\StructType\RecordSetOfCrm_ClientActivityTokenDescription $tokens = null, $tokensData = null, $tokensList = null)
    {
        $this
            ->setCaptionId($captionId)
            ->setGroupType($groupType)
            ->setIconId($iconId)
            ->setIsActive($isActive)
            ->setIsVisibleOnline($isVisibleOnline)
            ->setName($name)
            ->setTokens($tokens)
            ->setTokensData($tokensData)
            ->setTokensList($tokensList);
    }
    /**
     * Get CaptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCaptionId()
    {
        return isset($this->CaptionId) ? $this->CaptionId : null;
    }
    /**
     * Set CaptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $captionId
     * @return \patest\StructType\Crm_ClientActivityType
     */
    public function setCaptionId($captionId = null)
    {
        // validation for constraint: string
        if (!is_null($captionId) && !is_string($captionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($captionId, true), gettype($captionId)), __LINE__);
        }
        if (is_null($captionId) || (is_array($captionId) && empty($captionId))) {
            unset($this->CaptionId);
        } else {
            $this->CaptionId = $captionId;
        }
        return $this;
    }
    /**
     * Get GroupType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupType()
    {
        return isset($this->GroupType) ? $this->GroupType : null;
    }
    /**
     * Set GroupType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ActivityGroupType::valueIsValid()
     * @uses \patest\EnumType\ActivityGroupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupType
     * @return \patest\StructType\Crm_ClientActivityType
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ActivityGroupType::valueIsValid($groupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ActivityGroupType', is_array($groupType) ? implode(', ', $groupType) : var_export($groupType, true), implode(', ', \patest\EnumType\ActivityGroupType::getValidValues())), __LINE__);
        }
        if (is_null($groupType) || (is_array($groupType) && empty($groupType))) {
            unset($this->GroupType);
        } else {
            $this->GroupType = $groupType;
        }
        return $this;
    }
    /**
     * Get IconId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIconId()
    {
        return isset($this->IconId) ? $this->IconId : null;
    }
    /**
     * Set IconId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iconId
     * @return \patest\StructType\Crm_ClientActivityType
     */
    public function setIconId($iconId = null)
    {
        // validation for constraint: int
        if (!is_null($iconId) && !(is_int($iconId) || ctype_digit($iconId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iconId, true), gettype($iconId)), __LINE__);
        }
        if (is_null($iconId) || (is_array($iconId) && empty($iconId))) {
            unset($this->IconId);
        } else {
            $this->IconId = $iconId;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Crm_ClientActivityType
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsVisibleOnline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisibleOnline()
    {
        return isset($this->IsVisibleOnline) ? $this->IsVisibleOnline : null;
    }
    /**
     * Set IsVisibleOnline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisibleOnline
     * @return \patest\StructType\Crm_ClientActivityType
     */
    public function setIsVisibleOnline($isVisibleOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisibleOnline) && !is_bool($isVisibleOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisibleOnline, true), gettype($isVisibleOnline)), __LINE__);
        }
        if (is_null($isVisibleOnline) || (is_array($isVisibleOnline) && empty($isVisibleOnline))) {
            unset($this->IsVisibleOnline);
        } else {
            $this->IsVisibleOnline = $isVisibleOnline;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Crm_ClientActivityType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Tokens value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ClientActivityTokenDescription|null
     */
    public function getTokens()
    {
        return isset($this->Tokens) ? $this->Tokens : null;
    }
    /**
     * Set Tokens value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ClientActivityTokenDescription $tokens
     * @return \patest\StructType\Crm_ClientActivityType
     */
    public function setTokens(\patest\StructType\RecordSetOfCrm_ClientActivityTokenDescription $tokens = null)
    {
        if (is_null($tokens) || (is_array($tokens) && empty($tokens))) {
            unset($this->Tokens);
        } else {
            $this->Tokens = $tokens;
        }
        return $this;
    }
    /**
     * Get TokensData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTokensData()
    {
        return isset($this->TokensData) ? $this->TokensData : null;
    }
    /**
     * Set TokensData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tokensData
     * @return \patest\StructType\Crm_ClientActivityType
     */
    public function setTokensData($tokensData = null)
    {
        // validation for constraint: string
        if (!is_null($tokensData) && !is_string($tokensData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokensData, true), gettype($tokensData)), __LINE__);
        }
        if (is_null($tokensData) || (is_array($tokensData) && empty($tokensData))) {
            unset($this->TokensData);
        } else {
            $this->TokensData = $tokensData;
        }
        return $this;
    }
    /**
     * Get TokensList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTokensList()
    {
        return isset($this->TokensList) ? $this->TokensList : null;
    }
    /**
     * Set TokensList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tokensList
     * @return \patest\StructType\Crm_ClientActivityType
     */
    public function setTokensList($tokensList = null)
    {
        // validation for constraint: string
        if (!is_null($tokensList) && !is_string($tokensList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokensList, true), gettype($tokensList)), __LINE__);
        }
        if (is_null($tokensList) || (is_array($tokensList) && empty($tokensList))) {
            unset($this->TokensList);
        } else {
            $this->TokensList = $tokensList;
        }
        return $this;
    }
}
