<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardPaymentItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreditCardPaymentItem
 * @subpackage Structs
 */
class CreditCardPaymentItem extends OnlinePaymentItem
{
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Supplier;
    /**
     * The VoucherData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherData;
    /**
     * Constructor method for CreditCardPaymentItem
     * @uses CreditCardPaymentItem::setSupplier()
     * @uses CreditCardPaymentItem::setVoucherData()
     * @param string $supplier
     * @param string $voucherData
     */
    public function __construct($supplier = null, $voucherData = null)
    {
        $this
            ->setSupplier($supplier)
            ->setVoucherData($voucherData);
    }
    /**
     * Get Supplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplier()
    {
        return isset($this->Supplier) ? $this->Supplier : null;
    }
    /**
     * Set Supplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplier
     * @return \patest\StructType\CreditCardPaymentItem
     */
    public function setSupplier($supplier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier) && !is_string($supplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier, true), gettype($supplier)), __LINE__);
        }
        if (is_null($supplier) || (is_array($supplier) && empty($supplier))) {
            unset($this->Supplier);
        } else {
            $this->Supplier = $supplier;
        }
        return $this;
    }
    /**
     * Get VoucherData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherData()
    {
        return isset($this->VoucherData) ? $this->VoucherData : null;
    }
    /**
     * Set VoucherData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherData
     * @return \patest\StructType\CreditCardPaymentItem
     */
    public function setVoucherData($voucherData = null)
    {
        // validation for constraint: string
        if (!is_null($voucherData) && !is_string($voucherData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherData, true), gettype($voucherData)), __LINE__);
        }
        if (is_null($voucherData) || (is_array($voucherData) && empty($voucherData))) {
            unset($this->VoucherData);
        } else {
            $this->VoucherData = $voucherData;
        }
        return $this;
    }
}
