<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateBarcodeForProduct-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateBarcodeForProduct-Request
 * @subpackage Structs
 */
class CreateBarcodeForProduct_Request extends ExtensibleDataContract
{
    /**
     * The EntityIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $EntityIds;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * Constructor method for CreateBarcodeForProduct-Request
     * @uses CreateBarcodeForProduct_Request::setEntityIds()
     * @uses CreateBarcodeForProduct_Request::setEntityName()
     * @param \patest\ArrayType\ArrayOfguid $entityIds
     * @param string $entityName
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $entityIds = null, $entityName = null)
    {
        $this
            ->setEntityIds($entityIds)
            ->setEntityName($entityName);
    }
    /**
     * Get EntityIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getEntityIds()
    {
        return isset($this->EntityIds) ? $this->EntityIds : null;
    }
    /**
     * Set EntityIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $entityIds
     * @return \patest\StructType\CreateBarcodeForProduct_Request
     */
    public function setEntityIds(\patest\ArrayType\ArrayOfguid $entityIds = null)
    {
        if (is_null($entityIds) || (is_array($entityIds) && empty($entityIds))) {
            unset($this->EntityIds);
        } else {
            $this->EntityIds = $entityIds;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\CreateBarcodeForProduct_Request
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
}
