<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CloseShifts-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CloseShifts-Request
 * @subpackage Structs
 */
class CloseShifts_Request extends ExtensibleDataContract
{
    /**
     * The CloseAllShifts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CloseAllShifts;
    /**
     * The TillIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TillIds;
    /**
     * Constructor method for CloseShifts-Request
     * @uses CloseShifts_Request::setCloseAllShifts()
     * @uses CloseShifts_Request::setTillIds()
     * @param bool $closeAllShifts
     * @param \patest\ArrayType\ArrayOfguid $tillIds
     */
    public function __construct($closeAllShifts = null, \patest\ArrayType\ArrayOfguid $tillIds = null)
    {
        $this
            ->setCloseAllShifts($closeAllShifts)
            ->setTillIds($tillIds);
    }
    /**
     * Get CloseAllShifts value
     * @return bool|null
     */
    public function getCloseAllShifts()
    {
        return $this->CloseAllShifts;
    }
    /**
     * Set CloseAllShifts value
     * @param bool $closeAllShifts
     * @return \patest\StructType\CloseShifts_Request
     */
    public function setCloseAllShifts($closeAllShifts = null)
    {
        // validation for constraint: boolean
        if (!is_null($closeAllShifts) && !is_bool($closeAllShifts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($closeAllShifts, true), gettype($closeAllShifts)), __LINE__);
        }
        $this->CloseAllShifts = $closeAllShifts;
        return $this;
    }
    /**
     * Get TillIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTillIds()
    {
        return isset($this->TillIds) ? $this->TillIds : null;
    }
    /**
     * Set TillIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $tillIds
     * @return \patest\StructType\CloseShifts_Request
     */
    public function setTillIds(\patest\ArrayType\ArrayOfguid $tillIds = null)
    {
        if (is_null($tillIds) || (is_array($tillIds) && empty($tillIds))) {
            unset($this->TillIds);
        } else {
            $this->TillIds = $tillIds;
        }
        return $this;
    }
}
