<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CloseEventsForSale-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CloseEventsForSale-Response
 * @subpackage Structs
 */
class CloseEventsForSale_Response extends ExtensibleDataContract
{
    /**
     * The ClosedEventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ClosedEventIds;
    /**
     * Constructor method for CloseEventsForSale-Response
     * @uses CloseEventsForSale_Response::setClosedEventIds()
     * @param \patest\ArrayType\ArrayOfguid $closedEventIds
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $closedEventIds = null)
    {
        $this
            ->setClosedEventIds($closedEventIds);
    }
    /**
     * Get ClosedEventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getClosedEventIds()
    {
        return isset($this->ClosedEventIds) ? $this->ClosedEventIds : null;
    }
    /**
     * Set ClosedEventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $closedEventIds
     * @return \patest\StructType\CloseEventsForSale_Response
     */
    public function setClosedEventIds(\patest\ArrayType\ArrayOfguid $closedEventIds = null)
    {
        if (is_null($closedEventIds) || (is_array($closedEventIds) && empty($closedEventIds))) {
            unset($this->ClosedEventIds);
        } else {
            $this->ClosedEventIds = $closedEventIds;
        }
        return $this;
    }
}
