<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientTicket StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientTicket
 * @subpackage Structs
 */
class ClientTicket extends AbstractStructBase
{
    /**
     * The PrintedTicketInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTicketPrintedDetails
     */
    public $PrintedTicketInfo;
    /**
     * The TicketInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTicketDetails
     */
    public $TicketInfo;
    /**
     * Constructor method for ClientTicket
     * @uses ClientTicket::setPrintedTicketInfo()
     * @uses ClientTicket::setTicketInfo()
     * @param \patest\StructType\ClientTicketPrintedDetails $printedTicketInfo
     * @param \patest\StructType\ClientTicketDetails $ticketInfo
     */
    public function __construct(\patest\StructType\ClientTicketPrintedDetails $printedTicketInfo = null, \patest\StructType\ClientTicketDetails $ticketInfo = null)
    {
        $this
            ->setPrintedTicketInfo($printedTicketInfo)
            ->setTicketInfo($ticketInfo);
    }
    /**
     * Get PrintedTicketInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTicketPrintedDetails|null
     */
    public function getPrintedTicketInfo()
    {
        return isset($this->PrintedTicketInfo) ? $this->PrintedTicketInfo : null;
    }
    /**
     * Set PrintedTicketInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTicketPrintedDetails $printedTicketInfo
     * @return \patest\StructType\ClientTicket
     */
    public function setPrintedTicketInfo(\patest\StructType\ClientTicketPrintedDetails $printedTicketInfo = null)
    {
        if (is_null($printedTicketInfo) || (is_array($printedTicketInfo) && empty($printedTicketInfo))) {
            unset($this->PrintedTicketInfo);
        } else {
            $this->PrintedTicketInfo = $printedTicketInfo;
        }
        return $this;
    }
    /**
     * Get TicketInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTicketDetails|null
     */
    public function getTicketInfo()
    {
        return isset($this->TicketInfo) ? $this->TicketInfo : null;
    }
    /**
     * Set TicketInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTicketDetails $ticketInfo
     * @return \patest\StructType\ClientTicket
     */
    public function setTicketInfo(\patest\StructType\ClientTicketDetails $ticketInfo = null)
    {
        if (is_null($ticketInfo) || (is_array($ticketInfo) && empty($ticketInfo))) {
            unset($this->TicketInfo);
        } else {
            $this->TicketInfo = $ticketInfo;
        }
        return $this;
    }
}
