<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClassContent StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClassContent
 * @subpackage Structs
 */
class ClassContent extends AbstractStructBase
{
    /**
     * The ClassNodeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClassNodeId;
    /**
     * The ContentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContentId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NodeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NodeType;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * Constructor method for ClassContent
     * @uses ClassContent::setClassNodeId()
     * @uses ClassContent::setContentId()
     * @uses ClassContent::setId()
     * @uses ClassContent::setName()
     * @uses ClassContent::setNodeType()
     * @uses ClassContent::setOrdinal()
     * @param string $classNodeId
     * @param string $contentId
     * @param string $id
     * @param string $name
     * @param string $nodeType
     * @param int $ordinal
     */
    public function __construct($classNodeId = null, $contentId = null, $id = null, $name = null, $nodeType = null, $ordinal = null)
    {
        $this
            ->setClassNodeId($classNodeId)
            ->setContentId($contentId)
            ->setId($id)
            ->setName($name)
            ->setNodeType($nodeType)
            ->setOrdinal($ordinal);
    }
    /**
     * Get ClassNodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClassNodeId()
    {
        return isset($this->ClassNodeId) ? $this->ClassNodeId : null;
    }
    /**
     * Set ClassNodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classNodeId
     * @return \patest\StructType\ClassContent
     */
    public function setClassNodeId($classNodeId = null)
    {
        // validation for constraint: string
        if (!is_null($classNodeId) && !is_string($classNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classNodeId, true), gettype($classNodeId)), __LINE__);
        }
        if (is_null($classNodeId) || (is_array($classNodeId) && empty($classNodeId))) {
            unset($this->ClassNodeId);
        } else {
            $this->ClassNodeId = $classNodeId;
        }
        return $this;
    }
    /**
     * Get ContentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentId()
    {
        return isset($this->ContentId) ? $this->ContentId : null;
    }
    /**
     * Set ContentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentId
     * @return \patest\StructType\ClassContent
     */
    public function setContentId($contentId = null)
    {
        // validation for constraint: string
        if (!is_null($contentId) && !is_string($contentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentId, true), gettype($contentId)), __LINE__);
        }
        if (is_null($contentId) || (is_array($contentId) && empty($contentId))) {
            unset($this->ContentId);
        } else {
            $this->ContentId = $contentId;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\ClassContent
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\ClassContent
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NodeType value
     * @return string|null
     */
    public function getNodeType()
    {
        return $this->NodeType;
    }
    /**
     * Set NodeType value
     * @uses \patest\EnumType\NodeType::valueIsValid()
     * @uses \patest\EnumType\NodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nodeType
     * @return \patest\StructType\ClassContent
     */
    public function setNodeType($nodeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\NodeType::valueIsValid($nodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\NodeType', is_array($nodeType) ? implode(', ', $nodeType) : var_export($nodeType, true), implode(', ', \patest\EnumType\NodeType::getValidValues())), __LINE__);
        }
        $this->NodeType = $nodeType;
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \patest\StructType\ClassContent
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
}
