<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangePassword-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChangePassword-Request
 * @subpackage Structs
 */
class ChangePassword_Request extends ExtensibleDataContract
{
    /**
     * The NewUserPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewUserPassword;
    /**
     * The OldUserPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldUserPassword;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The UserLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserLogin;
    /**
     * The UserType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserType;
    /**
     * Constructor method for ChangePassword-Request
     * @uses ChangePassword_Request::setNewUserPassword()
     * @uses ChangePassword_Request::setOldUserPassword()
     * @uses ChangePassword_Request::setOrganizationUnitId()
     * @uses ChangePassword_Request::setUserLogin()
     * @uses ChangePassword_Request::setUserType()
     * @param string $newUserPassword
     * @param string $oldUserPassword
     * @param string $organizationUnitId
     * @param string $userLogin
     * @param string $userType
     */
    public function __construct($newUserPassword = null, $oldUserPassword = null, $organizationUnitId = null, $userLogin = null, $userType = null)
    {
        $this
            ->setNewUserPassword($newUserPassword)
            ->setOldUserPassword($oldUserPassword)
            ->setOrganizationUnitId($organizationUnitId)
            ->setUserLogin($userLogin)
            ->setUserType($userType);
    }
    /**
     * Get NewUserPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewUserPassword()
    {
        return isset($this->NewUserPassword) ? $this->NewUserPassword : null;
    }
    /**
     * Set NewUserPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newUserPassword
     * @return \patest\StructType\ChangePassword_Request
     */
    public function setNewUserPassword($newUserPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newUserPassword) && !is_string($newUserPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newUserPassword, true), gettype($newUserPassword)), __LINE__);
        }
        if (is_null($newUserPassword) || (is_array($newUserPassword) && empty($newUserPassword))) {
            unset($this->NewUserPassword);
        } else {
            $this->NewUserPassword = $newUserPassword;
        }
        return $this;
    }
    /**
     * Get OldUserPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldUserPassword()
    {
        return isset($this->OldUserPassword) ? $this->OldUserPassword : null;
    }
    /**
     * Set OldUserPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldUserPassword
     * @return \patest\StructType\ChangePassword_Request
     */
    public function setOldUserPassword($oldUserPassword = null)
    {
        // validation for constraint: string
        if (!is_null($oldUserPassword) && !is_string($oldUserPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldUserPassword, true), gettype($oldUserPassword)), __LINE__);
        }
        if (is_null($oldUserPassword) || (is_array($oldUserPassword) && empty($oldUserPassword))) {
            unset($this->OldUserPassword);
        } else {
            $this->OldUserPassword = $oldUserPassword;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\ChangePassword_Request
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get UserLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLogin()
    {
        return isset($this->UserLogin) ? $this->UserLogin : null;
    }
    /**
     * Set UserLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLogin
     * @return \patest\StructType\ChangePassword_Request
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLogin, true), gettype($userLogin)), __LINE__);
        }
        if (is_null($userLogin) || (is_array($userLogin) && empty($userLogin))) {
            unset($this->UserLogin);
        } else {
            $this->UserLogin = $userLogin;
        }
        return $this;
    }
    /**
     * Get UserType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserType()
    {
        return isset($this->UserType) ? $this->UserType : null;
    }
    /**
     * Set UserType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userType
     * @return \patest\StructType\ChangePassword_Request
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: string
        if (!is_null($userType) && !is_string($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userType, true), gettype($userType)), __LINE__);
        }
        if (is_null($userType) || (is_array($userType) && empty($userType))) {
            unset($this->UserType);
        } else {
            $this->UserType = $userType;
        }
        return $this;
    }
}
