<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BundleElementValidationDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BundleElementValidationDetails
 * @subpackage Structs
 */
class BundleElementValidationDetails extends AbstractStructBase
{
    /**
     * The ElementSelection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BundleElementConfiguration
     */
    public $ElementSelection;
    /**
     * The FailureDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\FailureInformation
     */
    public $FailureDetails;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsValid;
    /**
     * Constructor method for BundleElementValidationDetails
     * @uses BundleElementValidationDetails::setElementSelection()
     * @uses BundleElementValidationDetails::setFailureDetails()
     * @uses BundleElementValidationDetails::setIsValid()
     * @param \patest\StructType\BundleElementConfiguration $elementSelection
     * @param \patest\StructType\FailureInformation $failureDetails
     * @param bool $isValid
     */
    public function __construct(\patest\StructType\BundleElementConfiguration $elementSelection = null, \patest\StructType\FailureInformation $failureDetails = null, $isValid = null)
    {
        $this
            ->setElementSelection($elementSelection)
            ->setFailureDetails($failureDetails)
            ->setIsValid($isValid);
    }
    /**
     * Get ElementSelection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BundleElementConfiguration|null
     */
    public function getElementSelection()
    {
        return isset($this->ElementSelection) ? $this->ElementSelection : null;
    }
    /**
     * Set ElementSelection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BundleElementConfiguration $elementSelection
     * @return \patest\StructType\BundleElementValidationDetails
     */
    public function setElementSelection(\patest\StructType\BundleElementConfiguration $elementSelection = null)
    {
        if (is_null($elementSelection) || (is_array($elementSelection) && empty($elementSelection))) {
            unset($this->ElementSelection);
        } else {
            $this->ElementSelection = $elementSelection;
        }
        return $this;
    }
    /**
     * Get FailureDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\FailureInformation|null
     */
    public function getFailureDetails()
    {
        return isset($this->FailureDetails) ? $this->FailureDetails : null;
    }
    /**
     * Set FailureDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\FailureInformation $failureDetails
     * @return \patest\StructType\BundleElementValidationDetails
     */
    public function setFailureDetails(\patest\StructType\FailureInformation $failureDetails = null)
    {
        if (is_null($failureDetails) || (is_array($failureDetails) && empty($failureDetails))) {
            unset($this->FailureDetails);
        } else {
            $this->FailureDetails = $failureDetails;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * @return bool|null
     */
    public function getIsValid()
    {
        return $this->IsValid;
    }
    /**
     * Set IsValid value
     * @param bool $isValid
     * @return \patest\StructType\BundleElementValidationDetails
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        $this->IsValid = $isValid;
        return $this;
    }
}
