<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.VisitPricedGuidance StructType
 * @subpackage Structs
 */
class BizResource_VisitPricedGuidance extends BizResource_PersistableEntityBase
{
    /**
     * The ActivityCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActivityCategoryId;
    /**
     * The GuideRequestId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuideRequestId;
    /**
     * The OrderVisitActivityCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitActivityCategoryId;
    /**
     * The OrderVisitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitId;
    /**
     * The PayerAccountId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayerAccountId;
    /**
     * The PriceToPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PriceToPay;
    /**
     * Constructor method for BizResource.VisitPricedGuidance
     * @uses BizResource_VisitPricedGuidance::setActivityCategoryId()
     * @uses BizResource_VisitPricedGuidance::setGuideRequestId()
     * @uses BizResource_VisitPricedGuidance::setOrderVisitActivityCategoryId()
     * @uses BizResource_VisitPricedGuidance::setOrderVisitId()
     * @uses BizResource_VisitPricedGuidance::setPayerAccountId()
     * @uses BizResource_VisitPricedGuidance::setPriceToPay()
     * @param string $activityCategoryId
     * @param string $guideRequestId
     * @param string $orderVisitActivityCategoryId
     * @param string $orderVisitId
     * @param string $payerAccountId
     * @param float $priceToPay
     */
    public function __construct($activityCategoryId = null, $guideRequestId = null, $orderVisitActivityCategoryId = null, $orderVisitId = null, $payerAccountId = null, $priceToPay = null)
    {
        $this
            ->setActivityCategoryId($activityCategoryId)
            ->setGuideRequestId($guideRequestId)
            ->setOrderVisitActivityCategoryId($orderVisitActivityCategoryId)
            ->setOrderVisitId($orderVisitId)
            ->setPayerAccountId($payerAccountId)
            ->setPriceToPay($priceToPay);
    }
    /**
     * Get ActivityCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityCategoryId()
    {
        return isset($this->ActivityCategoryId) ? $this->ActivityCategoryId : null;
    }
    /**
     * Set ActivityCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityCategoryId
     * @return \patest\StructType\BizResource_VisitPricedGuidance
     */
    public function setActivityCategoryId($activityCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($activityCategoryId) && !is_string($activityCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityCategoryId, true), gettype($activityCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($activityCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $activityCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($activityCategoryId, true)), __LINE__);
        }
        if (is_null($activityCategoryId) || (is_array($activityCategoryId) && empty($activityCategoryId))) {
            unset($this->ActivityCategoryId);
        } else {
            $this->ActivityCategoryId = $activityCategoryId;
        }
        return $this;
    }
    /**
     * Get GuideRequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuideRequestId()
    {
        return isset($this->GuideRequestId) ? $this->GuideRequestId : null;
    }
    /**
     * Set GuideRequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guideRequestId
     * @return \patest\StructType\BizResource_VisitPricedGuidance
     */
    public function setGuideRequestId($guideRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($guideRequestId) && !is_string($guideRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guideRequestId, true), gettype($guideRequestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guideRequestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guideRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guideRequestId, true)), __LINE__);
        }
        if (is_null($guideRequestId) || (is_array($guideRequestId) && empty($guideRequestId))) {
            unset($this->GuideRequestId);
        } else {
            $this->GuideRequestId = $guideRequestId;
        }
        return $this;
    }
    /**
     * Get OrderVisitActivityCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitActivityCategoryId()
    {
        return isset($this->OrderVisitActivityCategoryId) ? $this->OrderVisitActivityCategoryId : null;
    }
    /**
     * Set OrderVisitActivityCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitActivityCategoryId
     * @return \patest\StructType\BizResource_VisitPricedGuidance
     */
    public function setOrderVisitActivityCategoryId($orderVisitActivityCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitActivityCategoryId) && !is_string($orderVisitActivityCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitActivityCategoryId, true), gettype($orderVisitActivityCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitActivityCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitActivityCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitActivityCategoryId, true)), __LINE__);
        }
        if (is_null($orderVisitActivityCategoryId) || (is_array($orderVisitActivityCategoryId) && empty($orderVisitActivityCategoryId))) {
            unset($this->OrderVisitActivityCategoryId);
        } else {
            $this->OrderVisitActivityCategoryId = $orderVisitActivityCategoryId;
        }
        return $this;
    }
    /**
     * Get OrderVisitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitId()
    {
        return isset($this->OrderVisitId) ? $this->OrderVisitId : null;
    }
    /**
     * Set OrderVisitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitId
     * @return \patest\StructType\BizResource_VisitPricedGuidance
     */
    public function setOrderVisitId($orderVisitId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitId) && !is_string($orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitId, true), gettype($orderVisitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitId, true)), __LINE__);
        }
        if (is_null($orderVisitId) || (is_array($orderVisitId) && empty($orderVisitId))) {
            unset($this->OrderVisitId);
        } else {
            $this->OrderVisitId = $orderVisitId;
        }
        return $this;
    }
    /**
     * Get PayerAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerAccountId()
    {
        return isset($this->PayerAccountId) ? $this->PayerAccountId : null;
    }
    /**
     * Set PayerAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerAccountId
     * @return \patest\StructType\BizResource_VisitPricedGuidance
     */
    public function setPayerAccountId($payerAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($payerAccountId) && !is_string($payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerAccountId, true), gettype($payerAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payerAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payerAccountId, true)), __LINE__);
        }
        if (is_null($payerAccountId) || (is_array($payerAccountId) && empty($payerAccountId))) {
            unset($this->PayerAccountId);
        } else {
            $this->PayerAccountId = $payerAccountId;
        }
        return $this;
    }
    /**
     * Get PriceToPay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPriceToPay()
    {
        return isset($this->PriceToPay) ? $this->PriceToPay : null;
    }
    /**
     * Set PriceToPay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $priceToPay
     * @return \patest\StructType\BizResource_VisitPricedGuidance
     */
    public function setPriceToPay($priceToPay = null)
    {
        // validation for constraint: float
        if (!is_null($priceToPay) && !(is_float($priceToPay) || is_numeric($priceToPay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceToPay, true), gettype($priceToPay)), __LINE__);
        }
        if (is_null($priceToPay) || (is_array($priceToPay) && empty($priceToPay))) {
            unset($this->PriceToPay);
        } else {
            $this->PriceToPay = $priceToPay;
        }
        return $this;
    }
}
