<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.VisitPlanFilter StructType
 * @subpackage Structs
 */
class BizResource_VisitPlanFilter extends FilterEntity
{
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Activity;
    /**
     * The DefaultTemplateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultTemplateId;
    /**
     * The GradeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ShowAlsoSubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowAlsoSubordinates;
    /**
     * The VisitTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitTypeId;
    /**
     * Constructor method for BizResource.VisitPlanFilter
     * @uses BizResource_VisitPlanFilter::setActivity()
     * @uses BizResource_VisitPlanFilter::setDefaultTemplateId()
     * @uses BizResource_VisitPlanFilter::setGradeId()
     * @uses BizResource_VisitPlanFilter::setName()
     * @uses BizResource_VisitPlanFilter::setShowAlsoSubordinates()
     * @uses BizResource_VisitPlanFilter::setVisitTypeId()
     * @param string $activity
     * @param string $defaultTemplateId
     * @param string $gradeId
     * @param string $name
     * @param bool $showAlsoSubordinates
     * @param string $visitTypeId
     */
    public function __construct($activity = null, $defaultTemplateId = null, $gradeId = null, $name = null, $showAlsoSubordinates = null, $visitTypeId = null)
    {
        $this
            ->setActivity($activity)
            ->setDefaultTemplateId($defaultTemplateId)
            ->setGradeId($gradeId)
            ->setName($name)
            ->setShowAlsoSubordinates($showAlsoSubordinates)
            ->setVisitTypeId($visitTypeId);
    }
    /**
     * Get Activity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivity()
    {
        return isset($this->Activity) ? $this->Activity : null;
    }
    /**
     * Set Activity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activity
     * @return \patest\StructType\BizResource_VisitPlanFilter
     */
    public function setActivity($activity = null)
    {
        // validation for constraint: string
        if (!is_null($activity) && !is_string($activity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activity, true), gettype($activity)), __LINE__);
        }
        if (is_null($activity) || (is_array($activity) && empty($activity))) {
            unset($this->Activity);
        } else {
            $this->Activity = $activity;
        }
        return $this;
    }
    /**
     * Get DefaultTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultTemplateId()
    {
        return isset($this->DefaultTemplateId) ? $this->DefaultTemplateId : null;
    }
    /**
     * Set DefaultTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultTemplateId
     * @return \patest\StructType\BizResource_VisitPlanFilter
     */
    public function setDefaultTemplateId($defaultTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultTemplateId) && !is_string($defaultTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultTemplateId, true), gettype($defaultTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultTemplateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultTemplateId, true)), __LINE__);
        }
        if (is_null($defaultTemplateId) || (is_array($defaultTemplateId) && empty($defaultTemplateId))) {
            unset($this->DefaultTemplateId);
        } else {
            $this->DefaultTemplateId = $defaultTemplateId;
        }
        return $this;
    }
    /**
     * Get GradeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGradeId()
    {
        return isset($this->GradeId) ? $this->GradeId : null;
    }
    /**
     * Set GradeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gradeId
     * @return \patest\StructType\BizResource_VisitPlanFilter
     */
    public function setGradeId($gradeId = null)
    {
        // validation for constraint: string
        if (!is_null($gradeId) && !is_string($gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gradeId, true), gettype($gradeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($gradeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($gradeId, true)), __LINE__);
        }
        if (is_null($gradeId) || (is_array($gradeId) && empty($gradeId))) {
            unset($this->GradeId);
        } else {
            $this->GradeId = $gradeId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\BizResource_VisitPlanFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ShowAlsoSubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowAlsoSubordinates()
    {
        return isset($this->ShowAlsoSubordinates) ? $this->ShowAlsoSubordinates : null;
    }
    /**
     * Set ShowAlsoSubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showAlsoSubordinates
     * @return \patest\StructType\BizResource_VisitPlanFilter
     */
    public function setShowAlsoSubordinates($showAlsoSubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAlsoSubordinates) && !is_bool($showAlsoSubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAlsoSubordinates, true), gettype($showAlsoSubordinates)), __LINE__);
        }
        if (is_null($showAlsoSubordinates) || (is_array($showAlsoSubordinates) && empty($showAlsoSubordinates))) {
            unset($this->ShowAlsoSubordinates);
        } else {
            $this->ShowAlsoSubordinates = $showAlsoSubordinates;
        }
        return $this;
    }
    /**
     * Get VisitTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitTypeId()
    {
        return isset($this->VisitTypeId) ? $this->VisitTypeId : null;
    }
    /**
     * Set VisitTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitTypeId
     * @return \patest\StructType\BizResource_VisitPlanFilter
     */
    public function setVisitTypeId($visitTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($visitTypeId) && !is_string($visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitTypeId, true), gettype($visitTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitTypeId, true)), __LINE__);
        }
        if (is_null($visitTypeId) || (is_array($visitTypeId) && empty($visitTypeId))) {
            unset($this->VisitTypeId);
        } else {
            $this->VisitTypeId = $visitTypeId;
        }
        return $this;
    }
}
