<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.UIBillingItem StructType
 * @subpackage Structs
 */
class BizResource_UIBillingItem extends AnyEntity
{
    /**
     * The BillFor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillFor;
    /**
     * The BillingItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillingItemIds;
    /**
     * The IsSelected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSelected;
    /**
     * The OrderItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderItemId;
    /**
     * The OrderPartId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderPartId;
    /**
     * The StatusIcon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusIcon;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalAmount;
    /**
     * The VisitTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitTitle;
    /**
     * Constructor method for BizResource.UIBillingItem
     * @uses BizResource_UIBillingItem::setBillFor()
     * @uses BizResource_UIBillingItem::setBillingItemIds()
     * @uses BizResource_UIBillingItem::setIsSelected()
     * @uses BizResource_UIBillingItem::setOrderItemId()
     * @uses BizResource_UIBillingItem::setOrderPartId()
     * @uses BizResource_UIBillingItem::setStatusIcon()
     * @uses BizResource_UIBillingItem::setTotalAmount()
     * @uses BizResource_UIBillingItem::setVisitTitle()
     * @param string $billFor
     * @param string $billingItemIds
     * @param bool $isSelected
     * @param string $orderItemId
     * @param string $orderPartId
     * @param string $statusIcon
     * @param float $totalAmount
     * @param string $visitTitle
     */
    public function __construct($billFor = null, $billingItemIds = null, $isSelected = null, $orderItemId = null, $orderPartId = null, $statusIcon = null, $totalAmount = null, $visitTitle = null)
    {
        $this
            ->setBillFor($billFor)
            ->setBillingItemIds($billingItemIds)
            ->setIsSelected($isSelected)
            ->setOrderItemId($orderItemId)
            ->setOrderPartId($orderPartId)
            ->setStatusIcon($statusIcon)
            ->setTotalAmount($totalAmount)
            ->setVisitTitle($visitTitle);
    }
    /**
     * Get BillFor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillFor()
    {
        return isset($this->BillFor) ? $this->BillFor : null;
    }
    /**
     * Set BillFor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billFor
     * @return \patest\StructType\BizResource_UIBillingItem
     */
    public function setBillFor($billFor = null)
    {
        // validation for constraint: string
        if (!is_null($billFor) && !is_string($billFor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billFor, true), gettype($billFor)), __LINE__);
        }
        if (is_null($billFor) || (is_array($billFor) && empty($billFor))) {
            unset($this->BillFor);
        } else {
            $this->BillFor = $billFor;
        }
        return $this;
    }
    /**
     * Get BillingItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillingItemIds()
    {
        return isset($this->BillingItemIds) ? $this->BillingItemIds : null;
    }
    /**
     * Set BillingItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billingItemIds
     * @return \patest\StructType\BizResource_UIBillingItem
     */
    public function setBillingItemIds($billingItemIds = null)
    {
        // validation for constraint: string
        if (!is_null($billingItemIds) && !is_string($billingItemIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingItemIds, true), gettype($billingItemIds)), __LINE__);
        }
        if (is_null($billingItemIds) || (is_array($billingItemIds) && empty($billingItemIds))) {
            unset($this->BillingItemIds);
        } else {
            $this->BillingItemIds = $billingItemIds;
        }
        return $this;
    }
    /**
     * Get IsSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSelected()
    {
        return isset($this->IsSelected) ? $this->IsSelected : null;
    }
    /**
     * Set IsSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSelected
     * @return \patest\StructType\BizResource_UIBillingItem
     */
    public function setIsSelected($isSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelected) && !is_bool($isSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelected, true), gettype($isSelected)), __LINE__);
        }
        if (is_null($isSelected) || (is_array($isSelected) && empty($isSelected))) {
            unset($this->IsSelected);
        } else {
            $this->IsSelected = $isSelected;
        }
        return $this;
    }
    /**
     * Get OrderItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderItemId()
    {
        return isset($this->OrderItemId) ? $this->OrderItemId : null;
    }
    /**
     * Set OrderItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderItemId
     * @return \patest\StructType\BizResource_UIBillingItem
     */
    public function setOrderItemId($orderItemId = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemId) && !is_string($orderItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemId, true), gettype($orderItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderItemId, true)), __LINE__);
        }
        if (is_null($orderItemId) || (is_array($orderItemId) && empty($orderItemId))) {
            unset($this->OrderItemId);
        } else {
            $this->OrderItemId = $orderItemId;
        }
        return $this;
    }
    /**
     * Get OrderPartId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderPartId()
    {
        return isset($this->OrderPartId) ? $this->OrderPartId : null;
    }
    /**
     * Set OrderPartId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderPartId
     * @return \patest\StructType\BizResource_UIBillingItem
     */
    public function setOrderPartId($orderPartId = null)
    {
        // validation for constraint: string
        if (!is_null($orderPartId) && !is_string($orderPartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderPartId, true), gettype($orderPartId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderPartId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderPartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderPartId, true)), __LINE__);
        }
        if (is_null($orderPartId) || (is_array($orderPartId) && empty($orderPartId))) {
            unset($this->OrderPartId);
        } else {
            $this->OrderPartId = $orderPartId;
        }
        return $this;
    }
    /**
     * Get StatusIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusIcon()
    {
        return isset($this->StatusIcon) ? $this->StatusIcon : null;
    }
    /**
     * Set StatusIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusIcon
     * @return \patest\StructType\BizResource_UIBillingItem
     */
    public function setStatusIcon($statusIcon = null)
    {
        // validation for constraint: string
        if (!is_null($statusIcon) && !is_string($statusIcon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusIcon, true), gettype($statusIcon)), __LINE__);
        }
        if (is_null($statusIcon) || (is_array($statusIcon) && empty($statusIcon))) {
            unset($this->StatusIcon);
        } else {
            $this->StatusIcon = $statusIcon;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalAmount
     * @return \patest\StructType\BizResource_UIBillingItem
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get VisitTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitTitle()
    {
        return isset($this->VisitTitle) ? $this->VisitTitle : null;
    }
    /**
     * Set VisitTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitTitle
     * @return \patest\StructType\BizResource_UIBillingItem
     */
    public function setVisitTitle($visitTitle = null)
    {
        // validation for constraint: string
        if (!is_null($visitTitle) && !is_string($visitTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitTitle, true), gettype($visitTitle)), __LINE__);
        }
        if (is_null($visitTitle) || (is_array($visitTitle) && empty($visitTitle))) {
            unset($this->VisitTitle);
        } else {
            $this->VisitTitle = $visitTitle;
        }
        return $this;
    }
}
