<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.TimeSlot StructType
 * @subpackage Structs
 */
class BizResource_TimeSlot extends BizResource_PersistableEntityBase
{
    /**
     * The CalendarId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CalendarId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The ExceptionTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExceptionTypeId;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The FromTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromTime;
    /**
     * The FromTimeExtra1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromTimeExtra1;
    /**
     * The FromTimeExtra2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromTimeExtra2;
    /**
     * The IsAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailable;
    /**
     * The IsException
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsException;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * The UntilTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilTime;
    /**
     * The UntilTimeExtra1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilTimeExtra1;
    /**
     * The UntilTimeExtra2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilTimeExtra2;
    /**
     * The WeekDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $WeekDay;
    /**
     * Constructor method for BizResource.TimeSlot
     * @uses BizResource_TimeSlot::setCalendarId()
     * @uses BizResource_TimeSlot::setDescription()
     * @uses BizResource_TimeSlot::setExceptionTypeId()
     * @uses BizResource_TimeSlot::setFromDate()
     * @uses BizResource_TimeSlot::setFromTime()
     * @uses BizResource_TimeSlot::setFromTimeExtra1()
     * @uses BizResource_TimeSlot::setFromTimeExtra2()
     * @uses BizResource_TimeSlot::setIsAvailable()
     * @uses BizResource_TimeSlot::setIsException()
     * @uses BizResource_TimeSlot::setUntilDate()
     * @uses BizResource_TimeSlot::setUntilTime()
     * @uses BizResource_TimeSlot::setUntilTimeExtra1()
     * @uses BizResource_TimeSlot::setUntilTimeExtra2()
     * @uses BizResource_TimeSlot::setWeekDay()
     * @param string $calendarId
     * @param \patest\StructType\GlobalString $description
     * @param string $exceptionTypeId
     * @param string $fromDate
     * @param string $fromTime
     * @param string $fromTimeExtra1
     * @param string $fromTimeExtra2
     * @param bool $isAvailable
     * @param bool $isException
     * @param string $untilDate
     * @param string $untilTime
     * @param string $untilTimeExtra1
     * @param string $untilTimeExtra2
     * @param string[] $weekDay
     */
    public function __construct($calendarId = null, \patest\StructType\GlobalString $description = null, $exceptionTypeId = null, $fromDate = null, $fromTime = null, $fromTimeExtra1 = null, $fromTimeExtra2 = null, $isAvailable = null, $isException = null, $untilDate = null, $untilTime = null, $untilTimeExtra1 = null, $untilTimeExtra2 = null, array $weekDay = array())
    {
        $this
            ->setCalendarId($calendarId)
            ->setDescription($description)
            ->setExceptionTypeId($exceptionTypeId)
            ->setFromDate($fromDate)
            ->setFromTime($fromTime)
            ->setFromTimeExtra1($fromTimeExtra1)
            ->setFromTimeExtra2($fromTimeExtra2)
            ->setIsAvailable($isAvailable)
            ->setIsException($isException)
            ->setUntilDate($untilDate)
            ->setUntilTime($untilTime)
            ->setUntilTimeExtra1($untilTimeExtra1)
            ->setUntilTimeExtra2($untilTimeExtra2)
            ->setWeekDay($weekDay);
    }
    /**
     * Get CalendarId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalendarId()
    {
        return isset($this->CalendarId) ? $this->CalendarId : null;
    }
    /**
     * Set CalendarId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calendarId
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setCalendarId($calendarId = null)
    {
        // validation for constraint: string
        if (!is_null($calendarId) && !is_string($calendarId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calendarId, true), gettype($calendarId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($calendarId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $calendarId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($calendarId, true)), __LINE__);
        }
        if (is_null($calendarId) || (is_array($calendarId) && empty($calendarId))) {
            unset($this->CalendarId);
        } else {
            $this->CalendarId = $calendarId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExceptionTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionTypeId()
    {
        return isset($this->ExceptionTypeId) ? $this->ExceptionTypeId : null;
    }
    /**
     * Set ExceptionTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionTypeId
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setExceptionTypeId($exceptionTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionTypeId) && !is_string($exceptionTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionTypeId, true), gettype($exceptionTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($exceptionTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $exceptionTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($exceptionTypeId, true)), __LINE__);
        }
        if (is_null($exceptionTypeId) || (is_array($exceptionTypeId) && empty($exceptionTypeId))) {
            unset($this->ExceptionTypeId);
        } else {
            $this->ExceptionTypeId = $exceptionTypeId;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get FromTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromTime()
    {
        return isset($this->FromTime) ? $this->FromTime : null;
    }
    /**
     * Set FromTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromTime
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setFromTime($fromTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromTime) && !is_string($fromTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromTime, true), gettype($fromTime)), __LINE__);
        }
        if (is_null($fromTime) || (is_array($fromTime) && empty($fromTime))) {
            unset($this->FromTime);
        } else {
            $this->FromTime = $fromTime;
        }
        return $this;
    }
    /**
     * Get FromTimeExtra1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromTimeExtra1()
    {
        return isset($this->FromTimeExtra1) ? $this->FromTimeExtra1 : null;
    }
    /**
     * Set FromTimeExtra1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromTimeExtra1
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setFromTimeExtra1($fromTimeExtra1 = null)
    {
        // validation for constraint: string
        if (!is_null($fromTimeExtra1) && !is_string($fromTimeExtra1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromTimeExtra1, true), gettype($fromTimeExtra1)), __LINE__);
        }
        if (is_null($fromTimeExtra1) || (is_array($fromTimeExtra1) && empty($fromTimeExtra1))) {
            unset($this->FromTimeExtra1);
        } else {
            $this->FromTimeExtra1 = $fromTimeExtra1;
        }
        return $this;
    }
    /**
     * Get FromTimeExtra2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromTimeExtra2()
    {
        return isset($this->FromTimeExtra2) ? $this->FromTimeExtra2 : null;
    }
    /**
     * Set FromTimeExtra2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromTimeExtra2
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setFromTimeExtra2($fromTimeExtra2 = null)
    {
        // validation for constraint: string
        if (!is_null($fromTimeExtra2) && !is_string($fromTimeExtra2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromTimeExtra2, true), gettype($fromTimeExtra2)), __LINE__);
        }
        if (is_null($fromTimeExtra2) || (is_array($fromTimeExtra2) && empty($fromTimeExtra2))) {
            unset($this->FromTimeExtra2);
        } else {
            $this->FromTimeExtra2 = $fromTimeExtra2;
        }
        return $this;
    }
    /**
     * Get IsAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailable()
    {
        return isset($this->IsAvailable) ? $this->IsAvailable : null;
    }
    /**
     * Set IsAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailable
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setIsAvailable($isAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailable) && !is_bool($isAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailable, true), gettype($isAvailable)), __LINE__);
        }
        if (is_null($isAvailable) || (is_array($isAvailable) && empty($isAvailable))) {
            unset($this->IsAvailable);
        } else {
            $this->IsAvailable = $isAvailable;
        }
        return $this;
    }
    /**
     * Get IsException value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsException()
    {
        return isset($this->IsException) ? $this->IsException : null;
    }
    /**
     * Set IsException value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isException
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setIsException($isException = null)
    {
        // validation for constraint: boolean
        if (!is_null($isException) && !is_bool($isException)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isException, true), gettype($isException)), __LINE__);
        }
        if (is_null($isException) || (is_array($isException) && empty($isException))) {
            unset($this->IsException);
        } else {
            $this->IsException = $isException;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
    /**
     * Get UntilTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilTime()
    {
        return isset($this->UntilTime) ? $this->UntilTime : null;
    }
    /**
     * Set UntilTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilTime
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setUntilTime($untilTime = null)
    {
        // validation for constraint: string
        if (!is_null($untilTime) && !is_string($untilTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilTime, true), gettype($untilTime)), __LINE__);
        }
        if (is_null($untilTime) || (is_array($untilTime) && empty($untilTime))) {
            unset($this->UntilTime);
        } else {
            $this->UntilTime = $untilTime;
        }
        return $this;
    }
    /**
     * Get UntilTimeExtra1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilTimeExtra1()
    {
        return isset($this->UntilTimeExtra1) ? $this->UntilTimeExtra1 : null;
    }
    /**
     * Set UntilTimeExtra1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilTimeExtra1
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setUntilTimeExtra1($untilTimeExtra1 = null)
    {
        // validation for constraint: string
        if (!is_null($untilTimeExtra1) && !is_string($untilTimeExtra1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilTimeExtra1, true), gettype($untilTimeExtra1)), __LINE__);
        }
        if (is_null($untilTimeExtra1) || (is_array($untilTimeExtra1) && empty($untilTimeExtra1))) {
            unset($this->UntilTimeExtra1);
        } else {
            $this->UntilTimeExtra1 = $untilTimeExtra1;
        }
        return $this;
    }
    /**
     * Get UntilTimeExtra2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilTimeExtra2()
    {
        return isset($this->UntilTimeExtra2) ? $this->UntilTimeExtra2 : null;
    }
    /**
     * Set UntilTimeExtra2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilTimeExtra2
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setUntilTimeExtra2($untilTimeExtra2 = null)
    {
        // validation for constraint: string
        if (!is_null($untilTimeExtra2) && !is_string($untilTimeExtra2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilTimeExtra2, true), gettype($untilTimeExtra2)), __LINE__);
        }
        if (is_null($untilTimeExtra2) || (is_array($untilTimeExtra2) && empty($untilTimeExtra2))) {
            unset($this->UntilTimeExtra2);
        } else {
            $this->UntilTimeExtra2 = $untilTimeExtra2;
        }
        return $this;
    }
    /**
     * Get WeekDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getWeekDay()
    {
        return isset($this->WeekDay) ? $this->WeekDay : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWeekDay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeekDay method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeekDayForArrayConstraintsFromSetWeekDay(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizResource_TimeSlotWeekDayItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\DaysOfWeek::valueIsValid($bizResource_TimeSlotWeekDayItem)) {
                $invalidValues[] = is_object($bizResource_TimeSlotWeekDayItem) ? get_class($bizResource_TimeSlotWeekDayItem) : sprintf('%s(%s)', gettype($bizResource_TimeSlotWeekDayItem), var_export($bizResource_TimeSlotWeekDayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DaysOfWeek', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\DaysOfWeek::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WeekDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DaysOfWeek::valueIsValid()
     * @uses \patest\EnumType\DaysOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $weekDay
     * @return \patest\StructType\BizResource_TimeSlot
     */
    public function setWeekDay(array $weekDay = array())
    {
        // validation for constraint: list
        if ('' !== ($weekDayArrayErrorMessage = self::validateWeekDayForArrayConstraintsFromSetWeekDay($weekDay))) {
            throw new \InvalidArgumentException($weekDayArrayErrorMessage, __LINE__);
        }
        if (is_null($weekDay) || (is_array($weekDay) && empty($weekDay))) {
            unset($this->WeekDay);
        } else {
            $this->WeekDay = is_array($weekDay) ? implode(' ', $weekDay) : null;
        }
        return $this;
    }
}
