<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.ReservationFilter StructType
 * @subpackage Structs
 */
class BizResource_ReservationFilter extends FilterEntity
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CategoryIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CategoryIds
     */
    public $CategoryIds;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OwnerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerType;
    /**
     * The SkillIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SkillIds
     */
    public $SkillIds;
    /**
     * Constructor method for BizResource.ReservationFilter
     * @uses BizResource_ReservationFilter::setCategoryId()
     * @uses BizResource_ReservationFilter::setCategoryIds()
     * @uses BizResource_ReservationFilter::setName()
     * @uses BizResource_ReservationFilter::setOwnerType()
     * @uses BizResource_ReservationFilter::setSkillIds()
     * @param string $categoryId
     * @param \patest\StructType\CategoryIds $categoryIds
     * @param string $name
     * @param string $ownerType
     * @param \patest\StructType\SkillIds $skillIds
     */
    public function __construct($categoryId = null, \patest\StructType\CategoryIds $categoryIds = null, $name = null, $ownerType = null, \patest\StructType\SkillIds $skillIds = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setCategoryIds($categoryIds)
            ->setName($name)
            ->setOwnerType($ownerType)
            ->setSkillIds($skillIds);
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\BizResource_ReservationFilter
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CategoryIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CategoryIds|null
     */
    public function getCategoryIds()
    {
        return isset($this->CategoryIds) ? $this->CategoryIds : null;
    }
    /**
     * Set CategoryIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CategoryIds $categoryIds
     * @return \patest\StructType\BizResource_ReservationFilter
     */
    public function setCategoryIds(\patest\StructType\CategoryIds $categoryIds = null)
    {
        if (is_null($categoryIds) || (is_array($categoryIds) && empty($categoryIds))) {
            unset($this->CategoryIds);
        } else {
            $this->CategoryIds = $categoryIds;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\BizResource_ReservationFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OwnerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerType()
    {
        return isset($this->OwnerType) ? $this->OwnerType : null;
    }
    /**
     * Set OwnerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReservationOwnerType::valueIsValid()
     * @uses \patest\EnumType\ReservationOwnerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ownerType
     * @return \patest\StructType\BizResource_ReservationFilter
     */
    public function setOwnerType($ownerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReservationOwnerType::valueIsValid($ownerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReservationOwnerType', is_array($ownerType) ? implode(', ', $ownerType) : var_export($ownerType, true), implode(', ', \patest\EnumType\ReservationOwnerType::getValidValues())), __LINE__);
        }
        if (is_null($ownerType) || (is_array($ownerType) && empty($ownerType))) {
            unset($this->OwnerType);
        } else {
            $this->OwnerType = $ownerType;
        }
        return $this;
    }
    /**
     * Get SkillIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SkillIds|null
     */
    public function getSkillIds()
    {
        return isset($this->SkillIds) ? $this->SkillIds : null;
    }
    /**
     * Set SkillIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SkillIds $skillIds
     * @return \patest\StructType\BizResource_ReservationFilter
     */
    public function setSkillIds(\patest\StructType\SkillIds $skillIds = null)
    {
        if (is_null($skillIds) || (is_array($skillIds) && empty($skillIds))) {
            unset($this->SkillIds);
        } else {
            $this->SkillIds = $skillIds;
        }
        return $this;
    }
}
