<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.OrderFilter StructType
 * @subpackage Structs
 */
class BizResource_OrderFilter extends FilterEntity
{
    /**
     * The CreatedByUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedByUserName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The GroupNameOrGrade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupNameOrGrade;
    /**
     * The GroupsNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupsNumber;
    /**
     * The HomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mobile;
    /**
     * The OrderContactName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderContactName;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OrderNumber;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderType;
    /**
     * The PayerCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayerCrmId;
    /**
     * The PayerEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayerEmail;
    /**
     * The PayerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayerName;
    /**
     * The PayerPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayerPhone;
    /**
     * The PayerVatRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayerVatRegistrationNumber;
    /**
     * The SchoolOrGroupOrganizer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolOrGroupOrganizer;
    /**
     * The ServiceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceId;
    /**
     * The ShowAlsoSubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowAlsoSubordinates;
    /**
     * The SkillId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SkillId;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * The VisitDateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VisitDateType;
    /**
     * The VisitPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitPlanId;
    /**
     * The VisitTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitTypeId;
    /**
     * Constructor method for BizResource.OrderFilter
     * @uses BizResource_OrderFilter::setCreatedByUserName()
     * @uses BizResource_OrderFilter::setEmail()
     * @uses BizResource_OrderFilter::setFax()
     * @uses BizResource_OrderFilter::setFromDate()
     * @uses BizResource_OrderFilter::setGroupNameOrGrade()
     * @uses BizResource_OrderFilter::setGroupsNumber()
     * @uses BizResource_OrderFilter::setHomePhone()
     * @uses BizResource_OrderFilter::setMobile()
     * @uses BizResource_OrderFilter::setOrderContactName()
     * @uses BizResource_OrderFilter::setOrderNumber()
     * @uses BizResource_OrderFilter::setOrderType()
     * @uses BizResource_OrderFilter::setPayerCrmId()
     * @uses BizResource_OrderFilter::setPayerEmail()
     * @uses BizResource_OrderFilter::setPayerName()
     * @uses BizResource_OrderFilter::setPayerPhone()
     * @uses BizResource_OrderFilter::setPayerVatRegistrationNumber()
     * @uses BizResource_OrderFilter::setSchoolOrGroupOrganizer()
     * @uses BizResource_OrderFilter::setServiceId()
     * @uses BizResource_OrderFilter::setShowAlsoSubordinates()
     * @uses BizResource_OrderFilter::setSkillId()
     * @uses BizResource_OrderFilter::setUntilDate()
     * @uses BizResource_OrderFilter::setVisitDateType()
     * @uses BizResource_OrderFilter::setVisitPlanId()
     * @uses BizResource_OrderFilter::setVisitTypeId()
     * @param string $createdByUserName
     * @param string $email
     * @param string $fax
     * @param string $fromDate
     * @param string $groupNameOrGrade
     * @param int $groupsNumber
     * @param string $homePhone
     * @param string $mobile
     * @param string $orderContactName
     * @param int $orderNumber
     * @param string $orderType
     * @param string $payerCrmId
     * @param string $payerEmail
     * @param string $payerName
     * @param string $payerPhone
     * @param string $payerVatRegistrationNumber
     * @param string $schoolOrGroupOrganizer
     * @param string $serviceId
     * @param bool $showAlsoSubordinates
     * @param string $skillId
     * @param string $untilDate
     * @param int $visitDateType
     * @param string $visitPlanId
     * @param string $visitTypeId
     */
    public function __construct($createdByUserName = null, $email = null, $fax = null, $fromDate = null, $groupNameOrGrade = null, $groupsNumber = null, $homePhone = null, $mobile = null, $orderContactName = null, $orderNumber = null, $orderType = null, $payerCrmId = null, $payerEmail = null, $payerName = null, $payerPhone = null, $payerVatRegistrationNumber = null, $schoolOrGroupOrganizer = null, $serviceId = null, $showAlsoSubordinates = null, $skillId = null, $untilDate = null, $visitDateType = null, $visitPlanId = null, $visitTypeId = null)
    {
        $this
            ->setCreatedByUserName($createdByUserName)
            ->setEmail($email)
            ->setFax($fax)
            ->setFromDate($fromDate)
            ->setGroupNameOrGrade($groupNameOrGrade)
            ->setGroupsNumber($groupsNumber)
            ->setHomePhone($homePhone)
            ->setMobile($mobile)
            ->setOrderContactName($orderContactName)
            ->setOrderNumber($orderNumber)
            ->setOrderType($orderType)
            ->setPayerCrmId($payerCrmId)
            ->setPayerEmail($payerEmail)
            ->setPayerName($payerName)
            ->setPayerPhone($payerPhone)
            ->setPayerVatRegistrationNumber($payerVatRegistrationNumber)
            ->setSchoolOrGroupOrganizer($schoolOrGroupOrganizer)
            ->setServiceId($serviceId)
            ->setShowAlsoSubordinates($showAlsoSubordinates)
            ->setSkillId($skillId)
            ->setUntilDate($untilDate)
            ->setVisitDateType($visitDateType)
            ->setVisitPlanId($visitPlanId)
            ->setVisitTypeId($visitTypeId);
    }
    /**
     * Get CreatedByUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return isset($this->CreatedByUserName) ? $this->CreatedByUserName : null;
    }
    /**
     * Set CreatedByUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdByUserName
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdByUserName, true), gettype($createdByUserName)), __LINE__);
        }
        if (is_null($createdByUserName) || (is_array($createdByUserName) && empty($createdByUserName))) {
            unset($this->CreatedByUserName);
        } else {
            $this->CreatedByUserName = $createdByUserName;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get GroupNameOrGrade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupNameOrGrade()
    {
        return isset($this->GroupNameOrGrade) ? $this->GroupNameOrGrade : null;
    }
    /**
     * Set GroupNameOrGrade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupNameOrGrade
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setGroupNameOrGrade($groupNameOrGrade = null)
    {
        // validation for constraint: string
        if (!is_null($groupNameOrGrade) && !is_string($groupNameOrGrade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupNameOrGrade, true), gettype($groupNameOrGrade)), __LINE__);
        }
        if (is_null($groupNameOrGrade) || (is_array($groupNameOrGrade) && empty($groupNameOrGrade))) {
            unset($this->GroupNameOrGrade);
        } else {
            $this->GroupNameOrGrade = $groupNameOrGrade;
        }
        return $this;
    }
    /**
     * Get GroupsNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupsNumber()
    {
        return isset($this->GroupsNumber) ? $this->GroupsNumber : null;
    }
    /**
     * Set GroupsNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupsNumber
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setGroupsNumber($groupsNumber = null)
    {
        // validation for constraint: int
        if (!is_null($groupsNumber) && !(is_int($groupsNumber) || ctype_digit($groupsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupsNumber, true), gettype($groupsNumber)), __LINE__);
        }
        if (is_null($groupsNumber) || (is_array($groupsNumber) && empty($groupsNumber))) {
            unset($this->GroupsNumber);
        } else {
            $this->GroupsNumber = $groupsNumber;
        }
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get Mobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobile()
    {
        return isset($this->Mobile) ? $this->Mobile : null;
    }
    /**
     * Set Mobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobile
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        if (is_null($mobile) || (is_array($mobile) && empty($mobile))) {
            unset($this->Mobile);
        } else {
            $this->Mobile = $mobile;
        }
        return $this;
    }
    /**
     * Get OrderContactName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderContactName()
    {
        return isset($this->OrderContactName) ? $this->OrderContactName : null;
    }
    /**
     * Set OrderContactName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderContactName
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setOrderContactName($orderContactName = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactName) && !is_string($orderContactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactName, true), gettype($orderContactName)), __LINE__);
        }
        if (is_null($orderContactName) || (is_array($orderContactName) && empty($orderContactName))) {
            unset($this->OrderContactName);
        } else {
            $this->OrderContactName = $orderContactName;
        }
        return $this;
    }
    /**
     * Get OrderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderNumber()
    {
        return isset($this->OrderNumber) ? $this->OrderNumber : null;
    }
    /**
     * Set OrderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderNumber
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderNumber) && !(is_int($orderNumber) || ctype_digit($orderNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->OrderNumber);
        } else {
            $this->OrderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OrderType::valueIsValid()
     * @uses \patest\EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OrderType', is_array($orderType) ? implode(', ', $orderType) : var_export($orderType, true), implode(', ', \patest\EnumType\OrderType::getValidValues())), __LINE__);
        }
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get PayerCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerCrmId()
    {
        return isset($this->PayerCrmId) ? $this->PayerCrmId : null;
    }
    /**
     * Set PayerCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerCrmId
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setPayerCrmId($payerCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($payerCrmId) && !is_string($payerCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerCrmId, true), gettype($payerCrmId)), __LINE__);
        }
        if (is_null($payerCrmId) || (is_array($payerCrmId) && empty($payerCrmId))) {
            unset($this->PayerCrmId);
        } else {
            $this->PayerCrmId = $payerCrmId;
        }
        return $this;
    }
    /**
     * Get PayerEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerEmail()
    {
        return isset($this->PayerEmail) ? $this->PayerEmail : null;
    }
    /**
     * Set PayerEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerEmail
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setPayerEmail($payerEmail = null)
    {
        // validation for constraint: string
        if (!is_null($payerEmail) && !is_string($payerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerEmail, true), gettype($payerEmail)), __LINE__);
        }
        if (is_null($payerEmail) || (is_array($payerEmail) && empty($payerEmail))) {
            unset($this->PayerEmail);
        } else {
            $this->PayerEmail = $payerEmail;
        }
        return $this;
    }
    /**
     * Get PayerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerName()
    {
        return isset($this->PayerName) ? $this->PayerName : null;
    }
    /**
     * Set PayerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerName
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        if (is_null($payerName) || (is_array($payerName) && empty($payerName))) {
            unset($this->PayerName);
        } else {
            $this->PayerName = $payerName;
        }
        return $this;
    }
    /**
     * Get PayerPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerPhone()
    {
        return isset($this->PayerPhone) ? $this->PayerPhone : null;
    }
    /**
     * Set PayerPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerPhone
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setPayerPhone($payerPhone = null)
    {
        // validation for constraint: string
        if (!is_null($payerPhone) && !is_string($payerPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerPhone, true), gettype($payerPhone)), __LINE__);
        }
        if (is_null($payerPhone) || (is_array($payerPhone) && empty($payerPhone))) {
            unset($this->PayerPhone);
        } else {
            $this->PayerPhone = $payerPhone;
        }
        return $this;
    }
    /**
     * Get PayerVatRegistrationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerVatRegistrationNumber()
    {
        return isset($this->PayerVatRegistrationNumber) ? $this->PayerVatRegistrationNumber : null;
    }
    /**
     * Set PayerVatRegistrationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerVatRegistrationNumber
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setPayerVatRegistrationNumber($payerVatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($payerVatRegistrationNumber) && !is_string($payerVatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerVatRegistrationNumber, true), gettype($payerVatRegistrationNumber)), __LINE__);
        }
        if (is_null($payerVatRegistrationNumber) || (is_array($payerVatRegistrationNumber) && empty($payerVatRegistrationNumber))) {
            unset($this->PayerVatRegistrationNumber);
        } else {
            $this->PayerVatRegistrationNumber = $payerVatRegistrationNumber;
        }
        return $this;
    }
    /**
     * Get SchoolOrGroupOrganizer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolOrGroupOrganizer()
    {
        return isset($this->SchoolOrGroupOrganizer) ? $this->SchoolOrGroupOrganizer : null;
    }
    /**
     * Set SchoolOrGroupOrganizer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolOrGroupOrganizer
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setSchoolOrGroupOrganizer($schoolOrGroupOrganizer = null)
    {
        // validation for constraint: string
        if (!is_null($schoolOrGroupOrganizer) && !is_string($schoolOrGroupOrganizer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schoolOrGroupOrganizer, true), gettype($schoolOrGroupOrganizer)), __LINE__);
        }
        if (is_null($schoolOrGroupOrganizer) || (is_array($schoolOrGroupOrganizer) && empty($schoolOrGroupOrganizer))) {
            unset($this->SchoolOrGroupOrganizer);
        } else {
            $this->SchoolOrGroupOrganizer = $schoolOrGroupOrganizer;
        }
        return $this;
    }
    /**
     * Get ServiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceId()
    {
        return isset($this->ServiceId) ? $this->ServiceId : null;
    }
    /**
     * Set ServiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceId
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceId) && !is_string($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceId, true)), __LINE__);
        }
        if (is_null($serviceId) || (is_array($serviceId) && empty($serviceId))) {
            unset($this->ServiceId);
        } else {
            $this->ServiceId = $serviceId;
        }
        return $this;
    }
    /**
     * Get ShowAlsoSubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowAlsoSubordinates()
    {
        return isset($this->ShowAlsoSubordinates) ? $this->ShowAlsoSubordinates : null;
    }
    /**
     * Set ShowAlsoSubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showAlsoSubordinates
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setShowAlsoSubordinates($showAlsoSubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAlsoSubordinates) && !is_bool($showAlsoSubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAlsoSubordinates, true), gettype($showAlsoSubordinates)), __LINE__);
        }
        if (is_null($showAlsoSubordinates) || (is_array($showAlsoSubordinates) && empty($showAlsoSubordinates))) {
            unset($this->ShowAlsoSubordinates);
        } else {
            $this->ShowAlsoSubordinates = $showAlsoSubordinates;
        }
        return $this;
    }
    /**
     * Get SkillId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSkillId()
    {
        return isset($this->SkillId) ? $this->SkillId : null;
    }
    /**
     * Set SkillId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $skillId
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setSkillId($skillId = null)
    {
        // validation for constraint: string
        if (!is_null($skillId) && !is_string($skillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($skillId, true), gettype($skillId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($skillId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $skillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($skillId, true)), __LINE__);
        }
        if (is_null($skillId) || (is_array($skillId) && empty($skillId))) {
            unset($this->SkillId);
        } else {
            $this->SkillId = $skillId;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
    /**
     * Get VisitDateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVisitDateType()
    {
        return isset($this->VisitDateType) ? $this->VisitDateType : null;
    }
    /**
     * Set VisitDateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $visitDateType
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setVisitDateType($visitDateType = null)
    {
        // validation for constraint: int
        if (!is_null($visitDateType) && !(is_int($visitDateType) || ctype_digit($visitDateType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($visitDateType, true), gettype($visitDateType)), __LINE__);
        }
        if (is_null($visitDateType) || (is_array($visitDateType) && empty($visitDateType))) {
            unset($this->VisitDateType);
        } else {
            $this->VisitDateType = $visitDateType;
        }
        return $this;
    }
    /**
     * Get VisitPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitPlanId()
    {
        return isset($this->VisitPlanId) ? $this->VisitPlanId : null;
    }
    /**
     * Set VisitPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitPlanId
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setVisitPlanId($visitPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($visitPlanId) && !is_string($visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitPlanId, true), gettype($visitPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitPlanId, true)), __LINE__);
        }
        if (is_null($visitPlanId) || (is_array($visitPlanId) && empty($visitPlanId))) {
            unset($this->VisitPlanId);
        } else {
            $this->VisitPlanId = $visitPlanId;
        }
        return $this;
    }
    /**
     * Get VisitTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitTypeId()
    {
        return isset($this->VisitTypeId) ? $this->VisitTypeId : null;
    }
    /**
     * Set VisitTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitTypeId
     * @return \patest\StructType\BizResource_OrderFilter
     */
    public function setVisitTypeId($visitTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($visitTypeId) && !is_string($visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitTypeId, true), gettype($visitTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitTypeId, true)), __LINE__);
        }
        if (is_null($visitTypeId) || (is_array($visitTypeId) && empty($visitTypeId))) {
            unset($this->VisitTypeId);
        } else {
            $this->VisitTypeId = $visitTypeId;
        }
        return $this;
    }
}
