<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.GuidanceForSearch StructType
 * @subpackage Structs
 */
class BizResource_GuidanceForSearch extends BizResource_Guidance
{
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EventName;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OrderId;
    /**
     * The SourceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceId;
    /**
     * The SourceType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceType;
    /**
     * Constructor method for BizResource.GuidanceForSearch
     * @uses BizResource_GuidanceForSearch::setEventName()
     * @uses BizResource_GuidanceForSearch::setOrderId()
     * @uses BizResource_GuidanceForSearch::setSourceId()
     * @uses BizResource_GuidanceForSearch::setSourceType()
     * @param \patest\StructType\GlobalString $eventName
     * @param int $orderId
     * @param string $sourceId
     * @param string $sourceType
     */
    public function __construct(\patest\StructType\GlobalString $eventName = null, $orderId = null, $sourceId = null, $sourceType = null)
    {
        $this
            ->setEventName($eventName)
            ->setOrderId($orderId)
            ->setSourceId($sourceId)
            ->setSourceType($sourceType);
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $eventName
     * @return \patest\StructType\BizResource_GuidanceForSearch
     */
    public function setEventName(\patest\StructType\GlobalString $eventName = null)
    {
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
    /**
     * Get OrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderId()
    {
        return isset($this->OrderId) ? $this->OrderId : null;
    }
    /**
     * Set OrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderId
     * @return \patest\StructType\BizResource_GuidanceForSearch
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->OrderId);
        } else {
            $this->OrderId = $orderId;
        }
        return $this;
    }
    /**
     * Get SourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceId()
    {
        return isset($this->SourceId) ? $this->SourceId : null;
    }
    /**
     * Set SourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceId
     * @return \patest\StructType\BizResource_GuidanceForSearch
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceId, true)), __LINE__);
        }
        if (is_null($sourceId) || (is_array($sourceId) && empty($sourceId))) {
            unset($this->SourceId);
        } else {
            $this->SourceId = $sourceId;
        }
        return $this;
    }
    /**
     * Get SourceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceType()
    {
        return isset($this->SourceType) ? $this->SourceType : null;
    }
    /**
     * Set SourceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestSourceType::valueIsValid()
     * @uses \patest\EnumType\RequestSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceType
     * @return \patest\StructType\BizResource_GuidanceForSearch
     */
    public function setSourceType($sourceType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestSourceType::valueIsValid($sourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestSourceType', is_array($sourceType) ? implode(', ', $sourceType) : var_export($sourceType, true), implode(', ', \patest\EnumType\RequestSourceType::getValidValues())), __LINE__);
        }
        if (is_null($sourceType) || (is_array($sourceType) && empty($sourceType))) {
            unset($this->SourceType);
        } else {
            $this->SourceType = $sourceType;
        }
        return $this;
    }
}
