<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.BizService StructType
 * @subpackage Structs
 */
class BizResource_BizService extends BizResource_PersistableEntityBase
{
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Comment;
    /**
     * The MerchandiseItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_BizServiceMerchandise
     */
    public $MerchandiseItems;
    /**
     * The MerchandiseItemTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseItemTypeId;
    /**
     * The OrderVisitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitId;
    /**
     * The PayerAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayerAccountId;
    /**
     * The PriceToPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PriceToPay;
    /**
     * Constructor method for BizResource.BizService
     * @uses BizResource_BizService::setComment()
     * @uses BizResource_BizService::setMerchandiseItems()
     * @uses BizResource_BizService::setMerchandiseItemTypeId()
     * @uses BizResource_BizService::setOrderVisitId()
     * @uses BizResource_BizService::setPayerAccountId()
     * @uses BizResource_BizService::setPriceToPay()
     * @param \patest\StructType\GlobalString $comment
     * @param \patest\StructType\RecordSetOfBizResource_BizServiceMerchandise $merchandiseItems
     * @param string $merchandiseItemTypeId
     * @param string $orderVisitId
     * @param string $payerAccountId
     * @param float $priceToPay
     */
    public function __construct(\patest\StructType\GlobalString $comment = null, \patest\StructType\RecordSetOfBizResource_BizServiceMerchandise $merchandiseItems = null, $merchandiseItemTypeId = null, $orderVisitId = null, $payerAccountId = null, $priceToPay = null)
    {
        $this
            ->setComment($comment)
            ->setMerchandiseItems($merchandiseItems)
            ->setMerchandiseItemTypeId($merchandiseItemTypeId)
            ->setOrderVisitId($orderVisitId)
            ->setPayerAccountId($payerAccountId)
            ->setPriceToPay($priceToPay);
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $comment
     * @return \patest\StructType\BizResource_BizService
     */
    public function setComment(\patest\StructType\GlobalString $comment = null)
    {
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get MerchandiseItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_BizServiceMerchandise|null
     */
    public function getMerchandiseItems()
    {
        return isset($this->MerchandiseItems) ? $this->MerchandiseItems : null;
    }
    /**
     * Set MerchandiseItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_BizServiceMerchandise $merchandiseItems
     * @return \patest\StructType\BizResource_BizService
     */
    public function setMerchandiseItems(\patest\StructType\RecordSetOfBizResource_BizServiceMerchandise $merchandiseItems = null)
    {
        if (is_null($merchandiseItems) || (is_array($merchandiseItems) && empty($merchandiseItems))) {
            unset($this->MerchandiseItems);
        } else {
            $this->MerchandiseItems = $merchandiseItems;
        }
        return $this;
    }
    /**
     * Get MerchandiseItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseItemTypeId()
    {
        return isset($this->MerchandiseItemTypeId) ? $this->MerchandiseItemTypeId : null;
    }
    /**
     * Set MerchandiseItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseItemTypeId
     * @return \patest\StructType\BizResource_BizService
     */
    public function setMerchandiseItemTypeId($merchandiseItemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseItemTypeId) && !is_string($merchandiseItemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseItemTypeId, true), gettype($merchandiseItemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseItemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseItemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseItemTypeId, true)), __LINE__);
        }
        if (is_null($merchandiseItemTypeId) || (is_array($merchandiseItemTypeId) && empty($merchandiseItemTypeId))) {
            unset($this->MerchandiseItemTypeId);
        } else {
            $this->MerchandiseItemTypeId = $merchandiseItemTypeId;
        }
        return $this;
    }
    /**
     * Get OrderVisitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitId()
    {
        return isset($this->OrderVisitId) ? $this->OrderVisitId : null;
    }
    /**
     * Set OrderVisitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitId
     * @return \patest\StructType\BizResource_BizService
     */
    public function setOrderVisitId($orderVisitId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitId) && !is_string($orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitId, true), gettype($orderVisitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitId, true)), __LINE__);
        }
        if (is_null($orderVisitId) || (is_array($orderVisitId) && empty($orderVisitId))) {
            unset($this->OrderVisitId);
        } else {
            $this->OrderVisitId = $orderVisitId;
        }
        return $this;
    }
    /**
     * Get PayerAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerAccountId()
    {
        return isset($this->PayerAccountId) ? $this->PayerAccountId : null;
    }
    /**
     * Set PayerAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerAccountId
     * @return \patest\StructType\BizResource_BizService
     */
    public function setPayerAccountId($payerAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($payerAccountId) && !is_string($payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerAccountId, true), gettype($payerAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payerAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payerAccountId, true)), __LINE__);
        }
        if (is_null($payerAccountId) || (is_array($payerAccountId) && empty($payerAccountId))) {
            unset($this->PayerAccountId);
        } else {
            $this->PayerAccountId = $payerAccountId;
        }
        return $this;
    }
    /**
     * Get PriceToPay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPriceToPay()
    {
        return isset($this->PriceToPay) ? $this->PriceToPay : null;
    }
    /**
     * Set PriceToPay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $priceToPay
     * @return \patest\StructType\BizResource_BizService
     */
    public function setPriceToPay($priceToPay = null)
    {
        // validation for constraint: float
        if (!is_null($priceToPay) && !(is_float($priceToPay) || is_numeric($priceToPay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceToPay, true), gettype($priceToPay)), __LINE__);
        }
        if (is_null($priceToPay) || (is_array($priceToPay) && empty($priceToPay))) {
            unset($this->PriceToPay);
        } else {
            $this->PriceToPay = $priceToPay;
        }
        return $this;
    }
}
