<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.ActivityCategory StructType
 * @subpackage Structs
 */
class BizResource_ActivityCategory extends BizResource_PersistableEntityBase
{
    /**
     * The ActivityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActivityId;
    /**
     * The BizResourceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BizResourceId;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The GuidanceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidanceTypeId;
    /**
     * The IsBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBillable;
    /**
     * The OnePerRoom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OnePerRoom;
    /**
     * The OnePerXPeople
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OnePerXPeople;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * Constructor method for BizResource.ActivityCategory
     * @uses BizResource_ActivityCategory::setActivityId()
     * @uses BizResource_ActivityCategory::setBizResourceId()
     * @uses BizResource_ActivityCategory::setCategoryId()
     * @uses BizResource_ActivityCategory::setGuidanceTypeId()
     * @uses BizResource_ActivityCategory::setIsBillable()
     * @uses BizResource_ActivityCategory::setOnePerRoom()
     * @uses BizResource_ActivityCategory::setOnePerXPeople()
     * @uses BizResource_ActivityCategory::setTypeId()
     * @param string $activityId
     * @param string $bizResourceId
     * @param string $categoryId
     * @param string $guidanceTypeId
     * @param bool $isBillable
     * @param bool $onePerRoom
     * @param int $onePerXPeople
     * @param string $typeId
     */
    public function __construct($activityId = null, $bizResourceId = null, $categoryId = null, $guidanceTypeId = null, $isBillable = null, $onePerRoom = null, $onePerXPeople = null, $typeId = null)
    {
        $this
            ->setActivityId($activityId)
            ->setBizResourceId($bizResourceId)
            ->setCategoryId($categoryId)
            ->setGuidanceTypeId($guidanceTypeId)
            ->setIsBillable($isBillable)
            ->setOnePerRoom($onePerRoom)
            ->setOnePerXPeople($onePerXPeople)
            ->setTypeId($typeId);
    }
    /**
     * Get ActivityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityId()
    {
        return isset($this->ActivityId) ? $this->ActivityId : null;
    }
    /**
     * Set ActivityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityId
     * @return \patest\StructType\BizResource_ActivityCategory
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($activityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($activityId, true)), __LINE__);
        }
        if (is_null($activityId) || (is_array($activityId) && empty($activityId))) {
            unset($this->ActivityId);
        } else {
            $this->ActivityId = $activityId;
        }
        return $this;
    }
    /**
     * Get BizResourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBizResourceId()
    {
        return isset($this->BizResourceId) ? $this->BizResourceId : null;
    }
    /**
     * Set BizResourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bizResourceId
     * @return \patest\StructType\BizResource_ActivityCategory
     */
    public function setBizResourceId($bizResourceId = null)
    {
        // validation for constraint: string
        if (!is_null($bizResourceId) && !is_string($bizResourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bizResourceId, true), gettype($bizResourceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bizResourceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bizResourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bizResourceId, true)), __LINE__);
        }
        if (is_null($bizResourceId) || (is_array($bizResourceId) && empty($bizResourceId))) {
            unset($this->BizResourceId);
        } else {
            $this->BizResourceId = $bizResourceId;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\BizResource_ActivityCategory
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get GuidanceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidanceTypeId()
    {
        return isset($this->GuidanceTypeId) ? $this->GuidanceTypeId : null;
    }
    /**
     * Set GuidanceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidanceTypeId
     * @return \patest\StructType\BizResource_ActivityCategory
     */
    public function setGuidanceTypeId($guidanceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($guidanceTypeId) && !is_string($guidanceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidanceTypeId, true), gettype($guidanceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidanceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidanceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidanceTypeId, true)), __LINE__);
        }
        if (is_null($guidanceTypeId) || (is_array($guidanceTypeId) && empty($guidanceTypeId))) {
            unset($this->GuidanceTypeId);
        } else {
            $this->GuidanceTypeId = $guidanceTypeId;
        }
        return $this;
    }
    /**
     * Get IsBillable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBillable()
    {
        return isset($this->IsBillable) ? $this->IsBillable : null;
    }
    /**
     * Set IsBillable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBillable
     * @return \patest\StructType\BizResource_ActivityCategory
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        if (is_null($isBillable) || (is_array($isBillable) && empty($isBillable))) {
            unset($this->IsBillable);
        } else {
            $this->IsBillable = $isBillable;
        }
        return $this;
    }
    /**
     * Get OnePerRoom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOnePerRoom()
    {
        return isset($this->OnePerRoom) ? $this->OnePerRoom : null;
    }
    /**
     * Set OnePerRoom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $onePerRoom
     * @return \patest\StructType\BizResource_ActivityCategory
     */
    public function setOnePerRoom($onePerRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($onePerRoom) && !is_bool($onePerRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onePerRoom, true), gettype($onePerRoom)), __LINE__);
        }
        if (is_null($onePerRoom) || (is_array($onePerRoom) && empty($onePerRoom))) {
            unset($this->OnePerRoom);
        } else {
            $this->OnePerRoom = $onePerRoom;
        }
        return $this;
    }
    /**
     * Get OnePerXPeople value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOnePerXPeople()
    {
        return isset($this->OnePerXPeople) ? $this->OnePerXPeople : null;
    }
    /**
     * Set OnePerXPeople value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $onePerXPeople
     * @return \patest\StructType\BizResource_ActivityCategory
     */
    public function setOnePerXPeople($onePerXPeople = null)
    {
        // validation for constraint: int
        if (!is_null($onePerXPeople) && !(is_int($onePerXPeople) || ctype_digit($onePerXPeople))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onePerXPeople, true), gettype($onePerXPeople)), __LINE__);
        }
        if (is_null($onePerXPeople) || (is_array($onePerXPeople) && empty($onePerXPeople))) {
            unset($this->OnePerXPeople);
        } else {
            $this->OnePerXPeople = $onePerXPeople;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\BizResource_ActivityCategory
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
}
