<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.eSRO.PrepareTransactionToCommit.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_eSRO_PrepareTransactionToCommit_Request extends AnyEntity
{
    /**
     * The ClientDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BizAction_eSRO_ClientDetails
     */
    public $ClientDetails;
    /**
     * The DeliveryMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryMethodId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for BizAction.eSRO.PrepareTransactionToCommit.Request
     * @uses BizAction_eSRO_PrepareTransactionToCommit_Request::setClientDetails()
     * @uses BizAction_eSRO_PrepareTransactionToCommit_Request::setDeliveryMethodId()
     * @uses BizAction_eSRO_PrepareTransactionToCommit_Request::setTransactionId()
     * @param \patest\StructType\BizAction_eSRO_ClientDetails $clientDetails
     * @param string $deliveryMethodId
     * @param string $transactionId
     */
    public function __construct(\patest\StructType\BizAction_eSRO_ClientDetails $clientDetails = null, $deliveryMethodId = null, $transactionId = null)
    {
        $this
            ->setClientDetails($clientDetails)
            ->setDeliveryMethodId($deliveryMethodId)
            ->setTransactionId($transactionId);
    }
    /**
     * Get ClientDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BizAction_eSRO_ClientDetails|null
     */
    public function getClientDetails()
    {
        return isset($this->ClientDetails) ? $this->ClientDetails : null;
    }
    /**
     * Set ClientDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BizAction_eSRO_ClientDetails $clientDetails
     * @return \patest\StructType\BizAction_eSRO_PrepareTransactionToCommit_Request
     */
    public function setClientDetails(\patest\StructType\BizAction_eSRO_ClientDetails $clientDetails = null)
    {
        if (is_null($clientDetails) || (is_array($clientDetails) && empty($clientDetails))) {
            unset($this->ClientDetails);
        } else {
            $this->ClientDetails = $clientDetails;
        }
        return $this;
    }
    /**
     * Get DeliveryMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryMethodId()
    {
        return isset($this->DeliveryMethodId) ? $this->DeliveryMethodId : null;
    }
    /**
     * Set DeliveryMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryMethodId
     * @return \patest\StructType\BizAction_eSRO_PrepareTransactionToCommit_Request
     */
    public function setDeliveryMethodId($deliveryMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryMethodId) && !is_string($deliveryMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryMethodId, true), gettype($deliveryMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryMethodId, true)), __LINE__);
        }
        if (is_null($deliveryMethodId) || (is_array($deliveryMethodId) && empty($deliveryMethodId))) {
            unset($this->DeliveryMethodId);
        } else {
            $this->DeliveryMethodId = $deliveryMethodId;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\BizAction_eSRO_PrepareTransactionToCommit_Request
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
