<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.SetPromoterPriceLists.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_SetPromoterPriceLists_Request extends AnyEntity
{
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityId;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The PromoterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromoterId;
    /**
     * The RegularPriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RegularPriceListId;
    /**
     * The SubscriptionPriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionPriceListId;
    /**
     * Constructor method for BizAction.Ticketing.SetPromoterPriceLists.Request
     * @uses BizAction_Ticketing_SetPromoterPriceLists_Request::setEntityId()
     * @uses BizAction_Ticketing_SetPromoterPriceLists_Request::setEntityName()
     * @uses BizAction_Ticketing_SetPromoterPriceLists_Request::setPromoterId()
     * @uses BizAction_Ticketing_SetPromoterPriceLists_Request::setRegularPriceListId()
     * @uses BizAction_Ticketing_SetPromoterPriceLists_Request::setSubscriptionPriceListId()
     * @param string $entityId
     * @param string $entityName
     * @param string $promoterId
     * @param string $regularPriceListId
     * @param string $subscriptionPriceListId
     */
    public function __construct($entityId = null, $entityName = null, $promoterId = null, $regularPriceListId = null, $subscriptionPriceListId = null)
    {
        $this
            ->setEntityId($entityId)
            ->setEntityName($entityName)
            ->setPromoterId($promoterId)
            ->setRegularPriceListId($regularPriceListId)
            ->setSubscriptionPriceListId($subscriptionPriceListId);
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\BizAction_Ticketing_SetPromoterPriceLists_Request
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\BizAction_Ticketing_SetPromoterPriceLists_Request
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get PromoterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoterId()
    {
        return isset($this->PromoterId) ? $this->PromoterId : null;
    }
    /**
     * Set PromoterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoterId
     * @return \patest\StructType\BizAction_Ticketing_SetPromoterPriceLists_Request
     */
    public function setPromoterId($promoterId = null)
    {
        // validation for constraint: string
        if (!is_null($promoterId) && !is_string($promoterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoterId, true), gettype($promoterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promoterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promoterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promoterId, true)), __LINE__);
        }
        if (is_null($promoterId) || (is_array($promoterId) && empty($promoterId))) {
            unset($this->PromoterId);
        } else {
            $this->PromoterId = $promoterId;
        }
        return $this;
    }
    /**
     * Get RegularPriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegularPriceListId()
    {
        return isset($this->RegularPriceListId) ? $this->RegularPriceListId : null;
    }
    /**
     * Set RegularPriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regularPriceListId
     * @return \patest\StructType\BizAction_Ticketing_SetPromoterPriceLists_Request
     */
    public function setRegularPriceListId($regularPriceListId = null)
    {
        // validation for constraint: string
        if (!is_null($regularPriceListId) && !is_string($regularPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regularPriceListId, true), gettype($regularPriceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($regularPriceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $regularPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($regularPriceListId, true)), __LINE__);
        }
        if (is_null($regularPriceListId) || (is_array($regularPriceListId) && empty($regularPriceListId))) {
            unset($this->RegularPriceListId);
        } else {
            $this->RegularPriceListId = $regularPriceListId;
        }
        return $this;
    }
    /**
     * Get SubscriptionPriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionPriceListId()
    {
        return isset($this->SubscriptionPriceListId) ? $this->SubscriptionPriceListId : null;
    }
    /**
     * Set SubscriptionPriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionPriceListId
     * @return \patest\StructType\BizAction_Ticketing_SetPromoterPriceLists_Request
     */
    public function setSubscriptionPriceListId($subscriptionPriceListId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionPriceListId) && !is_string($subscriptionPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionPriceListId, true), gettype($subscriptionPriceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionPriceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionPriceListId, true)), __LINE__);
        }
        if (is_null($subscriptionPriceListId) || (is_array($subscriptionPriceListId) && empty($subscriptionPriceListId))) {
            unset($this->SubscriptionPriceListId);
        } else {
            $this->SubscriptionPriceListId = $subscriptionPriceListId;
        }
        return $this;
    }
}
