<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Ticketing.ProcessSectionFilterApplicantsParameters.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request extends AnyEntity
{
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The ClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypeIds
     */
    public $ClientTypeIds;
    /**
     * The ClientTypesFilterMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypesFilterMode;
    /**
     * The IncludeWinnersInOtherSections
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeWinnersInOtherSections;
    /**
     * The MaxSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSeats;
    /**
     * The MinSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinSeats;
    /**
     * The SectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionId;
    /**
     * The Sections
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_FilterEventSection
     */
    public $Sections;
    /**
     * The SelectedClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedClientTypeIds;
    /**
     * The SelectedSectionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedSectionIds;
    /**
     * Constructor method for
     * BizAction.Ticketing.ProcessSectionFilterApplicantsParameters.Request
     * @uses BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request::setBallotId()
     * @uses BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request::setClientTypeIds()
     * @uses BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request::setClientTypesFilterMode()
     * @uses BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request::setIncludeWinnersInOtherSections()
     * @uses BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request::setMaxSeats()
     * @uses BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request::setMinSeats()
     * @uses BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request::setSectionId()
     * @uses BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request::setSections()
     * @uses BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request::setSelectedClientTypeIds()
     * @uses BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request::setSelectedSectionIds()
     * @param string $ballotId
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @param string $clientTypesFilterMode
     * @param string $includeWinnersInOtherSections
     * @param int $maxSeats
     * @param int $minSeats
     * @param string $sectionId
     * @param \patest\StructType\RecordSetOfTicketing_FilterEventSection $sections
     * @param string $selectedClientTypeIds
     * @param string $selectedSectionIds
     */
    public function __construct($ballotId = null, \patest\StructType\ClientTypeIds $clientTypeIds = null, $clientTypesFilterMode = null, $includeWinnersInOtherSections = null, $maxSeats = null, $minSeats = null, $sectionId = null, \patest\StructType\RecordSetOfTicketing_FilterEventSection $sections = null, $selectedClientTypeIds = null, $selectedSectionIds = null)
    {
        $this
            ->setBallotId($ballotId)
            ->setClientTypeIds($clientTypeIds)
            ->setClientTypesFilterMode($clientTypesFilterMode)
            ->setIncludeWinnersInOtherSections($includeWinnersInOtherSections)
            ->setMaxSeats($maxSeats)
            ->setMinSeats($minSeats)
            ->setSectionId($sectionId)
            ->setSections($sections)
            ->setSelectedClientTypeIds($selectedClientTypeIds)
            ->setSelectedSectionIds($selectedSectionIds);
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get ClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypeIds|null
     */
    public function getClientTypeIds()
    {
        return isset($this->ClientTypeIds) ? $this->ClientTypeIds : null;
    }
    /**
     * Set ClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @return \patest\StructType\BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request
     */
    public function setClientTypeIds(\patest\StructType\ClientTypeIds $clientTypeIds = null)
    {
        if (is_null($clientTypeIds) || (is_array($clientTypeIds) && empty($clientTypeIds))) {
            unset($this->ClientTypeIds);
        } else {
            $this->ClientTypeIds = $clientTypeIds;
        }
        return $this;
    }
    /**
     * Get ClientTypesFilterMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypesFilterMode()
    {
        return isset($this->ClientTypesFilterMode) ? $this->ClientTypesFilterMode : null;
    }
    /**
     * Set ClientTypesFilterMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientTypesFilterMode::valueIsValid()
     * @uses \patest\EnumType\ClientTypesFilterMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientTypesFilterMode
     * @return \patest\StructType\BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request
     */
    public function setClientTypesFilterMode($clientTypesFilterMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientTypesFilterMode::valueIsValid($clientTypesFilterMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientTypesFilterMode', is_array($clientTypesFilterMode) ? implode(', ', $clientTypesFilterMode) : var_export($clientTypesFilterMode, true), implode(', ', \patest\EnumType\ClientTypesFilterMode::getValidValues())), __LINE__);
        }
        if (is_null($clientTypesFilterMode) || (is_array($clientTypesFilterMode) && empty($clientTypesFilterMode))) {
            unset($this->ClientTypesFilterMode);
        } else {
            $this->ClientTypesFilterMode = $clientTypesFilterMode;
        }
        return $this;
    }
    /**
     * Get IncludeWinnersInOtherSections value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeWinnersInOtherSections()
    {
        return isset($this->IncludeWinnersInOtherSections) ? $this->IncludeWinnersInOtherSections : null;
    }
    /**
     * Set IncludeWinnersInOtherSections value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\IncludeWinnersInOtherSectionsEnum::valueIsValid()
     * @uses \patest\EnumType\IncludeWinnersInOtherSectionsEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeWinnersInOtherSections
     * @return \patest\StructType\BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request
     */
    public function setIncludeWinnersInOtherSections($includeWinnersInOtherSections = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\IncludeWinnersInOtherSectionsEnum::valueIsValid($includeWinnersInOtherSections)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\IncludeWinnersInOtherSectionsEnum', is_array($includeWinnersInOtherSections) ? implode(', ', $includeWinnersInOtherSections) : var_export($includeWinnersInOtherSections, true), implode(', ', \patest\EnumType\IncludeWinnersInOtherSectionsEnum::getValidValues())), __LINE__);
        }
        if (is_null($includeWinnersInOtherSections) || (is_array($includeWinnersInOtherSections) && empty($includeWinnersInOtherSections))) {
            unset($this->IncludeWinnersInOtherSections);
        } else {
            $this->IncludeWinnersInOtherSections = $includeWinnersInOtherSections;
        }
        return $this;
    }
    /**
     * Get MaxSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSeats()
    {
        return isset($this->MaxSeats) ? $this->MaxSeats : null;
    }
    /**
     * Set MaxSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSeats
     * @return \patest\StructType\BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request
     */
    public function setMaxSeats($maxSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeats) && !(is_int($maxSeats) || ctype_digit($maxSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeats, true), gettype($maxSeats)), __LINE__);
        }
        if (is_null($maxSeats) || (is_array($maxSeats) && empty($maxSeats))) {
            unset($this->MaxSeats);
        } else {
            $this->MaxSeats = $maxSeats;
        }
        return $this;
    }
    /**
     * Get MinSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinSeats()
    {
        return isset($this->MinSeats) ? $this->MinSeats : null;
    }
    /**
     * Set MinSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minSeats
     * @return \patest\StructType\BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request
     */
    public function setMinSeats($minSeats = null)
    {
        // validation for constraint: int
        if (!is_null($minSeats) && !(is_int($minSeats) || ctype_digit($minSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minSeats, true), gettype($minSeats)), __LINE__);
        }
        if (is_null($minSeats) || (is_array($minSeats) && empty($minSeats))) {
            unset($this->MinSeats);
        } else {
            $this->MinSeats = $minSeats;
        }
        return $this;
    }
    /**
     * Get SectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionId()
    {
        return isset($this->SectionId) ? $this->SectionId : null;
    }
    /**
     * Set SectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionId
     * @return \patest\StructType\BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionId, true)), __LINE__);
        }
        if (is_null($sectionId) || (is_array($sectionId) && empty($sectionId))) {
            unset($this->SectionId);
        } else {
            $this->SectionId = $sectionId;
        }
        return $this;
    }
    /**
     * Get Sections value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_FilterEventSection|null
     */
    public function getSections()
    {
        return isset($this->Sections) ? $this->Sections : null;
    }
    /**
     * Set Sections value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_FilterEventSection $sections
     * @return \patest\StructType\BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request
     */
    public function setSections(\patest\StructType\RecordSetOfTicketing_FilterEventSection $sections = null)
    {
        if (is_null($sections) || (is_array($sections) && empty($sections))) {
            unset($this->Sections);
        } else {
            $this->Sections = $sections;
        }
        return $this;
    }
    /**
     * Get SelectedClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedClientTypeIds()
    {
        return isset($this->SelectedClientTypeIds) ? $this->SelectedClientTypeIds : null;
    }
    /**
     * Set SelectedClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedClientTypeIds
     * @return \patest\StructType\BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request
     */
    public function setSelectedClientTypeIds($selectedClientTypeIds = null)
    {
        // validation for constraint: string
        if (!is_null($selectedClientTypeIds) && !is_string($selectedClientTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedClientTypeIds, true), gettype($selectedClientTypeIds)), __LINE__);
        }
        if (is_null($selectedClientTypeIds) || (is_array($selectedClientTypeIds) && empty($selectedClientTypeIds))) {
            unset($this->SelectedClientTypeIds);
        } else {
            $this->SelectedClientTypeIds = $selectedClientTypeIds;
        }
        return $this;
    }
    /**
     * Get SelectedSectionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedSectionIds()
    {
        return isset($this->SelectedSectionIds) ? $this->SelectedSectionIds : null;
    }
    /**
     * Set SelectedSectionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedSectionIds
     * @return \patest\StructType\BizAction_Ticketing_ProcessSectionFilterApplicantsParameters_Request
     */
    public function setSelectedSectionIds($selectedSectionIds = null)
    {
        // validation for constraint: string
        if (!is_null($selectedSectionIds) && !is_string($selectedSectionIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedSectionIds, true), gettype($selectedSectionIds)), __LINE__);
        }
        if (is_null($selectedSectionIds) || (is_array($selectedSectionIds) && empty($selectedSectionIds))) {
            unset($this->SelectedSectionIds);
        } else {
            $this->SelectedSectionIds = $selectedSectionIds;
        }
        return $this;
    }
}
