<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.PrintSubscriberTickets.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_PrintSubscriberTickets_Request extends BizAction_Ticketing_RepriceProduct_Request
{
    /**
     * The PrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrinterId;
    /**
     * The PrintingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintingType;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketIds;
    /**
     * The TicketsInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_PrintSubscriberTicketRow
     */
    public $TicketsInformation;
    /**
     * Constructor method for BizAction.Ticketing.PrintSubscriberTickets.Request
     * @uses BizAction_Ticketing_PrintSubscriberTickets_Request::setPrinterId()
     * @uses BizAction_Ticketing_PrintSubscriberTickets_Request::setPrintingType()
     * @uses BizAction_Ticketing_PrintSubscriberTickets_Request::setTicketIds()
     * @uses BizAction_Ticketing_PrintSubscriberTickets_Request::setTicketsInformation()
     * @param string $printerId
     * @param int $printingType
     * @param string $ticketIds
     * @param \patest\StructType\RecordSetOfTicketing_PrintSubscriberTicketRow $ticketsInformation
     */
    public function __construct($printerId = null, $printingType = null, $ticketIds = null, \patest\StructType\RecordSetOfTicketing_PrintSubscriberTicketRow $ticketsInformation = null)
    {
        $this
            ->setPrinterId($printerId)
            ->setPrintingType($printingType)
            ->setTicketIds($ticketIds)
            ->setTicketsInformation($ticketsInformation);
    }
    /**
     * Get PrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrinterId()
    {
        return isset($this->PrinterId) ? $this->PrinterId : null;
    }
    /**
     * Set PrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printerId
     * @return \patest\StructType\BizAction_Ticketing_PrintSubscriberTickets_Request
     */
    public function setPrinterId($printerId = null)
    {
        // validation for constraint: string
        if (!is_null($printerId) && !is_string($printerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printerId, true), gettype($printerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($printerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $printerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($printerId, true)), __LINE__);
        }
        if (is_null($printerId) || (is_array($printerId) && empty($printerId))) {
            unset($this->PrinterId);
        } else {
            $this->PrinterId = $printerId;
        }
        return $this;
    }
    /**
     * Get PrintingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintingType()
    {
        return isset($this->PrintingType) ? $this->PrintingType : null;
    }
    /**
     * Set PrintingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printingType
     * @return \patest\StructType\BizAction_Ticketing_PrintSubscriberTickets_Request
     */
    public function setPrintingType($printingType = null)
    {
        // validation for constraint: int
        if (!is_null($printingType) && !(is_int($printingType) || ctype_digit($printingType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printingType, true), gettype($printingType)), __LINE__);
        }
        if (is_null($printingType) || (is_array($printingType) && empty($printingType))) {
            unset($this->PrintingType);
        } else {
            $this->PrintingType = $printingType;
        }
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketIds
     * @return \patest\StructType\BizAction_Ticketing_PrintSubscriberTickets_Request
     */
    public function setTicketIds($ticketIds = null)
    {
        // validation for constraint: string
        if (!is_null($ticketIds) && !is_string($ticketIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketIds, true), gettype($ticketIds)), __LINE__);
        }
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
    /**
     * Get TicketsInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_PrintSubscriberTicketRow|null
     */
    public function getTicketsInformation()
    {
        return isset($this->TicketsInformation) ? $this->TicketsInformation : null;
    }
    /**
     * Set TicketsInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_PrintSubscriberTicketRow $ticketsInformation
     * @return \patest\StructType\BizAction_Ticketing_PrintSubscriberTickets_Request
     */
    public function setTicketsInformation(\patest\StructType\RecordSetOfTicketing_PrintSubscriberTicketRow $ticketsInformation = null)
    {
        if (is_null($ticketsInformation) || (is_array($ticketsInformation) && empty($ticketsInformation))) {
            unset($this->TicketsInformation);
        } else {
            $this->TicketsInformation = $ticketsInformation;
        }
        return $this;
    }
}
