<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.HandoverTickets.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_HandoverTickets_Request extends AnyEntity
{
    /**
     * The DepositCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositCategoryId;
    /**
     * The KeepBarcodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepBarcodes;
    /**
     * The MoveMoney
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MoveMoney;
    /**
     * The NewClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewClientId;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaidAmount;
    /**
     * The RemainingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RemainingAmount;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketIds
     */
    public $TicketIds;
    /**
     * The TicketsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketsCount;
    /**
     * The TicketsHaveBarcodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TicketsHaveBarcodes;
    /**
     * The TicketsValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TicketsValue;
    /**
     * Constructor method for BizAction.Ticketing.HandoverTickets.Request
     * @uses BizAction_Ticketing_HandoverTickets_Request::setDepositCategoryId()
     * @uses BizAction_Ticketing_HandoverTickets_Request::setKeepBarcodes()
     * @uses BizAction_Ticketing_HandoverTickets_Request::setMoveMoney()
     * @uses BizAction_Ticketing_HandoverTickets_Request::setNewClientId()
     * @uses BizAction_Ticketing_HandoverTickets_Request::setPaidAmount()
     * @uses BizAction_Ticketing_HandoverTickets_Request::setRemainingAmount()
     * @uses BizAction_Ticketing_HandoverTickets_Request::setTicketIds()
     * @uses BizAction_Ticketing_HandoverTickets_Request::setTicketsCount()
     * @uses BizAction_Ticketing_HandoverTickets_Request::setTicketsHaveBarcodes()
     * @uses BizAction_Ticketing_HandoverTickets_Request::setTicketsValue()
     * @param string $depositCategoryId
     * @param bool $keepBarcodes
     * @param bool $moveMoney
     * @param string $newClientId
     * @param \patest\StructType\Money $paidAmount
     * @param \patest\StructType\Money $remainingAmount
     * @param \patest\StructType\TicketIds $ticketIds
     * @param int $ticketsCount
     * @param bool $ticketsHaveBarcodes
     * @param \patest\StructType\Money $ticketsValue
     */
    public function __construct($depositCategoryId = null, $keepBarcodes = null, $moveMoney = null, $newClientId = null, \patest\StructType\Money $paidAmount = null, \patest\StructType\Money $remainingAmount = null, \patest\StructType\TicketIds $ticketIds = null, $ticketsCount = null, $ticketsHaveBarcodes = null, \patest\StructType\Money $ticketsValue = null)
    {
        $this
            ->setDepositCategoryId($depositCategoryId)
            ->setKeepBarcodes($keepBarcodes)
            ->setMoveMoney($moveMoney)
            ->setNewClientId($newClientId)
            ->setPaidAmount($paidAmount)
            ->setRemainingAmount($remainingAmount)
            ->setTicketIds($ticketIds)
            ->setTicketsCount($ticketsCount)
            ->setTicketsHaveBarcodes($ticketsHaveBarcodes)
            ->setTicketsValue($ticketsValue);
    }
    /**
     * Get DepositCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositCategoryId()
    {
        return isset($this->DepositCategoryId) ? $this->DepositCategoryId : null;
    }
    /**
     * Set DepositCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositCategoryId
     * @return \patest\StructType\BizAction_Ticketing_HandoverTickets_Request
     */
    public function setDepositCategoryId($depositCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($depositCategoryId) && !is_string($depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositCategoryId, true), gettype($depositCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositCategoryId, true)), __LINE__);
        }
        if (is_null($depositCategoryId) || (is_array($depositCategoryId) && empty($depositCategoryId))) {
            unset($this->DepositCategoryId);
        } else {
            $this->DepositCategoryId = $depositCategoryId;
        }
        return $this;
    }
    /**
     * Get KeepBarcodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepBarcodes()
    {
        return isset($this->KeepBarcodes) ? $this->KeepBarcodes : null;
    }
    /**
     * Set KeepBarcodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepBarcodes
     * @return \patest\StructType\BizAction_Ticketing_HandoverTickets_Request
     */
    public function setKeepBarcodes($keepBarcodes = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepBarcodes) && !is_bool($keepBarcodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepBarcodes, true), gettype($keepBarcodes)), __LINE__);
        }
        if (is_null($keepBarcodes) || (is_array($keepBarcodes) && empty($keepBarcodes))) {
            unset($this->KeepBarcodes);
        } else {
            $this->KeepBarcodes = $keepBarcodes;
        }
        return $this;
    }
    /**
     * Get MoveMoney value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMoveMoney()
    {
        return isset($this->MoveMoney) ? $this->MoveMoney : null;
    }
    /**
     * Set MoveMoney value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $moveMoney
     * @return \patest\StructType\BizAction_Ticketing_HandoverTickets_Request
     */
    public function setMoveMoney($moveMoney = null)
    {
        // validation for constraint: boolean
        if (!is_null($moveMoney) && !is_bool($moveMoney)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moveMoney, true), gettype($moveMoney)), __LINE__);
        }
        if (is_null($moveMoney) || (is_array($moveMoney) && empty($moveMoney))) {
            unset($this->MoveMoney);
        } else {
            $this->MoveMoney = $moveMoney;
        }
        return $this;
    }
    /**
     * Get NewClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewClientId()
    {
        return isset($this->NewClientId) ? $this->NewClientId : null;
    }
    /**
     * Set NewClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newClientId
     * @return \patest\StructType\BizAction_Ticketing_HandoverTickets_Request
     */
    public function setNewClientId($newClientId = null)
    {
        // validation for constraint: string
        if (!is_null($newClientId) && !is_string($newClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newClientId, true), gettype($newClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newClientId, true)), __LINE__);
        }
        if (is_null($newClientId) || (is_array($newClientId) && empty($newClientId))) {
            unset($this->NewClientId);
        } else {
            $this->NewClientId = $newClientId;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaidAmount()
    {
        return isset($this->PaidAmount) ? $this->PaidAmount : null;
    }
    /**
     * Set PaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paidAmount
     * @return \patest\StructType\BizAction_Ticketing_HandoverTickets_Request
     */
    public function setPaidAmount(\patest\StructType\Money $paidAmount = null)
    {
        if (is_null($paidAmount) || (is_array($paidAmount) && empty($paidAmount))) {
            unset($this->PaidAmount);
        } else {
            $this->PaidAmount = $paidAmount;
        }
        return $this;
    }
    /**
     * Get RemainingAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRemainingAmount()
    {
        return isset($this->RemainingAmount) ? $this->RemainingAmount : null;
    }
    /**
     * Set RemainingAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $remainingAmount
     * @return \patest\StructType\BizAction_Ticketing_HandoverTickets_Request
     */
    public function setRemainingAmount(\patest\StructType\Money $remainingAmount = null)
    {
        if (is_null($remainingAmount) || (is_array($remainingAmount) && empty($remainingAmount))) {
            unset($this->RemainingAmount);
        } else {
            $this->RemainingAmount = $remainingAmount;
        }
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketIds|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketIds $ticketIds
     * @return \patest\StructType\BizAction_Ticketing_HandoverTickets_Request
     */
    public function setTicketIds(\patest\StructType\TicketIds $ticketIds = null)
    {
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
    /**
     * Get TicketsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketsCount()
    {
        return isset($this->TicketsCount) ? $this->TicketsCount : null;
    }
    /**
     * Set TicketsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketsCount
     * @return \patest\StructType\BizAction_Ticketing_HandoverTickets_Request
     */
    public function setTicketsCount($ticketsCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsCount) && !(is_int($ticketsCount) || ctype_digit($ticketsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsCount, true), gettype($ticketsCount)), __LINE__);
        }
        if (is_null($ticketsCount) || (is_array($ticketsCount) && empty($ticketsCount))) {
            unset($this->TicketsCount);
        } else {
            $this->TicketsCount = $ticketsCount;
        }
        return $this;
    }
    /**
     * Get TicketsHaveBarcodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTicketsHaveBarcodes()
    {
        return isset($this->TicketsHaveBarcodes) ? $this->TicketsHaveBarcodes : null;
    }
    /**
     * Set TicketsHaveBarcodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ticketsHaveBarcodes
     * @return \patest\StructType\BizAction_Ticketing_HandoverTickets_Request
     */
    public function setTicketsHaveBarcodes($ticketsHaveBarcodes = null)
    {
        // validation for constraint: boolean
        if (!is_null($ticketsHaveBarcodes) && !is_bool($ticketsHaveBarcodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ticketsHaveBarcodes, true), gettype($ticketsHaveBarcodes)), __LINE__);
        }
        if (is_null($ticketsHaveBarcodes) || (is_array($ticketsHaveBarcodes) && empty($ticketsHaveBarcodes))) {
            unset($this->TicketsHaveBarcodes);
        } else {
            $this->TicketsHaveBarcodes = $ticketsHaveBarcodes;
        }
        return $this;
    }
    /**
     * Get TicketsValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTicketsValue()
    {
        return isset($this->TicketsValue) ? $this->TicketsValue : null;
    }
    /**
     * Set TicketsValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $ticketsValue
     * @return \patest\StructType\BizAction_Ticketing_HandoverTickets_Request
     */
    public function setTicketsValue(\patest\StructType\Money $ticketsValue = null)
    {
        if (is_null($ticketsValue) || (is_array($ticketsValue) && empty($ticketsValue))) {
            unset($this->TicketsValue);
        } else {
            $this->TicketsValue = $ticketsValue;
        }
        return $this;
    }
}
