<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.AwayGameTravelGroupAllotment.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_AwayGameTravelGroupAllotment_Request extends AnyEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The SendTicketToClientTravelGroup
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SendTicketToClientTravelGroup;
    /**
     * The SentTicketToAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SentTicketToAddress;
    /**
     * The SentTicketToAddressId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SentTicketToAddressId;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketIds;
    /**
     * The TicketOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketOwners;
    /**
     * The TicketsAllotment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_TravelGroupTicketAllotmentRow
     */
    public $TicketsAllotment;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TravelGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TravelGroup;
    /**
     * The TravelGroupMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TravelGroupMode;
    /**
     * The TravelGroupThresholdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TravelGroupThresholdDate;
    /**
     * Constructor method for BizAction.Ticketing.AwayGameTravelGroupAllotment.Request
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setAreaId()
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setEventId()
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setSendTicketToClientTravelGroup()
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setSentTicketToAddress()
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setSentTicketToAddressId()
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setTicketIds()
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setTicketOwners()
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setTicketsAllotment()
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setTransactionGuid()
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setTravelGroup()
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setTravelGroupMode()
     * @uses BizAction_Ticketing_AwayGameTravelGroupAllotment_Request::setTravelGroupThresholdDate()
     * @param string $areaId
     * @param string $eventId
     * @param string $sendTicketToClientTravelGroup
     * @param string $sentTicketToAddress
     * @param string $sentTicketToAddressId
     * @param string $ticketIds
     * @param string $ticketOwners
     * @param \patest\StructType\RecordSetOfTicketing_TravelGroupTicketAllotmentRow $ticketsAllotment
     * @param string $transactionGuid
     * @param int $travelGroup
     * @param int $travelGroupMode
     * @param string $travelGroupThresholdDate
     */
    public function __construct($areaId = null, $eventId = null, $sendTicketToClientTravelGroup = null, $sentTicketToAddress = null, $sentTicketToAddressId = null, $ticketIds = null, $ticketOwners = null, \patest\StructType\RecordSetOfTicketing_TravelGroupTicketAllotmentRow $ticketsAllotment = null, $transactionGuid = null, $travelGroup = null, $travelGroupMode = null, $travelGroupThresholdDate = null)
    {
        $this
            ->setAreaId($areaId)
            ->setEventId($eventId)
            ->setSendTicketToClientTravelGroup($sendTicketToClientTravelGroup)
            ->setSentTicketToAddress($sentTicketToAddress)
            ->setSentTicketToAddressId($sentTicketToAddressId)
            ->setTicketIds($ticketIds)
            ->setTicketOwners($ticketOwners)
            ->setTicketsAllotment($ticketsAllotment)
            ->setTransactionGuid($transactionGuid)
            ->setTravelGroup($travelGroup)
            ->setTravelGroupMode($travelGroupMode)
            ->setTravelGroupThresholdDate($travelGroupThresholdDate);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get SendTicketToClientTravelGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSendTicketToClientTravelGroup()
    {
        return isset($this->SendTicketToClientTravelGroup) ? $this->SendTicketToClientTravelGroup : null;
    }
    /**
     * Set SendTicketToClientTravelGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sendTicketToClientTravelGroup
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setSendTicketToClientTravelGroup($sendTicketToClientTravelGroup = null)
    {
        // validation for constraint: string
        if (!is_null($sendTicketToClientTravelGroup) && !is_string($sendTicketToClientTravelGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendTicketToClientTravelGroup, true), gettype($sendTicketToClientTravelGroup)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sendTicketToClientTravelGroup) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sendTicketToClientTravelGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sendTicketToClientTravelGroup, true)), __LINE__);
        }
        if (is_null($sendTicketToClientTravelGroup) || (is_array($sendTicketToClientTravelGroup) && empty($sendTicketToClientTravelGroup))) {
            unset($this->SendTicketToClientTravelGroup);
        } else {
            $this->SendTicketToClientTravelGroup = $sendTicketToClientTravelGroup;
        }
        return $this;
    }
    /**
     * Get SentTicketToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSentTicketToAddress()
    {
        return isset($this->SentTicketToAddress) ? $this->SentTicketToAddress : null;
    }
    /**
     * Set SentTicketToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sentTicketToAddress
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setSentTicketToAddress($sentTicketToAddress = null)
    {
        // validation for constraint: string
        if (!is_null($sentTicketToAddress) && !is_string($sentTicketToAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentTicketToAddress, true), gettype($sentTicketToAddress)), __LINE__);
        }
        if (is_null($sentTicketToAddress) || (is_array($sentTicketToAddress) && empty($sentTicketToAddress))) {
            unset($this->SentTicketToAddress);
        } else {
            $this->SentTicketToAddress = $sentTicketToAddress;
        }
        return $this;
    }
    /**
     * Get SentTicketToAddressId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSentTicketToAddressId()
    {
        return isset($this->SentTicketToAddressId) ? $this->SentTicketToAddressId : null;
    }
    /**
     * Set SentTicketToAddressId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sentTicketToAddressId
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setSentTicketToAddressId($sentTicketToAddressId = null)
    {
        // validation for constraint: string
        if (!is_null($sentTicketToAddressId) && !is_string($sentTicketToAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentTicketToAddressId, true), gettype($sentTicketToAddressId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sentTicketToAddressId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sentTicketToAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sentTicketToAddressId, true)), __LINE__);
        }
        if (is_null($sentTicketToAddressId) || (is_array($sentTicketToAddressId) && empty($sentTicketToAddressId))) {
            unset($this->SentTicketToAddressId);
        } else {
            $this->SentTicketToAddressId = $sentTicketToAddressId;
        }
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketIds
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setTicketIds($ticketIds = null)
    {
        // validation for constraint: string
        if (!is_null($ticketIds) && !is_string($ticketIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketIds, true), gettype($ticketIds)), __LINE__);
        }
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
    /**
     * Get TicketOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketOwners()
    {
        return isset($this->TicketOwners) ? $this->TicketOwners : null;
    }
    /**
     * Set TicketOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketOwners
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setTicketOwners($ticketOwners = null)
    {
        // validation for constraint: string
        if (!is_null($ticketOwners) && !is_string($ticketOwners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketOwners, true), gettype($ticketOwners)), __LINE__);
        }
        if (is_null($ticketOwners) || (is_array($ticketOwners) && empty($ticketOwners))) {
            unset($this->TicketOwners);
        } else {
            $this->TicketOwners = $ticketOwners;
        }
        return $this;
    }
    /**
     * Get TicketsAllotment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_TravelGroupTicketAllotmentRow|null
     */
    public function getTicketsAllotment()
    {
        return isset($this->TicketsAllotment) ? $this->TicketsAllotment : null;
    }
    /**
     * Set TicketsAllotment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_TravelGroupTicketAllotmentRow $ticketsAllotment
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setTicketsAllotment(\patest\StructType\RecordSetOfTicketing_TravelGroupTicketAllotmentRow $ticketsAllotment = null)
    {
        if (is_null($ticketsAllotment) || (is_array($ticketsAllotment) && empty($ticketsAllotment))) {
            unset($this->TicketsAllotment);
        } else {
            $this->TicketsAllotment = $ticketsAllotment;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TravelGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTravelGroup()
    {
        return isset($this->TravelGroup) ? $this->TravelGroup : null;
    }
    /**
     * Set TravelGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $travelGroup
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setTravelGroup($travelGroup = null)
    {
        // validation for constraint: int
        if (!is_null($travelGroup) && !(is_int($travelGroup) || ctype_digit($travelGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelGroup, true), gettype($travelGroup)), __LINE__);
        }
        if (is_null($travelGroup) || (is_array($travelGroup) && empty($travelGroup))) {
            unset($this->TravelGroup);
        } else {
            $this->TravelGroup = $travelGroup;
        }
        return $this;
    }
    /**
     * Get TravelGroupMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTravelGroupMode()
    {
        return isset($this->TravelGroupMode) ? $this->TravelGroupMode : null;
    }
    /**
     * Set TravelGroupMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $travelGroupMode
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setTravelGroupMode($travelGroupMode = null)
    {
        // validation for constraint: int
        if (!is_null($travelGroupMode) && !(is_int($travelGroupMode) || ctype_digit($travelGroupMode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelGroupMode, true), gettype($travelGroupMode)), __LINE__);
        }
        if (is_null($travelGroupMode) || (is_array($travelGroupMode) && empty($travelGroupMode))) {
            unset($this->TravelGroupMode);
        } else {
            $this->TravelGroupMode = $travelGroupMode;
        }
        return $this;
    }
    /**
     * Get TravelGroupThresholdDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTravelGroupThresholdDate()
    {
        return isset($this->TravelGroupThresholdDate) ? $this->TravelGroupThresholdDate : null;
    }
    /**
     * Set TravelGroupThresholdDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $travelGroupThresholdDate
     * @return \patest\StructType\BizAction_Ticketing_AwayGameTravelGroupAllotment_Request
     */
    public function setTravelGroupThresholdDate($travelGroupThresholdDate = null)
    {
        // validation for constraint: string
        if (!is_null($travelGroupThresholdDate) && !is_string($travelGroupThresholdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelGroupThresholdDate, true), gettype($travelGroupThresholdDate)), __LINE__);
        }
        if (is_null($travelGroupThresholdDate) || (is_array($travelGroupThresholdDate) && empty($travelGroupThresholdDate))) {
            unset($this->TravelGroupThresholdDate);
        } else {
            $this->TravelGroupThresholdDate = $travelGroupThresholdDate;
        }
        return $this;
    }
}
