<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Ticketing.AttachTicketSchemeFulfillmentToExistingReservation.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_AttachTicketSchemeFulfillmentToExistingReservation_Request extends AnyEntity
{
    /**
     * The CandidateTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SelectedTicket
     */
    public $CandidateTickets;
    /**
     * The FulfillmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FulfillmentId;
    /**
     * Constructor method for
     * BizAction.Ticketing.AttachTicketSchemeFulfillmentToExistingReservation.Request
     * @uses BizAction_Ticketing_AttachTicketSchemeFulfillmentToExistingReservation_Request::setCandidateTickets()
     * @uses BizAction_Ticketing_AttachTicketSchemeFulfillmentToExistingReservation_Request::setFulfillmentId()
     * @param \patest\StructType\RecordSetOfTicketing_SelectedTicket $candidateTickets
     * @param string $fulfillmentId
     */
    public function __construct(\patest\StructType\RecordSetOfTicketing_SelectedTicket $candidateTickets = null, $fulfillmentId = null)
    {
        $this
            ->setCandidateTickets($candidateTickets)
            ->setFulfillmentId($fulfillmentId);
    }
    /**
     * Get CandidateTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SelectedTicket|null
     */
    public function getCandidateTickets()
    {
        return isset($this->CandidateTickets) ? $this->CandidateTickets : null;
    }
    /**
     * Set CandidateTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SelectedTicket $candidateTickets
     * @return \patest\StructType\BizAction_Ticketing_AttachTicketSchemeFulfillmentToExistingReservation_Request
     */
    public function setCandidateTickets(\patest\StructType\RecordSetOfTicketing_SelectedTicket $candidateTickets = null)
    {
        if (is_null($candidateTickets) || (is_array($candidateTickets) && empty($candidateTickets))) {
            unset($this->CandidateTickets);
        } else {
            $this->CandidateTickets = $candidateTickets;
        }
        return $this;
    }
    /**
     * Get FulfillmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFulfillmentId()
    {
        return isset($this->FulfillmentId) ? $this->FulfillmentId : null;
    }
    /**
     * Set FulfillmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fulfillmentId
     * @return \patest\StructType\BizAction_Ticketing_AttachTicketSchemeFulfillmentToExistingReservation_Request
     */
    public function setFulfillmentId($fulfillmentId = null)
    {
        // validation for constraint: string
        if (!is_null($fulfillmentId) && !is_string($fulfillmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fulfillmentId, true), gettype($fulfillmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fulfillmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fulfillmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fulfillmentId, true)), __LINE__);
        }
        if (is_null($fulfillmentId) || (is_array($fulfillmentId) && empty($fulfillmentId))) {
            unset($this->FulfillmentId);
        } else {
            $this->FulfillmentId = $fulfillmentId;
        }
        return $this;
    }
}
