<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Subscription.ChangeHeldSeatForRenew.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Subscription_ChangeHeldSeatForRenew_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The LockId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockId;
    /**
     * The NewAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewAreaId;
    /**
     * The NewSeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewSeatId;
    /**
     * The SeatAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatAction;
    /**
     * The SeatDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatDescription;
    /**
     * The SeriesDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesDescription;
    /**
     * The SeriesIdNewSeason
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesIdNewSeason;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * Constructor method for BizAction.Subscription.ChangeHeldSeatForRenew.Request
     * @uses BizAction_Subscription_ChangeHeldSeatForRenew_Request::setClientId()
     * @uses BizAction_Subscription_ChangeHeldSeatForRenew_Request::setLockId()
     * @uses BizAction_Subscription_ChangeHeldSeatForRenew_Request::setNewAreaId()
     * @uses BizAction_Subscription_ChangeHeldSeatForRenew_Request::setNewSeatId()
     * @uses BizAction_Subscription_ChangeHeldSeatForRenew_Request::setSeatAction()
     * @uses BizAction_Subscription_ChangeHeldSeatForRenew_Request::setSeatDescription()
     * @uses BizAction_Subscription_ChangeHeldSeatForRenew_Request::setSeriesDescription()
     * @uses BizAction_Subscription_ChangeHeldSeatForRenew_Request::setSeriesIdNewSeason()
     * @uses BizAction_Subscription_ChangeHeldSeatForRenew_Request::setSubscriptionInstanceId()
     * @param string $clientId
     * @param string $lockId
     * @param string $newAreaId
     * @param int $newSeatId
     * @param string $seatAction
     * @param string $seatDescription
     * @param string $seriesDescription
     * @param string $seriesIdNewSeason
     * @param string $subscriptionInstanceId
     */
    public function __construct($clientId = null, $lockId = null, $newAreaId = null, $newSeatId = null, $seatAction = null, $seatDescription = null, $seriesDescription = null, $seriesIdNewSeason = null, $subscriptionInstanceId = null)
    {
        $this
            ->setClientId($clientId)
            ->setLockId($lockId)
            ->setNewAreaId($newAreaId)
            ->setNewSeatId($newSeatId)
            ->setSeatAction($seatAction)
            ->setSeatDescription($seatDescription)
            ->setSeriesDescription($seriesDescription)
            ->setSeriesIdNewSeason($seriesIdNewSeason)
            ->setSubscriptionInstanceId($subscriptionInstanceId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Subscription_ChangeHeldSeatForRenew_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get LockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockId()
    {
        return isset($this->LockId) ? $this->LockId : null;
    }
    /**
     * Set LockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockId
     * @return \patest\StructType\BizAction_Subscription_ChangeHeldSeatForRenew_Request
     */
    public function setLockId($lockId = null)
    {
        // validation for constraint: string
        if (!is_null($lockId) && !is_string($lockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockId, true), gettype($lockId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockId, true)), __LINE__);
        }
        if (is_null($lockId) || (is_array($lockId) && empty($lockId))) {
            unset($this->LockId);
        } else {
            $this->LockId = $lockId;
        }
        return $this;
    }
    /**
     * Get NewAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewAreaId()
    {
        return isset($this->NewAreaId) ? $this->NewAreaId : null;
    }
    /**
     * Set NewAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newAreaId
     * @return \patest\StructType\BizAction_Subscription_ChangeHeldSeatForRenew_Request
     */
    public function setNewAreaId($newAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($newAreaId) && !is_string($newAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newAreaId, true), gettype($newAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newAreaId, true)), __LINE__);
        }
        if (is_null($newAreaId) || (is_array($newAreaId) && empty($newAreaId))) {
            unset($this->NewAreaId);
        } else {
            $this->NewAreaId = $newAreaId;
        }
        return $this;
    }
    /**
     * Get NewSeatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewSeatId()
    {
        return isset($this->NewSeatId) ? $this->NewSeatId : null;
    }
    /**
     * Set NewSeatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newSeatId
     * @return \patest\StructType\BizAction_Subscription_ChangeHeldSeatForRenew_Request
     */
    public function setNewSeatId($newSeatId = null)
    {
        // validation for constraint: int
        if (!is_null($newSeatId) && !(is_int($newSeatId) || ctype_digit($newSeatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newSeatId, true), gettype($newSeatId)), __LINE__);
        }
        if (is_null($newSeatId) || (is_array($newSeatId) && empty($newSeatId))) {
            unset($this->NewSeatId);
        } else {
            $this->NewSeatId = $newSeatId;
        }
        return $this;
    }
    /**
     * Get SeatAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatAction()
    {
        return isset($this->SeatAction) ? $this->SeatAction : null;
    }
    /**
     * Set SeatAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HeldSeatAction::valueIsValid()
     * @uses \patest\EnumType\HeldSeatAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatAction
     * @return \patest\StructType\BizAction_Subscription_ChangeHeldSeatForRenew_Request
     */
    public function setSeatAction($seatAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HeldSeatAction::valueIsValid($seatAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HeldSeatAction', is_array($seatAction) ? implode(', ', $seatAction) : var_export($seatAction, true), implode(', ', \patest\EnumType\HeldSeatAction::getValidValues())), __LINE__);
        }
        if (is_null($seatAction) || (is_array($seatAction) && empty($seatAction))) {
            unset($this->SeatAction);
        } else {
            $this->SeatAction = $seatAction;
        }
        return $this;
    }
    /**
     * Get SeatDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatDescription()
    {
        return isset($this->SeatDescription) ? $this->SeatDescription : null;
    }
    /**
     * Set SeatDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatDescription
     * @return \patest\StructType\BizAction_Subscription_ChangeHeldSeatForRenew_Request
     */
    public function setSeatDescription($seatDescription = null)
    {
        // validation for constraint: string
        if (!is_null($seatDescription) && !is_string($seatDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatDescription, true), gettype($seatDescription)), __LINE__);
        }
        if (is_null($seatDescription) || (is_array($seatDescription) && empty($seatDescription))) {
            unset($this->SeatDescription);
        } else {
            $this->SeatDescription = $seatDescription;
        }
        return $this;
    }
    /**
     * Get SeriesDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesDescription()
    {
        return isset($this->SeriesDescription) ? $this->SeriesDescription : null;
    }
    /**
     * Set SeriesDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesDescription
     * @return \patest\StructType\BizAction_Subscription_ChangeHeldSeatForRenew_Request
     */
    public function setSeriesDescription($seriesDescription = null)
    {
        // validation for constraint: string
        if (!is_null($seriesDescription) && !is_string($seriesDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesDescription, true), gettype($seriesDescription)), __LINE__);
        }
        if (is_null($seriesDescription) || (is_array($seriesDescription) && empty($seriesDescription))) {
            unset($this->SeriesDescription);
        } else {
            $this->SeriesDescription = $seriesDescription;
        }
        return $this;
    }
    /**
     * Get SeriesIdNewSeason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesIdNewSeason()
    {
        return isset($this->SeriesIdNewSeason) ? $this->SeriesIdNewSeason : null;
    }
    /**
     * Set SeriesIdNewSeason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesIdNewSeason
     * @return \patest\StructType\BizAction_Subscription_ChangeHeldSeatForRenew_Request
     */
    public function setSeriesIdNewSeason($seriesIdNewSeason = null)
    {
        // validation for constraint: string
        if (!is_null($seriesIdNewSeason) && !is_string($seriesIdNewSeason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesIdNewSeason, true), gettype($seriesIdNewSeason)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesIdNewSeason) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesIdNewSeason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesIdNewSeason, true)), __LINE__);
        }
        if (is_null($seriesIdNewSeason) || (is_array($seriesIdNewSeason) && empty($seriesIdNewSeason))) {
            unset($this->SeriesIdNewSeason);
        } else {
            $this->SeriesIdNewSeason = $seriesIdNewSeason;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\BizAction_Subscription_ChangeHeldSeatForRenew_Request
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
}
