<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.RequestForSpecialPermission.Response
 * StructType
 * @subpackage Structs
 */
class BizAction_Security_RequestForSpecialPermission_Response extends AnyEntity
{
    /**
     * The ApprovedByAdministratorKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ApprovedByAdministratorKey;
    /**
     * The RequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestId;
    /**
     * Constructor method for BizAction.Security.RequestForSpecialPermission.Response
     * @uses BizAction_Security_RequestForSpecialPermission_Response::setApprovedByAdministratorKey()
     * @uses BizAction_Security_RequestForSpecialPermission_Response::setRequestId()
     * @param bool $approvedByAdministratorKey
     * @param string $requestId
     */
    public function __construct($approvedByAdministratorKey = null, $requestId = null)
    {
        $this
            ->setApprovedByAdministratorKey($approvedByAdministratorKey)
            ->setRequestId($requestId);
    }
    /**
     * Get ApprovedByAdministratorKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getApprovedByAdministratorKey()
    {
        return isset($this->ApprovedByAdministratorKey) ? $this->ApprovedByAdministratorKey : null;
    }
    /**
     * Set ApprovedByAdministratorKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $approvedByAdministratorKey
     * @return \patest\StructType\BizAction_Security_RequestForSpecialPermission_Response
     */
    public function setApprovedByAdministratorKey($approvedByAdministratorKey = null)
    {
        // validation for constraint: boolean
        if (!is_null($approvedByAdministratorKey) && !is_bool($approvedByAdministratorKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approvedByAdministratorKey, true), gettype($approvedByAdministratorKey)), __LINE__);
        }
        if (is_null($approvedByAdministratorKey) || (is_array($approvedByAdministratorKey) && empty($approvedByAdministratorKey))) {
            unset($this->ApprovedByAdministratorKey);
        } else {
            $this->ApprovedByAdministratorKey = $approvedByAdministratorKey;
        }
        return $this;
    }
    /**
     * Get RequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestId()
    {
        return isset($this->RequestId) ? $this->RequestId : null;
    }
    /**
     * Set RequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestId
     * @return \patest\StructType\BizAction_Security_RequestForSpecialPermission_Response
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestId, true)), __LINE__);
        }
        if (is_null($requestId) || (is_array($requestId) && empty($requestId))) {
            unset($this->RequestId);
        } else {
            $this->RequestId = $requestId;
        }
        return $this;
    }
}
