<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.CloneProfile.Request StructType
 * @subpackage Structs
 */
class BizAction_Security_CloneProfile_Request extends AnyEntity
{
    /**
     * The ProfileGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProfileGuid;
    /**
     * Constructor method for BizAction.Security.CloneProfile.Request
     * @uses BizAction_Security_CloneProfile_Request::setProfileGuid()
     * @param string $profileGuid
     */
    public function __construct($profileGuid = null)
    {
        $this
            ->setProfileGuid($profileGuid);
    }
    /**
     * Get ProfileGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfileGuid()
    {
        return isset($this->ProfileGuid) ? $this->ProfileGuid : null;
    }
    /**
     * Set ProfileGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profileGuid
     * @return \patest\StructType\BizAction_Security_CloneProfile_Request
     */
    public function setProfileGuid($profileGuid = null)
    {
        // validation for constraint: string
        if (!is_null($profileGuid) && !is_string($profileGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileGuid, true), gettype($profileGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($profileGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $profileGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($profileGuid, true)), __LINE__);
        }
        if (is_null($profileGuid) || (is_array($profileGuid) && empty($profileGuid))) {
            unset($this->ProfileGuid);
        } else {
            $this->ProfileGuid = $profileGuid;
        }
        return $this;
    }
}
