<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.CheckSpecialPermissionStatus.Response
 * StructType
 * @subpackage Structs
 */
class BizAction_Security_CheckSpecialPermissionStatus_Response extends AnyEntity
{
    /**
     * The ExecutionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionStatus;
    /**
     * The Found
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Found;
    /**
     * The RequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for BizAction.Security.CheckSpecialPermissionStatus.Response
     * @uses BizAction_Security_CheckSpecialPermissionStatus_Response::setExecutionStatus()
     * @uses BizAction_Security_CheckSpecialPermissionStatus_Response::setFound()
     * @uses BizAction_Security_CheckSpecialPermissionStatus_Response::setRequestId()
     * @uses BizAction_Security_CheckSpecialPermissionStatus_Response::setStatus()
     * @param string $executionStatus
     * @param bool $found
     * @param string $requestId
     * @param string $status
     */
    public function __construct($executionStatus = null, $found = null, $requestId = null, $status = null)
    {
        $this
            ->setExecutionStatus($executionStatus)
            ->setFound($found)
            ->setRequestId($requestId)
            ->setStatus($status);
    }
    /**
     * Get ExecutionStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionStatus()
    {
        return isset($this->ExecutionStatus) ? $this->ExecutionStatus : null;
    }
    /**
     * Set ExecutionStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestExecutionStatus::valueIsValid()
     * @uses \patest\EnumType\RequestExecutionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $executionStatus
     * @return \patest\StructType\BizAction_Security_CheckSpecialPermissionStatus_Response
     */
    public function setExecutionStatus($executionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestExecutionStatus::valueIsValid($executionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestExecutionStatus', is_array($executionStatus) ? implode(', ', $executionStatus) : var_export($executionStatus, true), implode(', ', \patest\EnumType\RequestExecutionStatus::getValidValues())), __LINE__);
        }
        if (is_null($executionStatus) || (is_array($executionStatus) && empty($executionStatus))) {
            unset($this->ExecutionStatus);
        } else {
            $this->ExecutionStatus = $executionStatus;
        }
        return $this;
    }
    /**
     * Get Found value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFound()
    {
        return isset($this->Found) ? $this->Found : null;
    }
    /**
     * Set Found value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $found
     * @return \patest\StructType\BizAction_Security_CheckSpecialPermissionStatus_Response
     */
    public function setFound($found = null)
    {
        // validation for constraint: boolean
        if (!is_null($found) && !is_bool($found)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($found, true), gettype($found)), __LINE__);
        }
        if (is_null($found) || (is_array($found) && empty($found))) {
            unset($this->Found);
        } else {
            $this->Found = $found;
        }
        return $this;
    }
    /**
     * Get RequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestId()
    {
        return isset($this->RequestId) ? $this->RequestId : null;
    }
    /**
     * Set RequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestId
     * @return \patest\StructType\BizAction_Security_CheckSpecialPermissionStatus_Response
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestId, true)), __LINE__);
        }
        if (is_null($requestId) || (is_array($requestId) && empty($requestId))) {
            unset($this->RequestId);
        } else {
            $this->RequestId = $requestId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ApprovalDecisionType::valueIsValid()
     * @uses \patest\EnumType\ApprovalDecisionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\BizAction_Security_CheckSpecialPermissionStatus_Response
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ApprovalDecisionType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ApprovalDecisionType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\ApprovalDecisionType::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
