<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.CheckNeedForSpecialPermission.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Security_CheckNeedForSpecialPermission_Request extends AnyEntity
{
    /**
     * The OperationForApprovalType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $OperationForApprovalType;
    /**
     * Constructor method for BizAction.Security.CheckNeedForSpecialPermission.Request
     * @uses BizAction_Security_CheckNeedForSpecialPermission_Request::setOperationForApprovalType()
     * @param string[] $operationForApprovalType
     */
    public function __construct(array $operationForApprovalType = array())
    {
        $this
            ->setOperationForApprovalType($operationForApprovalType);
    }
    /**
     * Get OperationForApprovalType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOperationForApprovalType()
    {
        return isset($this->OperationForApprovalType) ? $this->OperationForApprovalType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationForApprovalType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationForApprovalType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationForApprovalTypeForArrayConstraintsFromSetOperationForApprovalType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Security_CheckNeedForSpecialPermission_RequestOperationForApprovalTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OperationForApprovalType::valueIsValid($bizAction_Security_CheckNeedForSpecialPermission_RequestOperationForApprovalTypeItem)) {
                $invalidValues[] = is_object($bizAction_Security_CheckNeedForSpecialPermission_RequestOperationForApprovalTypeItem) ? get_class($bizAction_Security_CheckNeedForSpecialPermission_RequestOperationForApprovalTypeItem) : sprintf('%s(%s)', gettype($bizAction_Security_CheckNeedForSpecialPermission_RequestOperationForApprovalTypeItem), var_export($bizAction_Security_CheckNeedForSpecialPermission_RequestOperationForApprovalTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OperationForApprovalType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OperationForApprovalType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationForApprovalType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OperationForApprovalType::valueIsValid()
     * @uses \patest\EnumType\OperationForApprovalType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $operationForApprovalType
     * @return \patest\StructType\BizAction_Security_CheckNeedForSpecialPermission_Request
     */
    public function setOperationForApprovalType(array $operationForApprovalType = array())
    {
        // validation for constraint: list
        if ('' !== ($operationForApprovalTypeArrayErrorMessage = self::validateOperationForApprovalTypeForArrayConstraintsFromSetOperationForApprovalType($operationForApprovalType))) {
            throw new \InvalidArgumentException($operationForApprovalTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($operationForApprovalType) || (is_array($operationForApprovalType) && empty($operationForApprovalType))) {
            unset($this->OperationForApprovalType);
        } else {
            $this->OperationForApprovalType = is_array($operationForApprovalType) ? implode(' ', $operationForApprovalType) : null;
        }
        return $this;
    }
}
