<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.PriceListExport.AdditionalPriceType
 * StructType
 * @subpackage Structs
 */
class BizAction_Sales_PriceListExport_AdditionalPriceType extends AnyEntity
{
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DiscountAmount;
    /**
     * The DiscountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DiscountType;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * Constructor method for BizAction.Sales.PriceListExport.AdditionalPriceType
     * @uses BizAction_Sales_PriceListExport_AdditionalPriceType::setDiscountAmount()
     * @uses BizAction_Sales_PriceListExport_AdditionalPriceType::setDiscountType()
     * @uses BizAction_Sales_PriceListExport_AdditionalPriceType::setPriceTypeId()
     * @param float $discountAmount
     * @param string $discountType
     * @param string $priceTypeId
     */
    public function __construct($discountAmount = null, $discountType = null, $priceTypeId = null)
    {
        $this
            ->setDiscountAmount($discountAmount)
            ->setDiscountType($discountType)
            ->setPriceTypeId($priceTypeId);
    }
    /**
     * Get DiscountAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return isset($this->DiscountAmount) ? $this->DiscountAmount : null;
    }
    /**
     * Set DiscountAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $discountAmount
     * @return \patest\StructType\BizAction_Sales_PriceListExport_AdditionalPriceType
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        if (is_null($discountAmount) || (is_array($discountAmount) && empty($discountAmount))) {
            unset($this->DiscountAmount);
        } else {
            $this->DiscountAmount = $discountAmount;
        }
        return $this;
    }
    /**
     * Get DiscountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiscountType()
    {
        return isset($this->DiscountType) ? $this->DiscountType : null;
    }
    /**
     * Set DiscountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DiscountType::valueIsValid()
     * @uses \patest\EnumType\DiscountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $discountType
     * @return \patest\StructType\BizAction_Sales_PriceListExport_AdditionalPriceType
     */
    public function setDiscountType($discountType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DiscountType::valueIsValid($discountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DiscountType', is_array($discountType) ? implode(', ', $discountType) : var_export($discountType, true), implode(', ', \patest\EnumType\DiscountType::getValidValues())), __LINE__);
        }
        if (is_null($discountType) || (is_array($discountType) && empty($discountType))) {
            unset($this->DiscountType);
        } else {
            $this->DiscountType = $discountType;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\BizAction_Sales_PriceListExport_AdditionalPriceType
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
}
