<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.MoveMoney.Response StructType
 * @subpackage Structs
 */
class BizAction_Sales_MoveMoney_Response extends AnyEntity
{
    /**
     * The IsPaymentMissing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPaymentMissing;
    /**
     * The PaymentSelection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Sales_MoveMoney_PaymentSelectionEntry
     */
    public $PaymentSelection;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Sales.MoveMoney.Response
     * @uses BizAction_Sales_MoveMoney_Response::setIsPaymentMissing()
     * @uses BizAction_Sales_MoveMoney_Response::setPaymentSelection()
     * @uses BizAction_Sales_MoveMoney_Response::setTransactionGuid()
     * @param bool $isPaymentMissing
     * @param \patest\StructType\RecordSetOfBizAction_Sales_MoveMoney_PaymentSelectionEntry $paymentSelection
     * @param string $transactionGuid
     */
    public function __construct($isPaymentMissing = null, \patest\StructType\RecordSetOfBizAction_Sales_MoveMoney_PaymentSelectionEntry $paymentSelection = null, $transactionGuid = null)
    {
        $this
            ->setIsPaymentMissing($isPaymentMissing)
            ->setPaymentSelection($paymentSelection)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get IsPaymentMissing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPaymentMissing()
    {
        return isset($this->IsPaymentMissing) ? $this->IsPaymentMissing : null;
    }
    /**
     * Set IsPaymentMissing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPaymentMissing
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Response
     */
    public function setIsPaymentMissing($isPaymentMissing = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaymentMissing) && !is_bool($isPaymentMissing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPaymentMissing, true), gettype($isPaymentMissing)), __LINE__);
        }
        if (is_null($isPaymentMissing) || (is_array($isPaymentMissing) && empty($isPaymentMissing))) {
            unset($this->IsPaymentMissing);
        } else {
            $this->IsPaymentMissing = $isPaymentMissing;
        }
        return $this;
    }
    /**
     * Get PaymentSelection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Sales_MoveMoney_PaymentSelectionEntry|null
     */
    public function getPaymentSelection()
    {
        return isset($this->PaymentSelection) ? $this->PaymentSelection : null;
    }
    /**
     * Set PaymentSelection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Sales_MoveMoney_PaymentSelectionEntry $paymentSelection
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Response
     */
    public function setPaymentSelection(\patest\StructType\RecordSetOfBizAction_Sales_MoveMoney_PaymentSelectionEntry $paymentSelection = null)
    {
        if (is_null($paymentSelection) || (is_array($paymentSelection) && empty($paymentSelection))) {
            unset($this->PaymentSelection);
        } else {
            $this->PaymentSelection = $paymentSelection;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Response
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
