<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sale.PriceListBulkUpdate.Request StructType
 * @subpackage Structs
 */
class BizAction_Sale_PriceListBulkUpdate_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The FileType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileType;
    /**
     * The MatrixPriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MatrixPriceListId;
    /**
     * The PriceListIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceListIds
     */
    public $PriceListIds;
    /**
     * Constructor method for BizAction.Sale.PriceListBulkUpdate.Request
     * @uses BizAction_Sale_PriceListBulkUpdate_Request::setFileType()
     * @uses BizAction_Sale_PriceListBulkUpdate_Request::setMatrixPriceListId()
     * @uses BizAction_Sale_PriceListBulkUpdate_Request::setPriceListIds()
     * @param string $fileType
     * @param string $matrixPriceListId
     * @param \patest\StructType\PriceListIds $priceListIds
     */
    public function __construct($fileType = null, $matrixPriceListId = null, \patest\StructType\PriceListIds $priceListIds = null)
    {
        $this
            ->setFileType($fileType)
            ->setMatrixPriceListId($matrixPriceListId)
            ->setPriceListIds($priceListIds);
    }
    /**
     * Get FileType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileType()
    {
        return isset($this->FileType) ? $this->FileType : null;
    }
    /**
     * Set FileType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceListFileType::valueIsValid()
     * @uses \patest\EnumType\PriceListFileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fileType
     * @return \patest\StructType\BizAction_Sale_PriceListBulkUpdate_Request
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceListFileType::valueIsValid($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceListFileType', is_array($fileType) ? implode(', ', $fileType) : var_export($fileType, true), implode(', ', \patest\EnumType\PriceListFileType::getValidValues())), __LINE__);
        }
        if (is_null($fileType) || (is_array($fileType) && empty($fileType))) {
            unset($this->FileType);
        } else {
            $this->FileType = $fileType;
        }
        return $this;
    }
    /**
     * Get MatrixPriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatrixPriceListId()
    {
        return isset($this->MatrixPriceListId) ? $this->MatrixPriceListId : null;
    }
    /**
     * Set MatrixPriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $matrixPriceListId
     * @return \patest\StructType\BizAction_Sale_PriceListBulkUpdate_Request
     */
    public function setMatrixPriceListId($matrixPriceListId = null)
    {
        // validation for constraint: string
        if (!is_null($matrixPriceListId) && !is_string($matrixPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matrixPriceListId, true), gettype($matrixPriceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($matrixPriceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $matrixPriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($matrixPriceListId, true)), __LINE__);
        }
        if (is_null($matrixPriceListId) || (is_array($matrixPriceListId) && empty($matrixPriceListId))) {
            unset($this->MatrixPriceListId);
        } else {
            $this->MatrixPriceListId = $matrixPriceListId;
        }
        return $this;
    }
    /**
     * Get PriceListIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceListIds|null
     */
    public function getPriceListIds()
    {
        return isset($this->PriceListIds) ? $this->PriceListIds : null;
    }
    /**
     * Set PriceListIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceListIds $priceListIds
     * @return \patest\StructType\BizAction_Sale_PriceListBulkUpdate_Request
     */
    public function setPriceListIds(\patest\StructType\PriceListIds $priceListIds = null)
    {
        if (is_null($priceListIds) || (is_array($priceListIds) && empty($priceListIds))) {
            unset($this->PriceListIds);
        } else {
            $this->PriceListIds = $priceListIds;
        }
        return $this;
    }
}
